/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.util.DataChecksum;
import org.junit.Assert;
import org.junit.Test;

public class TestDataChecksum {
    private static final int SUMS_OFFSET_IN_BUFFER = 3;
    private static final int DATA_OFFSET_IN_BUFFER = 3;
    private static final int DATA_TRAILER_IN_BUFFER = 3;
    private static final int BYTES_PER_CHUNK = 512;
    private static final int[] CHECKSUM_TYPES = new int[]{1, 2};

    @Test
    public void testBulkOps() throws Exception {
        for (int type : CHECKSUM_TYPES) {
            System.err.println("---- beginning tests with checksum type " + type + "----");
            DataChecksum checksum = DataChecksum.newDataChecksum((int)type, (int)512);
            for (boolean useDirect : new boolean[]{false, true}) {
                this.doBulkTest(checksum, 1023, useDirect);
                this.doBulkTest(checksum, 1024, useDirect);
                this.doBulkTest(checksum, 1025, useDirect);
            }
        }
    }

    private void doBulkTest(DataChecksum checksum, int dataLength, boolean useDirect) throws Exception {
        System.err.println("Testing bulk checksums of length " + dataLength + " with " + (useDirect ? "direct" : "array-backed") + " buffers");
        int numSums = (dataLength - 1) / checksum.getBytesPerChecksum() + 1;
        int sumsLength = numSums * checksum.getChecksumSize();
        byte[] data = new byte[dataLength + 3 + 3];
        new Random().nextBytes(data);
        ByteBuffer dataBuf = ByteBuffer.wrap(data, 3, dataLength);
        byte[] checksums = new byte[3 + sumsLength];
        ByteBuffer checksumBuf = ByteBuffer.wrap(checksums, 3, sumsLength);
        if (useDirect) {
            dataBuf = TestDataChecksum.directify(dataBuf);
            checksumBuf = TestDataChecksum.directify(checksumBuf);
        }
        checksum.calculateChunkedSums(dataBuf, checksumBuf);
        checksum.verifyChunkedSums(dataBuf, checksumBuf, "fake file", 0L);
        TestDataChecksum.corruptBufferOffset(checksumBuf, 0);
        checksum.verifyChunkedSums(dataBuf, checksumBuf, "fake file", 0L);
        TestDataChecksum.corruptBufferOffset(dataBuf, 0);
        dataBuf.limit(dataBuf.limit() + 1);
        TestDataChecksum.corruptBufferOffset(dataBuf, dataLength + 3);
        dataBuf.limit(dataBuf.limit() - 1);
        checksum.verifyChunkedSums(dataBuf, checksumBuf, "fake file", 0L);
        TestDataChecksum.corruptBufferOffset(checksumBuf, 3);
        try {
            checksum.verifyChunkedSums(dataBuf, checksumBuf, "fake file", 0L);
            Assert.fail((String)"Did not throw on bad checksums");
        }
        catch (ChecksumException ce) {
            Assert.assertEquals((long)0L, (long)ce.getPos());
        }
        TestDataChecksum.uncorruptBufferOffset(checksumBuf, 3);
        TestDataChecksum.corruptBufferOffset(checksumBuf, 3 + sumsLength - 1);
        try {
            checksum.verifyChunkedSums(dataBuf, checksumBuf, "fake file", 0L);
            Assert.fail((String)"Did not throw on bad checksums");
        }
        catch (ChecksumException ce) {
            int expectedPos = checksum.getBytesPerChecksum() * (numSums - 1);
            Assert.assertEquals((long)expectedPos, (long)ce.getPos());
            Assert.assertTrue((boolean)ce.getMessage().contains("fake file"));
        }
    }

    @Test
    public void testEquality() {
        Assert.assertEquals((Object)DataChecksum.newDataChecksum((int)1, (int)512), (Object)DataChecksum.newDataChecksum((int)1, (int)512));
        Assert.assertFalse((boolean)DataChecksum.newDataChecksum((int)1, (int)512).equals((Object)DataChecksum.newDataChecksum((int)1, (int)1024)));
        Assert.assertFalse((boolean)DataChecksum.newDataChecksum((int)1, (int)512).equals((Object)DataChecksum.newDataChecksum((int)2, (int)512)));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"DataChecksum(type=CRC32, chunkSize=512)", (Object)DataChecksum.newDataChecksum((int)1, (int)512).toString());
    }

    private static void corruptBufferOffset(ByteBuffer buf, int offset) {
        buf.put(offset, (byte)(buf.get(offset) + 1));
    }

    private static void uncorruptBufferOffset(ByteBuffer buf, int offset) {
        buf.put(offset, (byte)(buf.get(offset) - 1));
    }

    private static ByteBuffer directify(ByteBuffer dataBuf) {
        ByteBuffer newBuf = ByteBuffer.allocateDirect(dataBuf.capacity());
        newBuf.position(dataBuf.position());
        newBuf.mark();
        newBuf.put(dataBuf);
        newBuf.reset();
        newBuf.limit(dataBuf.limit());
        return newBuf;
    }
}

