/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.MockitoMaker;
import org.apache.hadoop.util.DiskChecker;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDiskChecker {
    final FsPermission defaultPerm = new FsPermission("755");
    final FsPermission invalidPerm = new FsPermission("000");

    @Test
    public void testMkdirs_dirExists() throws Throwable {
        this._mkdirs(true, this.defaultPerm, this.defaultPerm);
    }

    @Test
    public void testMkdirs_noDir() throws Throwable {
        this._mkdirs(false, this.defaultPerm, this.defaultPerm);
    }

    @Test
    public void testMkdirs_dirExists_badUmask() throws Throwable {
        this._mkdirs(true, this.defaultPerm, this.invalidPerm);
    }

    @Test
    public void testMkdirs_noDir_badUmask() throws Throwable {
        this._mkdirs(false, this.defaultPerm, this.invalidPerm);
    }

    private void _mkdirs(boolean exists, FsPermission before, FsPermission after) throws Throwable {
        block4: {
            File localDir = (File)MockitoMaker.make(((File)MockitoMaker.stub(File.class).returning((Object)Boolean.valueOf((boolean)exists)).from).exists());
            Mockito.when((Object)localDir.mkdir()).thenReturn((Object)true);
            Path dir = (Path)Mockito.mock(Path.class);
            LocalFileSystem fs = (LocalFileSystem)MockitoMaker.make(((LocalFileSystem)MockitoMaker.stub(LocalFileSystem.class).returning((Object)localDir).from).pathToFile(dir));
            FileStatus stat = (FileStatus)MockitoMaker.make(((FileStatus)MockitoMaker.stub(FileStatus.class).returning((Object)after).from).getPermission());
            Mockito.when((Object)fs.getFileStatus(dir)).thenReturn((Object)stat);
            try {
                DiskChecker.mkdirsWithExistsAndPermissionCheck((LocalFileSystem)fs, (Path)dir, (FsPermission)before);
                if (!exists) {
                    ((LocalFileSystem)Mockito.verify((Object)fs)).setPermission(dir, before);
                } else {
                    ((LocalFileSystem)Mockito.verify((Object)fs)).getFileStatus(dir);
                    ((FileStatus)Mockito.verify((Object)stat)).getPermission();
                }
            }
            catch (DiskChecker.DiskErrorException e) {
                if (before == after) break block4;
                Assert.assertTrue((boolean)e.getMessage().startsWith("Incorrect permission"));
            }
        }
    }

    @Test
    public void testCheckDir_normal() throws Throwable {
        this._checkDirs(true, new FsPermission("755"), true);
    }

    @Test
    public void testCheckDir_notDir() throws Throwable {
        this._checkDirs(false, new FsPermission("000"), false);
    }

    @Test
    public void testCheckDir_notReadable() throws Throwable {
        this._checkDirs(true, new FsPermission("000"), false);
    }

    @Test
    public void testCheckDir_notWritable() throws Throwable {
        this._checkDirs(true, new FsPermission("444"), false);
    }

    @Test
    public void testCheckDir_notListable() throws Throwable {
        this._checkDirs(true, new FsPermission("666"), false);
    }

    private void _checkDirs(boolean isDir, FsPermission perm, boolean success) throws Throwable {
        File localDir = (File)MockitoMaker.make(((File)MockitoMaker.stub(File.class).returning((Object)Boolean.valueOf((boolean)true)).from).exists());
        Mockito.when((Object)localDir.mkdir()).thenReturn((Object)true);
        Path dir = (Path)Mockito.mock(Path.class);
        LocalFileSystem fs = (LocalFileSystem)MockitoMaker.make(((LocalFileSystem)MockitoMaker.stub(LocalFileSystem.class).returning((Object)localDir).from).pathToFile(dir));
        FileStatus stat = (FileStatus)MockitoMaker.make(((FileStatus)MockitoMaker.stub(FileStatus.class).returning((Object)perm).from).getPermission());
        Mockito.when((Object)stat.isDirectory()).thenReturn((Object)isDir);
        Mockito.when((Object)fs.getFileStatus(dir)).thenReturn((Object)stat);
        try {
            DiskChecker.checkDir((LocalFileSystem)fs, (Path)dir, (FsPermission)perm);
            ((FileStatus)Mockito.verify((Object)stat)).isDirectory();
            ((LocalFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)2))).getFileStatus(dir);
            ((FileStatus)Mockito.verify((Object)stat, (VerificationMode)Mockito.times((int)2))).getPermission();
            Assert.assertTrue((String)"checkDir success", (boolean)success);
        }
        catch (DiskChecker.DiskErrorException e) {
            Assert.assertFalse((String)"checkDir success", (boolean)success);
            e.printStackTrace();
        }
        System.out.println("checkDir success: " + success);
    }
}

