/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FsServerDefaults
implements Writable {
    private long blockSize;
    private int bytesPerChecksum;
    private int writePacketSize;
    private short replication;
    private int fileBufferSize;
    private boolean encryptDataTransfer;
    private long trashInterval;

    public FsServerDefaults() {
    }

    public FsServerDefaults(long blockSize, int bytesPerChecksum, int writePacketSize, short replication, int fileBufferSize, boolean encryptDataTransfer, long trashInterval) {
        this.blockSize = blockSize;
        this.bytesPerChecksum = bytesPerChecksum;
        this.writePacketSize = writePacketSize;
        this.replication = replication;
        this.fileBufferSize = fileBufferSize;
        this.encryptDataTransfer = encryptDataTransfer;
        this.trashInterval = trashInterval;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public int getBytesPerChecksum() {
        return this.bytesPerChecksum;
    }

    public int getWritePacketSize() {
        return this.writePacketSize;
    }

    public short getReplication() {
        return this.replication;
    }

    public int getFileBufferSize() {
        return this.fileBufferSize;
    }

    public boolean getEncryptDataTransfer() {
        return this.encryptDataTransfer;
    }

    public long getTrashInterval() {
        return this.trashInterval;
    }

    @Override
    @InterfaceAudience.Private
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.blockSize);
        out.writeInt(this.bytesPerChecksum);
        out.writeInt(this.writePacketSize);
        out.writeShort(this.replication);
        out.writeInt(this.fileBufferSize);
    }

    @Override
    @InterfaceAudience.Private
    public void readFields(DataInput in) throws IOException {
        this.blockSize = in.readLong();
        this.bytesPerChecksum = in.readInt();
        this.writePacketSize = in.readInt();
        this.replication = in.readShort();
        this.fileBufferSize = in.readInt();
    }

    static {
        WritableFactories.setFactory(FsServerDefaults.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new FsServerDefaults();
            }
        });
    }
}

