/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import com.cloudera.org.jets3t.service.S3Service;
import com.cloudera.org.jets3t.service.S3ServiceException;
import com.cloudera.org.jets3t.service.ServiceException;
import com.cloudera.org.jets3t.service.StorageObjectsChunk;
import com.cloudera.org.jets3t.service.impl.rest.httpclient.RestS3Service;
import com.cloudera.org.jets3t.service.model.MultipartPart;
import com.cloudera.org.jets3t.service.model.MultipartUpload;
import com.cloudera.org.jets3t.service.model.S3Bucket;
import com.cloudera.org.jets3t.service.model.S3Object;
import com.cloudera.org.jets3t.service.model.StorageObject;
import com.cloudera.org.jets3t.service.security.AWSCredentials;
import com.cloudera.org.jets3t.service.security.ProviderCredentials;
import com.cloudera.org.jets3t.service.utils.MultipartUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3.S3Credentials;
import org.apache.hadoop.fs.s3.S3Exception;
import org.apache.hadoop.fs.s3native.FileMetadata;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.PartialListing;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Jets3tNativeFileSystemStore
implements NativeFileSystemStore {
    private S3Service s3Service;
    private S3Bucket bucket;
    private long multipartBlockSize;
    private boolean multipartEnabled;
    private long multipartCopyBlockSize;
    static final long MAX_PART_SIZE = 0x140000000L;
    public static final Log LOG = LogFactory.getLog(Jets3tNativeFileSystemStore.class);

    Jets3tNativeFileSystemStore() {
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        S3Credentials s3Credentials = new S3Credentials();
        s3Credentials.initialize(uri, conf);
        try {
            AWSCredentials awsCredentials = new AWSCredentials(s3Credentials.getAccessKey(), s3Credentials.getSecretAccessKey());
            this.s3Service = new RestS3Service((ProviderCredentials)awsCredentials);
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
        }
        this.multipartEnabled = conf.getBoolean("fs.s3n.multipart.uploads.enabled", false);
        this.multipartBlockSize = Math.min(conf.getLong("fs.s3n.multipart.uploads.block.size", 0x4000000L), 0x140000000L);
        this.multipartCopyBlockSize = Math.min(conf.getLong("fs.s3n.multipart.copy.block.size", 0x140000000L), 0x140000000L);
        this.bucket = new S3Bucket(uri.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeFile(String key, File file, byte[] md5Hash) throws IOException {
        if (this.multipartEnabled && file.length() >= this.multipartBlockSize) {
            this.storeLargeFile(key, file, md5Hash);
            return;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            S3Object object = new S3Object(key);
            object.setDataInputStream((InputStream)in);
            object.setContentType("binary/octet-stream");
            object.setContentLength(file.length());
            if (md5Hash != null) {
                object.setMd5Hash(md5Hash);
            }
            this.s3Service.putObject(this.bucket, object);
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void storeLargeFile(String key, File file, byte[] md5Hash) throws IOException {
        S3Object object = new S3Object(key);
        object.setDataInputFile(file);
        object.setContentType("binary/octet-stream");
        object.setContentLength(file.length());
        if (md5Hash != null) {
            object.setMd5Hash(md5Hash);
        }
        ArrayList<S3Object> objectsToUploadAsMultipart = new ArrayList<S3Object>();
        objectsToUploadAsMultipart.add(object);
        MultipartUtils mpUtils = new MultipartUtils(this.multipartBlockSize);
        try {
            mpUtils.uploadObjects(this.bucket.getName(), this.s3Service, objectsToUploadAsMultipart, null);
        }
        catch (ServiceException e) {
            this.handleServiceException(e);
        }
        catch (Exception e) {
            throw new S3Exception(e);
        }
    }

    @Override
    public void storeEmptyFile(String key) throws IOException {
        try {
            S3Object object = new S3Object(key);
            object.setDataInputStream((InputStream)new ByteArrayInputStream(new byte[0]));
            object.setContentType("binary/octet-stream");
            object.setContentLength(0L);
            this.s3Service.putObject(this.bucket, object);
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileMetadata retrieveMetadata(String key) throws IOException {
        StorageObject object = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting metadata for key: " + key + " from bucket:" + this.bucket.getName()));
            }
            object = this.s3Service.getObjectDetails(this.bucket.getName(), key);
            FileMetadata fileMetadata = new FileMetadata(key, object.getContentLength(), object.getLastModifiedDate().getTime());
            return fileMetadata;
        }
        catch (ServiceException e) {
            if ("NoSuchKey".equals(e.getErrorCode())) {
                FileMetadata fileMetadata = null;
                return fileMetadata;
            }
            this.handleServiceException(e);
            FileMetadata fileMetadata = null;
            return fileMetadata;
        }
        finally {
            if (object != null) {
                object.closeDataInputStream();
            }
        }
    }

    @Override
    public InputStream retrieve(String key) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting key: " + key + " from bucket:" + this.bucket.getName()));
            }
            S3Object object = this.s3Service.getObject(this.bucket.getName(), key);
            return object.getDataInputStream();
        }
        catch (ServiceException e) {
            this.handleServiceException(key, e);
            return null;
        }
    }

    @Override
    public InputStream retrieve(String key, long byteRangeStart) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting key: " + key + " from bucket:" + this.bucket.getName() + " with byteRangeStart: " + byteRangeStart));
            }
            S3Object object = this.s3Service.getObject(this.bucket, key, null, null, null, null, Long.valueOf(byteRangeStart), null);
            return object.getDataInputStream();
        }
        catch (ServiceException e) {
            this.handleServiceException(key, e);
            return null;
        }
    }

    @Override
    public PartialListing list(String prefix, int maxListingLength) throws IOException {
        return this.list(prefix, maxListingLength, null, false);
    }

    @Override
    public PartialListing list(String prefix, int maxListingLength, String priorLastKey, boolean recurse) throws IOException {
        return this.list(prefix, recurse ? null : "/", maxListingLength, priorLastKey);
    }

    private PartialListing list(String prefix, String delimiter, int maxListingLength, String priorLastKey) throws IOException {
        try {
            if (prefix.length() > 0 && !prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            StorageObjectsChunk chunk = this.s3Service.listObjectsChunked(this.bucket.getName(), prefix, delimiter, (long)maxListingLength, priorLastKey);
            FileMetadata[] fileMetadata = new FileMetadata[chunk.getObjects().length];
            for (int i = 0; i < fileMetadata.length; ++i) {
                StorageObject object = chunk.getObjects()[i];
                fileMetadata[i] = new FileMetadata(object.getKey(), object.getContentLength(), object.getLastModifiedDate().getTime());
            }
            return new PartialListing(chunk.getPriorLastKey(), fileMetadata, chunk.getCommonPrefixes());
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
            return null;
        }
        catch (ServiceException e) {
            this.handleServiceException(e);
            return null;
        }
    }

    @Override
    public void delete(String key) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting key:" + key + "from bucket" + this.bucket.getName()));
            }
            this.s3Service.deleteObject(this.bucket, key);
        }
        catch (ServiceException e) {
            this.handleServiceException(key, e);
        }
    }

    public void rename(String srcKey, String dstKey) throws IOException {
        try {
            this.s3Service.renameObject(this.bucket.getName(), srcKey, (StorageObject)new S3Object(dstKey));
        }
        catch (ServiceException e) {
            this.handleServiceException(e);
        }
    }

    @Override
    public void copy(String srcKey, String dstKey) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Copying srcKey: " + srcKey + "to dstKey: " + dstKey + "in bucket: " + this.bucket.getName()));
            }
            if (this.multipartEnabled) {
                S3Object object = this.s3Service.getObjectDetails(this.bucket, srcKey, null, null, null, null);
                if (this.multipartCopyBlockSize > 0L && object.getContentLength() > this.multipartCopyBlockSize) {
                    this.copyLargeFile(object, dstKey);
                    return;
                }
            }
            this.s3Service.copyObject(this.bucket.getName(), srcKey, this.bucket.getName(), (StorageObject)new S3Object(dstKey), false);
        }
        catch (ServiceException e) {
            this.handleServiceException(srcKey, e);
        }
    }

    public void copyLargeFile(S3Object srcObject, String dstKey) throws IOException {
        try {
            long partCount = srcObject.getContentLength() / this.multipartCopyBlockSize + (long)(srcObject.getContentLength() % this.multipartCopyBlockSize > 0L ? 1 : 0);
            MultipartUpload multipartUpload = this.s3Service.multipartStartUpload(this.bucket.getName(), dstKey, srcObject.getMetadataMap());
            ArrayList<MultipartPart> listedParts = new ArrayList<MultipartPart>();
            int i = 0;
            while ((long)i < partCount) {
                long byteLength;
                long byteRangeStart = (long)i * this.multipartCopyBlockSize;
                if ((long)i < partCount - 1L) {
                    byteLength = this.multipartCopyBlockSize;
                } else {
                    byteLength = srcObject.getContentLength() % this.multipartCopyBlockSize;
                    if (byteLength == 0L) {
                        byteLength = this.multipartCopyBlockSize;
                    }
                }
                MultipartPart copiedPart = this.s3Service.multipartUploadPartCopy(multipartUpload, Integer.valueOf(i + 1), this.bucket.getName(), srcObject.getKey(), null, null, null, null, Long.valueOf(byteRangeStart), Long.valueOf(byteRangeStart + byteLength - 1L), null);
                listedParts.add(copiedPart);
                ++i;
            }
            Collections.reverse(listedParts);
            this.s3Service.multipartCompleteUpload(multipartUpload, listedParts);
        }
        catch (ServiceException e) {
            this.handleServiceException(e);
        }
    }

    @Override
    public void purge(String prefix) throws IOException {
        try {
            S3Object[] objects;
            for (S3Object object : objects = this.s3Service.listObjects(this.bucket.getName(), prefix, null)) {
                this.s3Service.deleteObject(this.bucket, object.getKey());
            }
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
        }
    }

    @Override
    public void dump() throws IOException {
        StringBuilder sb = new StringBuilder("S3 Native Filesystem, ");
        sb.append(this.bucket.getName()).append("\n");
        try {
            S3Object[] objects;
            for (S3Object object : objects = this.s3Service.listObjects(this.bucket.getName())) {
                sb.append(object.getKey()).append("\n");
            }
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
        }
        System.out.println(sb);
    }

    private void handleServiceException(String key, ServiceException e) throws IOException {
        if ("NoSuchKey".equals(e.getErrorCode())) {
            throw new FileNotFoundException("Key '" + key + "' does not exist in S3");
        }
        this.handleServiceException(e);
    }

    private void handleS3ServiceException(S3ServiceException e) throws IOException {
        if (e.getCause() instanceof IOException) {
            throw (IOException)e.getCause();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("S3 Error code: " + e.getS3ErrorCode() + "; S3 Error message: " + e.getS3ErrorMessage()));
        }
        throw new S3Exception(e);
    }

    private void handleServiceException(ServiceException e) throws IOException {
        if (e.getCause() instanceof IOException) {
            throw (IOException)e.getCause();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got ServiceException with Error code: " + e.getErrorCode() + ";and Error message: " + e.getErrorMessage()));
        }
    }
}

