/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.RemoteBlockReader;
import org.apache.hadoop.hdfs.RemoteBlockReader2;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class BlockReaderFactory {
    public static BlockReader newBlockReader(Configuration conf, Socket sock, String file, ExtendedBlock block, Token<BlockTokenIdentifier> blockToken, long startOffset, long len) throws IOException {
        int bufferSize = conf.getInt("io.file.buffer.size", 4096);
        return BlockReaderFactory.newBlockReader(new DFSClient.Conf(conf), sock, file, block, blockToken, startOffset, len, bufferSize, true, "");
    }

    public static BlockReader newBlockReader(DFSClient.Conf conf, Socket sock, String file, ExtendedBlock block, Token<BlockTokenIdentifier> blockToken, long startOffset, long len, int bufferSize, boolean verifyChecksum, String clientName) throws IOException {
        if (conf.useLegacyBlockReader) {
            return RemoteBlockReader.newBlockReader(sock, file, block, blockToken, startOffset, len, bufferSize, verifyChecksum, clientName);
        }
        return RemoteBlockReader2.newBlockReader(sock, file, block, blockToken, startOffset, len, bufferSize, verifyChecksum, clientName);
    }

    public static String getFileName(InetSocketAddress s, String poolId, long blockId) {
        return s.toString() + ":" + poolId + ":" + blockId;
    }
}

