/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocol.proto.JournalProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.JournalProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.JournalProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.BackupImage;
import org.apache.hadoop.hdfs.server.namenode.Checkpointer;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.protocol.JournalProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class BackupNode
extends NameNode {
    private static final String BN_ADDRESS_NAME_KEY = "dfs.namenode.backup.address";
    private static final String BN_ADDRESS_DEFAULT = "localhost:50100";
    private static final String BN_HTTP_ADDRESS_NAME_KEY = "dfs.namenode.backup.http-address";
    private static final String BN_HTTP_ADDRESS_DEFAULT = "0.0.0.0:50105";
    private static final String BN_SERVICE_RPC_ADDRESS_KEY = "dfs.namenode.backup.dnrpc-address";
    NamenodeProtocol namenode;
    String nnRpcAddress;
    String nnHttpAddress;
    Checkpointer checkpointManager;
    String clusterId;
    String blockPoolId;

    BackupNode(Configuration conf, HdfsServerConstants.NamenodeRole role) throws IOException {
        super(conf, role);
    }

    @Override
    protected InetSocketAddress getRpcServerAddress(Configuration conf) {
        String addr = conf.get(BN_ADDRESS_NAME_KEY, BN_ADDRESS_DEFAULT);
        return NetUtils.createSocketAddr((String)addr);
    }

    @Override
    protected InetSocketAddress getServiceRpcServerAddress(Configuration conf) {
        String addr = conf.get(BN_SERVICE_RPC_ADDRESS_KEY);
        if (addr == null || addr.isEmpty()) {
            return null;
        }
        return NetUtils.createSocketAddr((String)addr);
    }

    @Override
    protected void setRpcServerAddress(Configuration conf, InetSocketAddress addr) {
        conf.set(BN_ADDRESS_NAME_KEY, NetUtils.getHostPortString((InetSocketAddress)addr));
    }

    @Override
    protected void setRpcServiceServerAddress(Configuration conf, InetSocketAddress addr) {
        conf.set(BN_SERVICE_RPC_ADDRESS_KEY, NetUtils.getHostPortString((InetSocketAddress)addr));
    }

    @Override
    protected InetSocketAddress getHttpServerAddress(Configuration conf) {
        assert (this.getNameNodeAddress() != null) : "rpcAddress should be calculated first";
        String addr = conf.get(BN_HTTP_ADDRESS_NAME_KEY, BN_HTTP_ADDRESS_DEFAULT);
        return NetUtils.createSocketAddr((String)addr);
    }

    @Override
    protected void setHttpServerAddress(Configuration conf) {
        conf.set(BN_HTTP_ADDRESS_NAME_KEY, NetUtils.getHostPortString((InetSocketAddress)this.getHttpAddress()));
    }

    @Override
    protected void loadNamesystem(Configuration conf) throws IOException {
        BackupImage bnImage = new BackupImage(conf);
        this.namesystem = new FSNamesystem(conf, bnImage);
        bnImage.setNamesystem(this.namesystem);
        bnImage.recoverCreateRead();
    }

    @Override
    protected void initialize(Configuration conf) throws IOException {
        conf.setLong("fs.trash.interval", 0L);
        NamespaceInfo nsInfo = this.handshake(conf);
        super.initialize(conf);
        if (!this.namesystem.isInSafeMode()) {
            this.namesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        }
        this.namesystem.leaseManager.setLeasePeriod(60000L, Long.MAX_VALUE);
        this.clusterId = nsInfo.getClusterID();
        this.blockPoolId = nsInfo.getBlockPoolID();
        this.registerWith(nsInfo);
        this.runCheckpointDaemon(conf);
    }

    @Override
    protected NameNodeRpcServer createRpcServer(Configuration conf) throws IOException {
        return new BackupNodeRpcServer(conf, this);
    }

    @Override
    public void stop() {
        if (this.checkpointManager != null) {
            this.checkpointManager.shouldRun = false;
        }
        if (this.namenode != null && this.getRegistration() != null) {
            try {
                this.namenode.errorReport(this.getRegistration(), 1, "Shutting down.");
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to report to name-node.", (Throwable)e);
            }
        }
        if (this.namenode != null) {
            RPC.stopProxy((Object)this.namenode);
        }
        this.namenode = null;
        if (this.checkpointManager != null) {
            this.checkpointManager.interrupt();
            this.checkpointManager = null;
        }
        this.getFSImage().getEditLog().abortCurrentLogSegment();
        super.stop();
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        throw new UnsupportedActionException("setSafeMode");
    }

    boolean shouldCheckpointAtStartup() {
        FSImage fsImage = this.getFSImage();
        if (this.isRole(HdfsServerConstants.NamenodeRole.CHECKPOINT)) {
            assert (fsImage.getStorage().getNumStorageDirs() > 0);
            return !fsImage.getStorage().getStorageDir(0).getVersionFile().exists();
        }
        return true;
    }

    private NamespaceInfo handshake(Configuration conf) throws IOException {
        InetSocketAddress nnAddress = NameNode.getServiceAddress(conf, true);
        this.namenode = NameNodeProxies.createNonHAProxy(conf, nnAddress, NamenodeProtocol.class, UserGroupInformation.getCurrentUser(), true).getProxy();
        this.nnRpcAddress = NetUtils.getHostPortString((InetSocketAddress)nnAddress);
        this.nnHttpAddress = NetUtils.getHostPortString((InetSocketAddress)super.getHttpServerAddress(conf));
        NamespaceInfo nsInfo = null;
        while (!this.isStopRequested()) {
            try {
                nsInfo = BackupNode.handshake(this.namenode);
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + nnAddress));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)"Encountered exception ", (Throwable)e);
                }
            }
        }
        return nsInfo;
    }

    private void runCheckpointDaemon(Configuration conf) throws IOException {
        this.checkpointManager = new Checkpointer(conf, this);
        this.checkpointManager.start();
    }

    void doCheckpoint() throws IOException {
        this.checkpointManager.doCheckpoint();
    }

    private void registerWith(NamespaceInfo nsInfo) throws IOException {
        BackupImage bnImage = (BackupImage)this.getFSImage();
        NNStorage storage = bnImage.getStorage();
        if (storage.getNamespaceID() == 0) {
            storage.setStorageInfo(nsInfo);
            storage.setBlockPoolID(nsInfo.getBlockPoolID());
            storage.setClusterID(nsInfo.getClusterID());
        } else {
            nsInfo.validateStorage(storage);
        }
        this.setRegistration();
        NamenodeRegistration nnReg = null;
        while (!this.isStopRequested()) {
            try {
                nnReg = this.namenode.register(this.getRegistration());
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to name-node: " + this.nnRpcAddress));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)"Encountered exception ", (Throwable)e);
                }
            }
        }
        String msg = null;
        if (nnReg == null) {
            msg = "Registration rejected by " + this.nnRpcAddress;
        } else if (!nnReg.isRole(HdfsServerConstants.NamenodeRole.NAMENODE)) {
            msg = "Name-node " + this.nnRpcAddress + " is not active";
        }
        if (msg != null) {
            msg = msg + ". Shutting down.";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        this.nnRpcAddress = nnReg.getAddress();
    }

    private static NamespaceInfo handshake(NamenodeProtocol namenode) throws IOException, SocketTimeoutException {
        NamespaceInfo nsInfo = namenode.versionRequest();
        String errorMsg = null;
        if (!nsInfo.getBuildVersion().equals(Storage.getBuildVersion())) {
            errorMsg = "Incompatible build versions: active name-node BV = " + nsInfo.getBuildVersion() + "; backup node BV = " + Storage.getBuildVersion();
            LOG.fatal((Object)errorMsg);
            throw new IOException(errorMsg);
        }
        assert (HdfsConstants.LAYOUT_VERSION == nsInfo.getLayoutVersion()) : "Active and backup node layout versions must be the same. Expected: " + HdfsConstants.LAYOUT_VERSION + " actual " + nsInfo.getLayoutVersion();
        return nsInfo;
    }

    String getBlockPoolId() {
        return this.blockPoolId;
    }

    String getClusterId() {
        return this.clusterId;
    }

    @Override
    protected NameNode.NameNodeHAContext createHAContext() {
        return new BNHAContext();
    }

    @Override
    protected String getNameServiceId(Configuration conf) {
        return DFSUtil.getBackupNameServiceId(conf);
    }

    private class BNHAContext
    extends NameNode.NameNodeHAContext {
        private BNHAContext() {
        }

        @Override
        public void checkOperation(NameNode.OperationCategory op) throws StandbyException {
            if (op == NameNode.OperationCategory.UNCHECKED || op == NameNode.OperationCategory.CHECKPOINT) {
                return;
            }
            if (!(NameNode.OperationCategory.JOURNAL == op || NameNode.OperationCategory.READ == op && BackupNode.this.allowStaleStandbyReads)) {
                String msg = "Operation category " + (Object)((Object)op) + " is not supported at the BackupNode";
                throw new StandbyException(msg);
            }
        }
    }

    static class BackupNodeRpcServer
    extends NameNodeRpcServer
    implements JournalProtocol {
        private BackupNodeRpcServer(Configuration conf, BackupNode nn) throws IOException {
            super(conf, nn);
            JournalProtocolServerSideTranslatorPB journalProtocolTranslator = new JournalProtocolServerSideTranslatorPB(this);
            BlockingService service = JournalProtocolProtos.JournalProtocolService.newReflectiveBlockingService(journalProtocolTranslator);
            DFSUtil.addPBProtocol(conf, JournalProtocolPB.class, service, this.clientRpcServer);
        }

        void verifyJournalRequest(NamenodeRegistration reg) throws IOException {
            this.verifyLayoutVersion(reg.getLayoutVersion());
            String errorMsg = null;
            int expectedNamespaceID = this.namesystem.getNamespaceInfo().getNamespaceID();
            if (reg.getNamespaceID() != expectedNamespaceID) {
                errorMsg = "Invalid namespaceID in journal request - expected " + expectedNamespaceID + " actual " + reg.getNamespaceID();
                NameNode.LOG.warn((Object)errorMsg);
                throw new UnregisteredNodeException(reg);
            }
            if (!reg.getClusterID().equals(this.namesystem.getClusterId())) {
                errorMsg = "Invalid clusterId in journal request - expected " + reg.getClusterID() + " actual " + this.namesystem.getClusterId();
                NameNode.LOG.warn((Object)errorMsg);
                throw new UnregisteredNodeException(reg);
            }
        }

        @Override
        public void startLogSegment(NamenodeRegistration registration, long txid) throws IOException {
            this.namesystem.checkOperation(NameNode.OperationCategory.JOURNAL);
            this.verifyJournalRequest(registration);
            this.getBNImage().namenodeStartedLogSegment(txid);
        }

        @Override
        public void journal(NamenodeRegistration nnReg, long firstTxId, int numTxns, byte[] records) throws IOException {
            this.namesystem.checkOperation(NameNode.OperationCategory.JOURNAL);
            this.verifyJournalRequest(nnReg);
            this.getBNImage().journal(firstTxId, numTxns, records);
        }

        private BackupImage getBNImage() {
            return (BackupImage)this.nn.getFSImage();
        }
    }
}

