/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public class CheckpointConf {
    private static final Log LOG = LogFactory.getLog(CheckpointConf.class);
    private final long checkpointPeriod;
    private final long checkpointCheckPeriod;
    private final long checkpointTxnCount;

    public CheckpointConf(Configuration conf) {
        this.checkpointCheckPeriod = conf.getLong("dfs.namenode.checkpoint.check.period", 60L);
        this.checkpointPeriod = conf.getLong("dfs.namenode.checkpoint.period", 3600L);
        this.checkpointTxnCount = conf.getLong("dfs.namenode.checkpoint.txns", 40000L);
        CheckpointConf.warnForDeprecatedConfigs(conf);
    }

    private static void warnForDeprecatedConfigs(Configuration conf) {
        for (String key : ImmutableList.of((Object)"fs.checkpoint.size", (Object)"dfs.namenode.checkpoint.size")) {
            if (conf.get(key) == null) continue;
            LOG.warn((Object)("Configuration key " + key + " is deprecated! Ignoring..." + " Instead please specify a value for " + "dfs.namenode.checkpoint.txns"));
        }
    }

    public long getPeriod() {
        return this.checkpointPeriod;
    }

    public long getCheckPeriod() {
        return Math.min(this.checkpointCheckPeriod, this.checkpointPeriod);
    }

    public long getTxnCount() {
        return this.checkpointTxnCount;
    }
}

