/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class TestViewFileSystemAtHdfsRoot
extends ViewFileSystemBaseTest {
    private static MiniDFSCluster cluster;
    private static Configuration CONF;
    private static FileSystem fHdfs;

    @BeforeClass
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        SupportsBlocks = true;
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(CONF).numDataNodes(2).build();
        cluster.waitClusterUp();
        fHdfs = cluster.getFileSystem();
    }

    @AfterClass
    public static void clusterShutdownAtEnd() throws Exception {
        cluster.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fHdfs;
        super.setUp();
    }

    void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = fHdfs.makeQualified(new Path("/"));
        for (FileStatus status : fHdfs.listStatus(this.targetTestRoot)) {
            fHdfs.delete(status.getPath(), true);
        }
    }

    int getExpectedDelegationTokenCount() {
        return 8;
    }

    int getExpectedDelegationTokenCountWithCredentials() {
        return 1;
    }

    static {
        CONF = new Configuration();
    }
}

