/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.LimitedPrivate(value={"HBase", "HDFS", "Hive", "MapReduce", "Pig"})
@InterfaceStability.Unstable
public class MiniDFSCluster {
    private static final String NAMESERVICE_ID_PREFIX = "nameserviceId";
    private static final Log LOG = LogFactory.getLog(MiniDFSCluster.class);
    public static final String PROP_TEST_BUILD_DATA = "test.build.data";
    public static final String HDFS_MINIDFS_BASEDIR = "hdfs.minidfs.basedir";
    public static final String DFS_NAMENODE_SAFEMODE_EXTENSION_TESTING_KEY = "dfs.namenode.safemode.extension.testing";
    private Configuration conf;
    private NameNodeInfo[] nameNodes;
    private int numDataNodes;
    private ArrayList<DataNodeProperties> dataNodes = new ArrayList();
    private File base_dir;
    private File data_dir;
    private boolean waitSafeMode = true;
    private boolean federation;
    private boolean checkExitOnShutdown = true;
    private int instanceId;
    private static int instanceCount;

    private MiniDFSCluster(Builder builder) throws IOException {
        if (builder.nnTopology == null) {
            builder.nnTopology = MiniDFSNNTopology.simpleSingleNN(builder.nameNodePort, builder.nameNodeHttpPort);
        }
        LOG.info((Object)("starting cluster with " + builder.nnTopology.countNameNodes() + " namenodes."));
        this.nameNodes = new NameNodeInfo[builder.nnTopology.countNameNodes()];
        this.initMiniDFSCluster(builder.conf, builder.numDataNodes, builder.format, builder.manageNameDfsDirs, builder.manageNameDfsSharedDirs, builder.enableManagedDfsDirsRedundancy, builder.manageDataDfsDirs, builder.option, builder.racks, builder.hosts, builder.simulatedCapacities, builder.clusterId, builder.waitSafeMode, builder.setupHostsFile, builder.nnTopology, builder.checkExitOnShutdown, builder.checkDataNodeHostConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiniDFSCluster() {
        this.nameNodes = new NameNodeInfo[0];
        Class<MiniDFSCluster> clazz = MiniDFSCluster.class;
        synchronized (MiniDFSCluster.class) {
            this.instanceId = instanceCount++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Deprecated
    public MiniDFSCluster(Configuration conf, int numDataNodes, HdfsServerConstants.StartupOption nameNodeOperation) throws IOException {
        this(0, conf, numDataNodes, false, false, false, nameNodeOperation, null, null, null);
    }

    @Deprecated
    public MiniDFSCluster(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        this(0, conf, numDataNodes, format, true, true, null, racks, null, null);
    }

    @Deprecated
    public MiniDFSCluster(Configuration conf, int numDataNodes, boolean format, String[] racks, String[] hosts) throws IOException {
        this(0, conf, numDataNodes, format, true, true, null, racks, hosts, null);
    }

    @Deprecated
    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks) throws IOException {
        this(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, null, null);
    }

    @Deprecated
    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        this(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, null, simulatedCapacities);
    }

    @Deprecated
    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageNameDfsDirs, boolean manageDataDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        this.nameNodes = new NameNodeInfo[1];
        this.initMiniDFSCluster(conf, numDataNodes, format, manageNameDfsDirs, true, manageDataDfsDirs, manageDataDfsDirs, operation, racks, hosts, simulatedCapacities, null, true, false, MiniDFSNNTopology.simpleSingleNN(nameNodePort, 0), true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMiniDFSCluster(Configuration conf, int numDataNodes, boolean format, boolean manageNameDfsDirs, boolean manageNameDfsSharedDirs, boolean enableManagedDfsDirsRedundancy, boolean manageDataDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, String clusterId, boolean waitSafeMode, boolean setupHostsFile, MiniDFSNNTopology nnTopology, boolean checkExitOnShutdown, boolean checkDataNodeHostConfig) throws IOException {
        ExitUtil.disableSystemExit();
        Class<MiniDFSCluster> clazz = MiniDFSCluster.class;
        synchronized (MiniDFSCluster.class) {
            this.instanceId = instanceCount++;
            // ** MonitorExit[var18_18] (shouldn't be in output)
            this.conf = conf;
            this.base_dir = new File(this.determineDfsBaseDir());
            this.data_dir = new File(this.base_dir, "data");
            this.waitSafeMode = waitSafeMode;
            this.checkExitOnShutdown = checkExitOnShutdown;
            int replication = conf.getInt("dfs.replication", 3);
            conf.setInt("dfs.replication", Math.min(replication, numDataNodes));
            int safemodeExtension = conf.getInt(DFS_NAMENODE_SAFEMODE_EXTENSION_TESTING_KEY, 0);
            conf.setInt("dfs.namenode.safemode.extension", safemodeExtension);
            conf.setInt("dfs.namenode.decommission.interval", 3);
            conf.setClass("net.topology.node.switch.mapping.impl", StaticMapping.class, DNSToSwitchMapping.class);
            if (!nnTopology.allHttpPortsSpecified() && nnTopology.isHA()) {
                LOG.info((Object)"MiniDFSCluster disabling checkpointing in the Standby node since no HTTP ports have been specified.");
                conf.setBoolean("dfs.ha.standby.checkpoints", false);
            }
            if (!nnTopology.allIpcPortsSpecified() && nnTopology.isHA()) {
                LOG.info((Object)"MiniDFSCluster disabling log-roll triggering in the Standby node since no IPC ports have been specified.");
                conf.setInt("dfs.ha.log-roll.period", -1);
            }
            this.federation = nnTopology.isFederated();
            this.createNameNodesAndSetConf(nnTopology, manageNameDfsDirs, manageNameDfsSharedDirs, enableManagedDfsDirsRedundancy, format, operation, clusterId, conf);
            if (format && this.data_dir.exists() && !FileUtil.fullyDelete((File)this.data_dir)) {
                throw new IOException("Cannot remove data directory: " + this.data_dir);
            }
            if (operation == HdfsServerConstants.StartupOption.RECOVER) {
                return;
            }
            this.startDataNodes(conf, numDataNodes, manageDataDfsDirs, operation, racks, hosts, simulatedCapacities, setupHostsFile, false, checkDataNodeHostConfig);
            this.waitClusterUp();
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
            return;
        }
    }

    private void createNameNodesAndSetConf(MiniDFSNNTopology nnTopology, boolean manageNameDfsDirs, boolean manageNameDfsSharedDirs, boolean enableManagedDfsDirsRedundancy, boolean format, HdfsServerConstants.StartupOption operation, String clusterId, Configuration conf) throws IOException {
        Preconditions.checkArgument((nnTopology.countNameNodes() > 0 ? 1 : 0) != 0, (Object)"empty NN topology: no namenodes specified!");
        if (!this.federation && nnTopology.countNameNodes() == 1) {
            MiniDFSNNTopology.NNConf onlyNN = nnTopology.getOnlyNameNode();
            conf.set("fs.defaultFS", "127.0.0.1:" + onlyNN.getIpcPort());
        }
        ArrayList allNsIds = Lists.newArrayList();
        for (MiniDFSNNTopology.NSConf nameservice : nnTopology.getNameservices()) {
            if (nameservice.getId() == null) continue;
            allNsIds.add(nameservice.getId());
        }
        if (!allNsIds.isEmpty()) {
            conf.set("dfs.nameservices", Joiner.on((String)",").join((Iterable)allNsIds));
        }
        int nnCounter = 0;
        for (MiniDFSNNTopology.NSConf nameservice : nnTopology.getNameservices()) {
            String nsId = nameservice.getId();
            Preconditions.checkArgument((!this.federation || nsId != null ? 1 : 0) != 0, (Object)"if there is more than one NS, they must have names");
            ArrayList nnIds = Lists.newArrayList();
            for (MiniDFSNNTopology.NNConf nn : nameservice.getNNs()) {
                nnIds.add(nn.getNnId());
                MiniDFSCluster.initNameNodeAddress(conf, nameservice.getId(), nn);
            }
            if (nnIds.size() > 1) {
                conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{nameservice.getId()}), Joiner.on((String)",").join((Iterable)nnIds));
                if (manageNameDfsSharedDirs) {
                    URI sharedEditsUri = this.getSharedEditsDir(nnCounter, nnCounter + nnIds.size() - 1);
                    conf.set("dfs.namenode.shared.edits.dir", sharedEditsUri.toString());
                }
            }
            int i = 0;
            Collection prevNNDirs = null;
            int nnCounterForFormat = nnCounter;
            for (MiniDFSNNTopology.NNConf nn : nameservice.getNNs()) {
                this.initNameNodeConf(conf, nsId, nn.getNnId(), manageNameDfsDirs, manageNameDfsDirs, nnCounterForFormat);
                Collection namespaceDirs = FSNamesystem.getNamespaceDirs((Configuration)conf);
                if (format) {
                    for (URI nameDirUri : namespaceDirs) {
                        File nameDir = new File(nameDirUri);
                        if (!nameDir.exists() || FileUtil.fullyDelete((File)nameDir)) continue;
                        throw new IOException("Could not fully delete " + nameDir);
                    }
                }
                boolean formatThisOne = format;
                if (format && i++ > 0) {
                    formatThisOne = false;
                    assert (null != prevNNDirs);
                    this.copyNameDirs(prevNNDirs, namespaceDirs, conf);
                }
                ++nnCounterForFormat;
                if (formatThisOne) {
                    DFSTestUtil.formatNameNode(conf);
                }
                prevNNDirs = namespaceDirs;
            }
            for (MiniDFSNNTopology.NNConf nn : nameservice.getNNs()) {
                this.initNameNodeConf(conf, nsId, nn.getNnId(), manageNameDfsDirs, enableManagedDfsDirsRedundancy, nnCounter);
                this.createNameNode(nnCounter++, conf, this.numDataNodes, false, operation, clusterId, nsId, nn.getNnId());
            }
        }
    }

    public URI getSharedEditsDir(int minNN, int maxNN) throws IOException {
        return MiniDFSCluster.formatSharedEditsDir(this.base_dir, minNN, maxNN);
    }

    public static URI formatSharedEditsDir(File baseDir, int minNN, int maxNN) throws IOException {
        return Util.fileAsURI((File)new File(baseDir, "shared-edits-" + minNN + "-through-" + maxNN));
    }

    public NameNodeInfo[] getNameNodeInfos() {
        return this.nameNodes;
    }

    private void initNameNodeConf(Configuration conf, String nameserviceId, String nnId, boolean manageNameDfsDirs, boolean enableManagedDfsDirsRedundancy, int nnIndex) throws IOException {
        if (nameserviceId != null) {
            conf.set("dfs.nameservice.id", nameserviceId);
        }
        if (nnId != null) {
            conf.set("dfs.ha.namenode.id", nnId);
        }
        if (manageNameDfsDirs) {
            if (enableManagedDfsDirsRedundancy) {
                conf.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.base_dir, "name" + (2 * nnIndex + 1))) + "," + Util.fileAsURI((File)new File(this.base_dir, "name" + (2 * nnIndex + 2))));
                conf.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(this.base_dir, "namesecondary" + (2 * nnIndex + 1))) + "," + Util.fileAsURI((File)new File(this.base_dir, "namesecondary" + (2 * nnIndex + 2))));
            } else {
                conf.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.base_dir, "name" + (2 * nnIndex + 1))).toString());
                conf.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(this.base_dir, "namesecondary" + (2 * nnIndex + 1))).toString());
            }
        }
    }

    private void copyNameDirs(Collection<URI> srcDirs, Collection<URI> dstDirs, Configuration dstConf) throws IOException {
        URI srcDir = (URI)Lists.newArrayList(srcDirs).get(0);
        FileSystem dstFS = FileSystem.getLocal((Configuration)dstConf).getRaw();
        for (URI dstDir : dstDirs) {
            Preconditions.checkArgument((!dstDir.equals(srcDir) ? 1 : 0) != 0);
            File dstDirF = new File(dstDir);
            if (dstDirF.exists() && !FileUtil.fullyDelete((File)dstDirF)) {
                throw new IOException("Unable to delete: " + dstDirF);
            }
            LOG.info((Object)("Copying namedir from primary node dir " + srcDir + " to " + dstDir));
            FileUtil.copy((File)new File(srcDir), (FileSystem)dstFS, (Path)new Path(dstDir), (boolean)false, (Configuration)dstConf);
        }
    }

    private static void initNameNodeAddress(Configuration conf, String nameserviceId, MiniDFSNNTopology.NNConf nnConf) {
        String key = DFSUtil.addKeySuffixes((String)"dfs.namenode.http-address", (String[])new String[]{nameserviceId, nnConf.getNnId()});
        conf.set(key, "127.0.0.1:" + nnConf.getHttpPort());
        key = DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{nameserviceId, nnConf.getNnId()});
        conf.set(key, "127.0.0.1:" + nnConf.getIpcPort());
    }

    private void createNameNode(int nnIndex, Configuration conf, int numDataNodes, boolean format, HdfsServerConstants.StartupOption operation, String clusterId, String nameserviceId, String nnId) throws IOException {
        String[] stringArray;
        if (format) {
            DFSTestUtil.formatNameNode(conf);
        }
        if (operation == HdfsServerConstants.StartupOption.UPGRADE) {
            operation.setClusterId(clusterId);
        }
        if (operation == null || operation == HdfsServerConstants.StartupOption.FORMAT || operation == HdfsServerConstants.StartupOption.REGULAR) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = operation.getName();
        }
        String[] args = stringArray;
        NameNode nn = NameNode.createNameNode((String[])args, (Configuration)conf);
        if (operation == HdfsServerConstants.StartupOption.RECOVER) {
            return;
        }
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{nameserviceId, nnId}), NetUtils.getHostPortString((InetSocketAddress)nn.getNameNodeAddress()));
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.http-address", (String[])new String[]{nameserviceId, nnId}), NetUtils.getHostPortString((InetSocketAddress)nn.getHttpAddress()));
        DFSUtil.setGenericConf((Configuration)conf, (String)nameserviceId, (String)nnId, (String[])new String[]{"dfs.namenode.http-address"});
        this.nameNodes[nnIndex] = new NameNodeInfo(nn, nameserviceId, nnId, new Configuration(conf));
    }

    public URI getURI() {
        this.checkSingleNameNode();
        return this.getURI(0);
    }

    public URI getURI(int nnIndex) {
        InetSocketAddress addr = this.nameNodes[nnIndex].nameNode.getNameNodeAddress();
        String hostPort = NetUtils.getHostPortString((InetSocketAddress)addr);
        URI uri = null;
        try {
            uri = new URI("hdfs://" + hostPort);
        }
        catch (URISyntaxException e) {
            NameNode.LOG.warn((Object)("unexpected URISyntaxException: " + e));
        }
        return uri;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public Configuration getConfiguration(int nnIndex) {
        return this.nameNodes[nnIndex].conf;
    }

    public void waitNameNodeUp(int nnIndex) {
        while (!this.isNameNodeUp(nnIndex)) {
            try {
                LOG.warn((Object)("Waiting for namenode at " + nnIndex + " to start..."));
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void waitClusterUp() {
        if (this.numDataNodes > 0) {
            while (!this.isClusterUp()) {
                try {
                    LOG.warn((Object)"Waiting for the Mini HDFS Cluster to start...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, hosts, simulatedCapacities, false);
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, hosts, simulatedCapacities, setupHostsFile, false, false);
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, hosts, simulatedCapacities, setupHostsFile, checkDataNodeAddrConfig, false);
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig, boolean checkDataNodeHostConfig) throws IOException {
        String[] stringArray;
        if (operation == HdfsServerConstants.StartupOption.RECOVER) {
            return;
        }
        if (checkDataNodeHostConfig) {
            conf.setIfUnset("dfs.datanode.hostname", "127.0.0.1");
        } else {
            conf.set("dfs.datanode.hostname", "127.0.0.1");
        }
        int curDatanodesNum = this.dataNodes.size();
        if (conf.get("dfs.blockreport.initialDelay") == null) {
            conf.setLong("dfs.blockreport.initialDelay", 0L);
        }
        if (racks != null && numDataNodes > racks.length) {
            throw new IllegalArgumentException("The length of racks [" + racks.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (hosts != null && numDataNodes > hosts.length) {
            throw new IllegalArgumentException("The length of hosts [" + hosts.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (racks != null && hosts == null) {
            hosts = new String[numDataNodes];
            for (int i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
                hosts[i - curDatanodesNum] = "host" + i + ".foo.com";
            }
        }
        if (simulatedCapacities != null && numDataNodes > simulatedCapacities.length) {
            throw new IllegalArgumentException("The length of simulatedCapacities [" + simulatedCapacities.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (operation == null || operation != HdfsServerConstants.StartupOption.ROLLBACK) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = operation.getName();
        }
        String[] dnArgs = stringArray;
        for (int i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
            DataNode dn;
            HdfsConfiguration dnConf = new HdfsConfiguration(conf);
            this.setupDatanodeAddress((Configuration)dnConf, setupHostsFile, checkDataNodeAddrConfig);
            if (manageDfsDirs) {
                File dir1 = this.getInstanceStorageDir(i, 0);
                File dir2 = this.getInstanceStorageDir(i, 1);
                dir1.mkdirs();
                dir2.mkdirs();
                if (!dir1.isDirectory() || !dir2.isDirectory()) {
                    throw new IOException("Mkdirs failed to create directory for DataNode " + i + ": " + dir1 + " or " + dir2);
                }
                String dirs = Util.fileAsURI((File)dir1) + "," + Util.fileAsURI((File)dir2);
                dnConf.set("dfs.datanode.data.dir", dirs);
                conf.set("dfs.datanode.data.dir", dirs);
            }
            if (simulatedCapacities != null) {
                SimulatedFSDataset.setFactory((Configuration)dnConf);
                dnConf.setLong("dfs.datanode.simulateddatastorage.capacity", simulatedCapacities[i - curDatanodesNum]);
            }
            LOG.info((Object)("Starting DataNode " + i + " with " + "dfs.datanode.data.dir" + ": " + dnConf.get("dfs.datanode.data.dir")));
            if (hosts != null) {
                dnConf.set("dfs.datanode.hostname", hosts[i - curDatanodesNum]);
                LOG.info((Object)("Starting DataNode " + i + " with hostname set to: " + dnConf.get("dfs.datanode.hostname")));
            }
            if (racks != null) {
                String name = hosts[i - curDatanodesNum];
                LOG.info((Object)("Adding node with hostname : " + name + " to rack " + racks[i - curDatanodesNum]));
                StaticMapping.addNodeToRack((String)name, (String)racks[i - curDatanodesNum]);
            }
            HdfsConfiguration newconf = new HdfsConfiguration((Configuration)dnConf);
            if (hosts != null) {
                NetUtils.addStaticResolution((String)hosts[i - curDatanodesNum], (String)"localhost");
            }
            if ((dn = DataNode.instantiateDataNode((String[])dnArgs, (Configuration)dnConf)) == null) {
                throw new IOException("Cannot start DataNode in " + dnConf.get("dfs.datanode.data.dir"));
            }
            String service = SecurityUtil.buildTokenService((InetSocketAddress)dn.getXferAddress()).toString();
            if (racks != null) {
                LOG.info((Object)("Adding node with service : " + service + " to rack " + racks[i - curDatanodesNum]));
                StaticMapping.addNodeToRack((String)service, (String)racks[i - curDatanodesNum]);
            }
            dn.runDatanodeDaemon();
            this.dataNodes.add(new DataNodeProperties(dn, (Configuration)newconf, dnArgs));
        }
        curDatanodesNum += numDataNodes;
        this.numDataNodes += numDataNodes;
        this.waitActive();
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, null, false);
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, simulatedCapacities, false);
    }

    private void finalizeNamenode(NameNode nn, Configuration conf) throws Exception {
        if (nn == null) {
            throw new IllegalStateException("Attempting to finalize Namenode but it is not running");
        }
        ToolRunner.run((Tool)new DFSAdmin(conf), (String[])new String[]{"-finalizeUpgrade"});
    }

    public void finalizeCluster(int nnIndex, Configuration conf) throws Exception {
        this.finalizeNamenode(this.nameNodes[nnIndex].nameNode, this.nameNodes[nnIndex].conf);
    }

    public void finalizeCluster(Configuration conf) throws Exception {
        for (NameNodeInfo nnInfo : this.nameNodes) {
            if (nnInfo == null) {
                throw new IllegalStateException("Attempting to finalize Namenode but it is not running");
            }
            this.finalizeNamenode(nnInfo.nameNode, nnInfo.conf);
        }
    }

    public int getNumNameNodes() {
        return this.nameNodes.length;
    }

    public NameNode getNameNode() {
        this.checkSingleNameNode();
        return this.getNameNode(0);
    }

    public NamenodeProtocols getNameNodeRpc() {
        this.checkSingleNameNode();
        return this.getNameNodeRpc(0);
    }

    public NamenodeProtocols getNameNodeRpc(int nnIndex) {
        return this.getNameNode(nnIndex).getRpcServer();
    }

    public NameNode getNameNode(int nnIndex) {
        return this.nameNodes[nnIndex].nameNode;
    }

    public FSNamesystem getNamesystem() {
        this.checkSingleNameNode();
        return NameNodeAdapter.getNamesystem(this.nameNodes[0].nameNode);
    }

    public FSNamesystem getNamesystem(int nnIndex) {
        return NameNodeAdapter.getNamesystem(this.nameNodes[nnIndex].nameNode);
    }

    public ArrayList<DataNode> getDataNodes() {
        ArrayList<DataNode> list = new ArrayList<DataNode>();
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            DataNode node = this.dataNodes.get((int)i).datanode;
            list.add(node);
        }
        return list;
    }

    public DataNode getDataNode(int ipcPort) {
        for (DataNode dn : this.getDataNodes()) {
            if (dn.ipcServer.getListenerAddress().getPort() != ipcPort) continue;
            return dn;
        }
        return null;
    }

    public int getNameNodePort() {
        this.checkSingleNameNode();
        return this.getNameNodePort(0);
    }

    public int getNameNodePort(int nnIndex) {
        return this.nameNodes[nnIndex].nameNode.getNameNodeAddress().getPort();
    }

    public int getNameNodeServicePort(int nnIndex) {
        return this.nameNodes[nnIndex].nameNode.getServiceRpcAddress().getPort();
    }

    public void shutdown() {
        LOG.info((Object)"Shutting down the Mini HDFS Cluster");
        if (this.checkExitOnShutdown && ExitUtil.terminateCalled()) {
            LOG.fatal((Object)"Test resulted in an unexpected exit", (Throwable)ExitUtil.getFirstExitException());
            ExitUtil.resetFirstExitException();
            throw new AssertionError((Object)"Test resulted in an unexpected exit");
        }
        this.shutdownDataNodes();
        for (NameNodeInfo nnInfo : this.nameNodes) {
            NameNode nameNode;
            if (nnInfo == null || (nameNode = nnInfo.nameNode) == null) continue;
            nameNode.stop();
            nameNode.join();
            nameNode = null;
        }
    }

    public void shutdownDataNodes() {
        for (int i = this.dataNodes.size() - 1; i >= 0; --i) {
            LOG.info((Object)("Shutting down DataNode " + i));
            DataNode dn = this.dataNodes.remove((int)i).datanode;
            dn.shutdown();
            --this.numDataNodes;
        }
    }

    public synchronized void shutdownNameNodes() {
        for (int i = 0; i < this.nameNodes.length; ++i) {
            this.shutdownNameNode(i);
        }
    }

    public synchronized void shutdownNameNode(int nnIndex) {
        NameNode nn = this.nameNodes[nnIndex].nameNode;
        if (nn != null) {
            LOG.info((Object)"Shutting down the namenode");
            nn.stop();
            nn.join();
            Configuration conf = this.nameNodes[nnIndex].conf;
            this.nameNodes[nnIndex] = new NameNodeInfo(null, null, null, conf);
        }
    }

    public synchronized void restartNameNodes() throws IOException {
        for (int i = 0; i < this.nameNodes.length; ++i) {
            this.restartNameNode(i);
        }
    }

    public synchronized void restartNameNode() throws IOException {
        this.checkSingleNameNode();
        this.restartNameNode(true);
    }

    public synchronized void restartNameNode(boolean waitActive) throws IOException {
        this.checkSingleNameNode();
        this.restartNameNode(0, waitActive);
    }

    public synchronized void restartNameNode(int nnIndex) throws IOException {
        this.restartNameNode(nnIndex, true);
    }

    public synchronized void restartNameNode(int nnIndex, boolean waitActive) throws IOException {
        String nameserviceId = this.nameNodes[nnIndex].nameserviceId;
        String nnId = this.nameNodes[nnIndex].nnId;
        Configuration conf = this.nameNodes[nnIndex].conf;
        this.shutdownNameNode(nnIndex);
        NameNode nn = NameNode.createNameNode((String[])new String[0], (Configuration)conf);
        this.nameNodes[nnIndex] = new NameNodeInfo(nn, nameserviceId, nnId, conf);
        if (waitActive) {
            this.waitClusterUp();
            LOG.info((Object)"Restarted the namenode");
            this.waitActive();
        }
    }

    public int corruptBlockOnDataNodes(ExtendedBlock block) throws IOException {
        File[] blockFiles;
        int blocksCorrupted = 0;
        for (File f : blockFiles = this.getAllBlockFiles(block)) {
            if (!MiniDFSCluster.corruptBlock(f)) continue;
            ++blocksCorrupted;
        }
        return blocksCorrupted;
    }

    public String readBlockOnDataNode(int i, ExtendedBlock block) throws IOException {
        assert (i >= 0 && i < this.dataNodes.size()) : "Invalid datanode " + i;
        File blockFile = MiniDFSCluster.getBlockFile(i, block);
        if (blockFile != null && blockFile.exists()) {
            return DFSTestUtil.readFile(blockFile);
        }
        return null;
    }

    public static boolean corruptReplica(int i, ExtendedBlock blk) throws IOException {
        File blockFile = MiniDFSCluster.getBlockFile(i, blk);
        return MiniDFSCluster.corruptBlock(blockFile);
    }

    public static boolean corruptBlock(File blockFile) throws IOException {
        if (blockFile == null || !blockFile.exists()) {
            return false;
        }
        Random random = new Random();
        RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
        FileChannel channel = raFile.getChannel();
        String badString = "BADBAD";
        int rand = random.nextInt((int)channel.size() / 2);
        raFile.seek(rand);
        raFile.write(badString.getBytes());
        raFile.close();
        LOG.warn((Object)("Corrupting the block " + blockFile));
        return true;
    }

    public synchronized DataNodeProperties stopDataNode(int i) {
        if (i < 0 || i >= this.dataNodes.size()) {
            return null;
        }
        DataNodeProperties dnprop = this.dataNodes.remove(i);
        DataNode dn = dnprop.datanode;
        LOG.info((Object)("MiniDFSCluster Stopping DataNode " + dn.getDisplayName() + " from a total of " + (this.dataNodes.size() + 1) + " datanodes."));
        dn.shutdown();
        --this.numDataNodes;
        return dnprop;
    }

    public synchronized DataNodeProperties stopDataNode(String dnName) {
        int i;
        for (i = 0; i < this.dataNodes.size(); ++i) {
            DataNode dn = this.dataNodes.get((int)i).datanode;
            LOG.info((Object)("DN name=" + dnName + " found DN=" + dn + " with name=" + dn.getDisplayName()));
            if (dnName.equals(dn.getDatanodeId().getXferAddr())) break;
        }
        return this.stopDataNode(i);
    }

    public boolean restartDataNode(DataNodeProperties dnprop) throws IOException {
        return this.restartDataNode(dnprop, false);
    }

    public synchronized boolean restartDataNode(DataNodeProperties dnprop, boolean keepPort) throws IOException {
        Configuration conf = dnprop.conf;
        String[] args = dnprop.dnArgs;
        HdfsConfiguration newconf = new HdfsConfiguration(conf);
        if (keepPort) {
            InetSocketAddress addr = dnprop.datanode.getXferAddress();
            conf.set("dfs.datanode.address", addr.getAddress().getHostAddress() + ":" + addr.getPort());
        }
        this.dataNodes.add(new DataNodeProperties(DataNode.createDataNode((String[])args, (Configuration)conf), (Configuration)newconf, args));
        ++this.numDataNodes;
        return true;
    }

    public boolean restartDataNode(int i) throws IOException {
        return this.restartDataNode(i, false);
    }

    public synchronized boolean restartDataNode(int i, boolean keepPort) throws IOException {
        DataNodeProperties dnprop = this.stopDataNode(i);
        if (dnprop == null) {
            return false;
        }
        return this.restartDataNode(dnprop, keepPort);
    }

    public synchronized boolean restartDataNodes(boolean keepPort) throws IOException {
        for (int i = this.dataNodes.size() - 1; i >= 0; --i) {
            if (!this.restartDataNode(i, keepPort)) {
                return false;
            }
            LOG.info((Object)("Restarted DataNode " + i));
        }
        return true;
    }

    public boolean restartDataNodes() throws IOException {
        return this.restartDataNodes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNameNodeUp(int nnIndex) {
        NameNode nameNode = this.nameNodes[nnIndex].nameNode;
        if (nameNode == null) {
            return false;
        }
        long[] sizes = NameNodeAdapter.getStats(nameNode.getNamesystem());
        boolean isUp = false;
        MiniDFSCluster miniDFSCluster = this;
        synchronized (miniDFSCluster) {
            isUp = (!nameNode.isInSafeMode() || !this.waitSafeMode) && sizes[0] != 0L;
        }
        return isUp;
    }

    public boolean isClusterUp() {
        for (int index = 0; index < this.nameNodes.length; ++index) {
            if (this.isNameNodeUp(index)) continue;
            return false;
        }
        return true;
    }

    public boolean isDataNodeUp() {
        if (this.dataNodes == null || this.dataNodes.size() == 0) {
            return false;
        }
        for (DataNodeProperties dn : this.dataNodes) {
            if (!dn.datanode.isDatanodeUp()) continue;
            return true;
        }
        return false;
    }

    public DistributedFileSystem getFileSystem() throws IOException {
        this.checkSingleNameNode();
        return this.getFileSystem(0);
    }

    public DistributedFileSystem getFileSystem(int nnIndex) throws IOException {
        return (DistributedFileSystem)FileSystem.get((URI)this.getURI(nnIndex), (Configuration)this.nameNodes[nnIndex].conf);
    }

    public FileSystem getNewFileSystemInstance(int nnIndex) throws IOException {
        return FileSystem.newInstance((URI)this.getURI(nnIndex), (Configuration)this.nameNodes[nnIndex].conf);
    }

    public String getHttpUri(int nnIndex) {
        return "http://" + this.nameNodes[nnIndex].conf.get("dfs.namenode.http-address");
    }

    public HftpFileSystem getHftpFileSystem(int nnIndex) throws IOException {
        String uri = "hftp://" + this.nameNodes[nnIndex].conf.get("dfs.namenode.http-address");
        try {
            return (HftpFileSystem)FileSystem.get((URI)new URI(uri), (Configuration)this.conf);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public HftpFileSystem getHftpFileSystemAs(String username, Configuration conf, final int nnIndex, String ... groups) throws IOException, InterruptedException {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)username, (String[])groups);
        return (HftpFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<HftpFileSystem>(){

            @Override
            public HftpFileSystem run() throws Exception {
                return MiniDFSCluster.this.getHftpFileSystem(nnIndex);
            }
        });
    }

    public Collection<URI> getNameDirs(int nnIndex) {
        return FSNamesystem.getNamespaceDirs((Configuration)this.nameNodes[nnIndex].conf);
    }

    public Collection<URI> getNameEditsDirs(int nnIndex) throws IOException {
        return FSNamesystem.getNamespaceEditsDirs((Configuration)this.nameNodes[nnIndex].conf);
    }

    public void transitionToActive(int nnIndex) throws IOException, ServiceFailedException {
        this.getNameNode(nnIndex).getRpcServer().transitionToActive(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED));
    }

    public void transitionToStandby(int nnIndex) throws IOException, ServiceFailedException {
        this.getNameNode(nnIndex).getRpcServer().transitionToStandby(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED));
    }

    public void triggerBlockReports() throws IOException {
        for (DataNode dn : this.getDataNodes()) {
            DataNodeTestUtils.triggerBlockReport(dn);
        }
    }

    public void triggerDeletionReports() throws IOException {
        for (DataNode dn : this.getDataNodes()) {
            DataNodeTestUtils.triggerDeletionReport(dn);
        }
    }

    public void triggerHeartbeats() throws IOException {
        for (DataNode dn : this.getDataNodes()) {
            DataNodeTestUtils.triggerHeartbeat(dn);
        }
    }

    public void waitActive(int nnIndex) throws IOException {
        if (this.nameNodes.length == 0 || this.nameNodes[nnIndex] == null) {
            return;
        }
        InetSocketAddress addr = this.nameNodes[nnIndex].nameNode.getServiceRpcAddress();
        assert (addr.getPort() != 0);
        DFSClient client = new DFSClient(addr, this.conf);
        while (this.shouldWait(client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE), addr)) {
            try {
                LOG.info((Object)"Waiting for cluster to become active");
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        client.close();
    }

    public void waitActive() throws IOException {
        block2: for (int index = 0; index < this.nameNodes.length; ++index) {
            int failedCount = 0;
            while (true) {
                try {
                    this.waitActive(index);
                    continue block2;
                }
                catch (IOException e) {
                    if (++failedCount <= 1) continue;
                    LOG.warn((Object)("Tried waitActive() " + failedCount + " time(s) and failed, giving up.  " + StringUtils.stringifyException((Throwable)e)));
                    throw e;
                }
                break;
            }
        }
        LOG.info((Object)"Cluster is active");
    }

    private synchronized boolean shouldWait(DatanodeInfo[] dnInfo, InetSocketAddress addr) {
        for (DataNodeProperties dn : this.dataNodes) {
            if (dn.datanode.isConnectedToNN(addr)) continue;
            LOG.warn((Object)("BPOfferService in datanode " + dn.datanode + " failed to connect to namenode at " + addr));
            return false;
        }
        if (dnInfo.length != this.numDataNodes) {
            return true;
        }
        for (DataNodeProperties dn : this.dataNodes) {
            if (dn.datanode.isDatanodeFullyStarted()) continue;
            return true;
        }
        for (DatanodeInfo dn : dnInfo) {
            if (dn.getCapacity() != 0L) continue;
            return true;
        }
        for (DataNodeProperties dn : this.dataNodes) {
            if (DataNodeTestUtils.getFSDataset(dn.datanode) != null) continue;
            return true;
        }
        return false;
    }

    public void formatDataNodeDirs() throws IOException {
        this.base_dir = new File(this.determineDfsBaseDir());
        this.data_dir = new File(this.base_dir, "data");
        if (this.data_dir.exists() && !FileUtil.fullyDelete((File)this.data_dir)) {
            throw new IOException("Cannot remove data directory: " + this.data_dir);
        }
    }

    public Iterable<Block> getBlockReport(String bpid, int dataNodeIndex) {
        if (dataNodeIndex < 0 || dataNodeIndex > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        DataNode dn = this.dataNodes.get((int)dataNodeIndex).datanode;
        return DataNodeTestUtils.getFSDataset(dn).getBlockReport(bpid);
    }

    public Iterable<Block>[] getAllBlockReports(String bpid) {
        int numDataNodes = this.dataNodes.size();
        BlockListAsLongs[] result = new BlockListAsLongs[numDataNodes];
        for (int i = 0; i < numDataNodes; ++i) {
            result[i] = this.getBlockReport(bpid, i);
        }
        return result;
    }

    public void injectBlocks(int dataNodeIndex, Iterable<Block> blocksToInject) throws IOException {
        if (dataNodeIndex < 0 || dataNodeIndex > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        DataNode dn = this.dataNodes.get((int)dataNodeIndex).datanode;
        FsDatasetSpi<?> dataSet = DataNodeTestUtils.getFSDataset(dn);
        if (!(dataSet instanceof SimulatedFSDataset)) {
            throw new IOException("injectBlocks is valid only for SimilatedFSDataset");
        }
        String bpid = this.getNamesystem().getBlockPoolId();
        SimulatedFSDataset sdataset = (SimulatedFSDataset)dataSet;
        sdataset.injectBlocks(bpid, blocksToInject);
        this.dataNodes.get((int)dataNodeIndex).datanode.scheduleAllBlockReport(0L);
    }

    public void injectBlocks(int nameNodeIndex, int dataNodeIndex, Iterable<Block> blocksToInject) throws IOException {
        if (dataNodeIndex < 0 || dataNodeIndex > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        DataNode dn = this.dataNodes.get((int)dataNodeIndex).datanode;
        FsDatasetSpi<?> dataSet = DataNodeTestUtils.getFSDataset(dn);
        if (!(dataSet instanceof SimulatedFSDataset)) {
            throw new IOException("injectBlocks is valid only for SimilatedFSDataset");
        }
        String bpid = this.getNamesystem(nameNodeIndex).getBlockPoolId();
        SimulatedFSDataset sdataset = (SimulatedFSDataset)dataSet;
        sdataset.injectBlocks(bpid, blocksToInject);
        this.dataNodes.get((int)dataNodeIndex).datanode.scheduleAllBlockReport(0L);
    }

    public void injectBlocks(Iterable<Block>[] blocksToInject) throws IOException {
        if (blocksToInject.length > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < blocksToInject.length; ++i) {
            this.injectBlocks(i, blocksToInject[i]);
        }
    }

    public void setLeasePeriod(long soft, long hard) {
        NameNodeAdapter.setLeasePeriod(this.getNamesystem(), soft, hard);
    }

    public void setWaitSafeMode(boolean wait) {
        this.waitSafeMode = wait;
    }

    DataNode[] listDataNodes() {
        DataNode[] list = new DataNode[this.dataNodes.size()];
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            list[i] = this.dataNodes.get((int)i).datanode;
        }
        return list;
    }

    public String getDataDirectory() {
        return this.data_dir.getAbsolutePath();
    }

    protected String determineDfsBaseDir() {
        String dfsdir = this.conf.get(HDFS_MINIDFS_BASEDIR, null);
        if (dfsdir == null) {
            dfsdir = MiniDFSCluster.getBaseDirectory();
        }
        return dfsdir;
    }

    public static String getBaseDirectory() {
        return System.getProperty(PROP_TEST_BUILD_DATA, "build/test/data") + "/dfs/";
    }

    public File getInstanceStorageDir(int dnIndex, int dirIndex) {
        return new File(this.base_dir, MiniDFSCluster.getStorageDirPath(dnIndex, dirIndex));
    }

    public static File getStorageDir(int dnIndex, int dirIndex) {
        return new File(MiniDFSCluster.getBaseDirectory(), MiniDFSCluster.getStorageDirPath(dnIndex, dirIndex));
    }

    private static String getStorageDirPath(int dnIndex, int dirIndex) {
        return "data/data" + (2 * dnIndex + 1 + dirIndex);
    }

    public static String getDNCurrentDir(File storageDir) {
        return storageDir + "/" + "current" + "/";
    }

    public static String getBPDir(File storageDir, String bpid) {
        return MiniDFSCluster.getDNCurrentDir(storageDir) + bpid + "/";
    }

    public static String getBPDir(File storageDir, String bpid, String dirName) {
        return MiniDFSCluster.getBPDir(storageDir, bpid) + dirName + "/";
    }

    public static File getRbwDir(File storageDir, String bpid) {
        return new File(MiniDFSCluster.getBPDir(storageDir, bpid, "current") + "rbw");
    }

    public static File getFinalizedDir(File storageDir, String bpid) {
        return new File(MiniDFSCluster.getBPDir(storageDir, bpid, "current") + "finalized");
    }

    public static File getBlockFile(File storageDir, ExtendedBlock blk) {
        return new File(MiniDFSCluster.getFinalizedDir(storageDir, blk.getBlockPoolId()), blk.getBlockName());
    }

    public static void shutdownCluster(MiniDFSCluster cluster) {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    public File[] getAllBlockFiles(ExtendedBlock block) {
        if (this.dataNodes.size() == 0) {
            return new File[0];
        }
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            File blockFile = MiniDFSCluster.getBlockFile(i, block);
            if (blockFile == null) continue;
            list.add(blockFile);
        }
        return list.toArray(new File[list.size()]);
    }

    public static File getBlockFile(int dnIndex, ExtendedBlock block) {
        for (int i = 0; i <= 1; ++i) {
            File storageDir = MiniDFSCluster.getStorageDir(dnIndex, i);
            File blockFile = MiniDFSCluster.getBlockFile(storageDir, block);
            if (!blockFile.exists()) continue;
            return blockFile;
        }
        return null;
    }

    private void checkSingleNameNode() {
        if (this.nameNodes.length != 1) {
            throw new IllegalArgumentException("Namenode index is needed");
        }
    }

    public NameNode addNameNode(Configuration conf, int namenodePort) throws IOException {
        if (!this.federation) {
            throw new IOException("cannot add namenode to non-federated cluster");
        }
        int nnIndex = this.nameNodes.length;
        int numNameNodes = this.nameNodes.length + 1;
        NameNodeInfo[] newlist = new NameNodeInfo[numNameNodes];
        System.arraycopy(this.nameNodes, 0, newlist, 0, this.nameNodes.length);
        this.nameNodes = newlist;
        String nameserviceId = NAMESERVICE_ID_PREFIX + (nnIndex + 1);
        String nameserviceIds = conf.get("dfs.nameservices");
        nameserviceIds = nameserviceIds + "," + nameserviceId;
        conf.set("dfs.nameservices", nameserviceIds);
        String nnId = null;
        MiniDFSCluster.initNameNodeAddress(conf, nameserviceId, new MiniDFSNNTopology.NNConf(nnId).setIpcPort(namenodePort));
        this.initNameNodeConf(conf, nameserviceId, nnId, true, true, nnIndex);
        this.createNameNode(nnIndex, conf, this.numDataNodes, true, null, null, nameserviceId, nnId);
        for (DataNodeProperties dn : this.dataNodes) {
            DataNode datanode = dn.datanode;
            datanode.refreshNamenodes(conf);
        }
        this.waitActive(nnIndex);
        return this.nameNodes[nnIndex].nameNode;
    }

    private int getFreeSocketPort() {
        int port = 0;
        try {
            ServerSocket s = new ServerSocket(0);
            port = s.getLocalPort();
            s.close();
            return port;
        }
        catch (IOException iOException) {
            return port;
        }
    }

    private void setupDatanodeAddress(Configuration conf, boolean setupHostsFile, boolean checkDataNodeAddrConfig) throws IOException {
        if (setupHostsFile) {
            String hostsFile = conf.get("dfs.hosts", "").trim();
            if (hostsFile.length() == 0) {
                throw new IOException("Parameter dfs.hosts is not setup in conf");
            }
            String address = "127.0.0.1:" + this.getFreeSocketPort();
            if (checkDataNodeAddrConfig) {
                conf.setIfUnset("dfs.datanode.address", address);
            } else {
                conf.set("dfs.datanode.address", address);
            }
            this.addToFile(hostsFile, address);
            LOG.info((Object)("Adding datanode " + address + " to hosts file " + hostsFile));
        } else if (checkDataNodeAddrConfig) {
            conf.setIfUnset("dfs.datanode.address", "127.0.0.1:0");
            conf.setIfUnset("dfs.datanode.http.address", "127.0.0.1:0");
            conf.setIfUnset("dfs.datanode.ipc.address", "127.0.0.1:0");
        } else {
            conf.set("dfs.datanode.address", "127.0.0.1:0");
            conf.set("dfs.datanode.http.address", "127.0.0.1:0");
            conf.set("dfs.datanode.ipc.address", "127.0.0.1:0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFile(String p, String address) throws IOException {
        File f = new File(p);
        f.createNewFile();
        PrintWriter writer = new PrintWriter(new FileWriter(f, true));
        try {
            writer.println(address);
        }
        finally {
            writer.close();
        }
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        instanceCount = 0;
    }

    static class NameNodeInfo {
        final NameNode nameNode;
        final Configuration conf;
        final String nameserviceId;
        final String nnId;

        NameNodeInfo(NameNode nn, String nameserviceId, String nnId, Configuration conf) {
            this.nameNode = nn;
            this.nameserviceId = nameserviceId;
            this.nnId = nnId;
            this.conf = conf;
        }
    }

    public class DataNodeProperties {
        DataNode datanode;
        Configuration conf;
        String[] dnArgs;

        DataNodeProperties(DataNode node, Configuration conf, String[] args) {
            this.datanode = node;
            this.conf = conf;
            this.dnArgs = args;
        }
    }

    public static class Builder {
        private int nameNodePort = 0;
        private int nameNodeHttpPort = 0;
        private final Configuration conf;
        private int numDataNodes = 1;
        private boolean format = true;
        private boolean manageNameDfsDirs = true;
        private boolean manageNameDfsSharedDirs = true;
        private boolean enableManagedDfsDirsRedundancy = true;
        private boolean manageDataDfsDirs = true;
        private HdfsServerConstants.StartupOption option = null;
        private String[] racks = null;
        private String[] hosts = null;
        private long[] simulatedCapacities = null;
        private String clusterId = null;
        private boolean waitSafeMode = true;
        private boolean setupHostsFile = false;
        private MiniDFSNNTopology nnTopology = null;
        private boolean checkExitOnShutdown = true;
        private boolean checkDataNodeHostConfig = false;

        public Builder(Configuration conf) {
            this.conf = conf;
        }

        public Builder nameNodePort(int val) {
            this.nameNodePort = val;
            return this;
        }

        public Builder nameNodeHttpPort(int val) {
            this.nameNodeHttpPort = val;
            return this;
        }

        public Builder numDataNodes(int val) {
            this.numDataNodes = val;
            return this;
        }

        public Builder format(boolean val) {
            this.format = val;
            return this;
        }

        public Builder manageNameDfsDirs(boolean val) {
            this.manageNameDfsDirs = val;
            return this;
        }

        public Builder manageNameDfsSharedDirs(boolean val) {
            this.manageNameDfsSharedDirs = val;
            return this;
        }

        public Builder enableManagedDfsDirsRedundancy(boolean val) {
            this.enableManagedDfsDirsRedundancy = val;
            return this;
        }

        public Builder manageDataDfsDirs(boolean val) {
            this.manageDataDfsDirs = val;
            return this;
        }

        public Builder startupOption(HdfsServerConstants.StartupOption val) {
            this.option = val;
            return this;
        }

        public Builder racks(String[] val) {
            this.racks = val;
            return this;
        }

        public Builder hosts(String[] val) {
            this.hosts = val;
            return this;
        }

        public Builder simulatedCapacities(long[] val) {
            this.simulatedCapacities = val;
            return this;
        }

        public Builder waitSafeMode(boolean val) {
            this.waitSafeMode = val;
            return this;
        }

        public Builder checkExitOnShutdown(boolean val) {
            this.checkExitOnShutdown = val;
            return this;
        }

        public Builder checkDataNodeHostConfig(boolean val) {
            this.checkDataNodeHostConfig = val;
            return this;
        }

        public Builder clusterId(String cid) {
            this.clusterId = cid;
            return this;
        }

        public Builder setupHostsFile(boolean val) {
            this.setupHostsFile = val;
            return this;
        }

        public Builder nnTopology(MiniDFSNNTopology topology) {
            this.nnTopology = topology;
            return this;
        }

        public MiniDFSCluster build() throws IOException {
            return new MiniDFSCluster(this);
        }
    }
}

