/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBlockReaderLocal {
    static MiniDFSCluster cluster;
    static HdfsConfiguration conf;

    @BeforeClass
    public static void setupCluster() throws IOException {
        conf = new HdfsConfiguration();
        conf.setBoolean("dfs.client.read.shortcircuit", true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        conf.set("dfs.block.local-path-access.user", UserGroupInformation.getCurrentUser().getShortUserName());
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
    }

    @AfterClass
    public static void teardownCluster() {
        cluster.shutdown();
    }

    @Test
    public void testStablePositionAfterCorruptRead() throws Exception {
        boolean REPL_FACTOR = true;
        long FILE_LENGTH = 512L;
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("/corrupted");
        DFSTestUtil.createFile((FileSystem)fs, path, 512L, (short)1, 12345L);
        DFSTestUtil.waitReplication((FileSystem)fs, path, (short)1);
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, path);
        int blockFilesCorrupted = cluster.corruptBlockOnDataNodes(block);
        Assert.assertEquals((String)"All replicas not corrupted", (long)1L, (long)blockFilesCorrupted);
        FSDataInputStream dis = cluster.getFileSystem().open(path);
        ByteBuffer buf = ByteBuffer.allocateDirect(512);
        boolean sawException = false;
        try {
            dis.read(buf);
        }
        catch (ChecksumException ex) {
            sawException = true;
        }
        Assert.assertTrue((boolean)sawException);
        Assert.assertEquals((long)0L, (long)buf.position());
        Assert.assertEquals((long)buf.capacity(), (long)buf.limit());
        dis = cluster.getFileSystem().open(path);
        buf.position(3);
        buf.limit(25);
        sawException = false;
        try {
            dis.read(buf);
        }
        catch (ChecksumException ex) {
            sawException = true;
        }
        Assert.assertTrue((boolean)sawException);
        Assert.assertEquals((long)3L, (long)buf.position());
        Assert.assertEquals((long)25L, (long)buf.limit());
    }
}

