/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDFSClientFailover {
    private static final Log LOG = LogFactory.getLog(TestDFSClientFailover.class);
    private static final Path TEST_FILE = new Path("/tmp/failover-test-file");
    private static final int FILE_LENGTH_TO_VERIFY = 100;
    private Configuration conf = new Configuration();
    private MiniDFSCluster cluster;

    @Before
    public void setUpCluster() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
        this.cluster.transitionToActive(0);
        this.cluster.waitActive();
    }

    @After
    public void tearDownCluster() throws IOException {
        this.cluster.shutdown();
    }

    @Test
    public void testDfsClientFailover() throws IOException, URISyntaxException {
        FileSystem fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
        DFSTestUtil.createFile(fs, TEST_FILE, 100L, (short)1, 1L);
        Assert.assertEquals((long)fs.getFileStatus(TEST_FILE).getLen(), (long)100L);
        this.cluster.shutdownNameNode(0);
        this.cluster.transitionToActive(1);
        Assert.assertEquals((long)fs.getFileStatus(TEST_FILE).getLen(), (long)100L);
        Path withPort = new Path("hdfs://" + HATestUtil.getLogicalHostname(this.cluster) + ":" + 8020 + "/" + TEST_FILE.toUri().getPath());
        FileSystem fs2 = withPort.getFileSystem(fs.getConf());
        Assert.assertTrue((boolean)fs2.exists(withPort));
        fs.close();
    }

    @Test
    public void testLogicalUriShouldNotHavePorts() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.client.failover.proxy.provider.foo", ConfiguredFailoverProxyProvider.class.getName());
        Path p = new Path("hdfs://foo:12345/");
        try {
            p.getFileSystem((Configuration)conf).exists(p);
            Assert.fail((String)"Did not fail with fake FS");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"does not use port information", (Throwable)ioe);
        }
    }

    @Test
    public void testFailureWithMisconfiguredHaNNs() throws Exception {
        String logicalHost = "misconfigured-ha-uri";
        Configuration conf = new Configuration();
        conf.set("dfs.client.failover.proxy.provider." + logicalHost, ConfiguredFailoverProxyProvider.class.getName());
        URI uri = new URI("hdfs://" + logicalHost + "/test");
        try {
            FileSystem.get((URI)uri, (Configuration)conf).exists(new Path("/test"));
            Assert.fail((String)"Successfully got proxy provider for misconfigured FS");
        }
        catch (IOException ioe) {
            LOG.info((Object)"got expected exception", (Throwable)ioe);
            Assert.assertTrue((String)"expected exception did not contain helpful message", (boolean)StringUtils.stringifyException((Throwable)ioe).contains("Could not find any configured addresses for URI " + uri));
        }
    }
}

