/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.VersionInfo;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDatanodeRegistration {
    public static final Log LOG = LogFactory.getLog(TestDatanodeRegistration.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeIpcPort() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            DFSClient client = new DFSClient(addr, (Configuration)conf);
            cluster.restartDataNodes();
            DatanodeInfo[] report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            long firstUpdateAfterRestart = report[0].getLastUpdate();
            boolean gotHeartbeat = false;
            for (int i = 0; i < 10 && !gotHeartbeat; ++i) {
                try {
                    Thread.sleep(i * 1000);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
                gotHeartbeat = report[0].getLastUpdate() > firstUpdateAfterRestart;
            }
            if (!gotHeartbeat) {
                Assert.fail((String)"Never got a heartbeat from restarted datanode.");
            }
            int realIpcPort = cluster.getDataNodes().get(0).getIpcPort();
            Assert.assertEquals((long)realIpcPort, (long)report[0].getIpcPort());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegistrationWithDifferentSoftwareVersions() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.min.supported.namenode.version", "3.0.0");
        conf.set("dfs.namenode.min.supported.datanode.version", "3.0.0");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            NamenodeProtocols rpcServer = cluster.getNameNodeRpc();
            long nnCTime = cluster.getNamesystem().getFSImage().getStorage().getCTime();
            StorageInfo mockStorageInfo = (StorageInfo)Mockito.mock(StorageInfo.class);
            ((StorageInfo)Mockito.doReturn((Object)nnCTime).when((Object)mockStorageInfo)).getCTime();
            DatanodeRegistration mockDnReg = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
            ((DatanodeRegistration)Mockito.doReturn((Object)HdfsConstants.LAYOUT_VERSION).when((Object)mockDnReg)).getVersion();
            ((DatanodeRegistration)Mockito.doReturn((Object)"fake-storage-id").when((Object)mockDnReg)).getStorageID();
            ((DatanodeRegistration)Mockito.doReturn((Object)mockStorageInfo).when((Object)mockDnReg)).getStorageInfo();
            ((DatanodeRegistration)Mockito.doReturn((Object)"3.0.0").when((Object)mockDnReg)).getSoftwareVersion();
            rpcServer.registerDatanode(mockDnReg);
            ((DatanodeRegistration)Mockito.doReturn((Object)"4.0.0").when((Object)mockDnReg)).getSoftwareVersion();
            rpcServer.registerDatanode(mockDnReg);
            ((DatanodeRegistration)Mockito.doReturn((Object)"2.0.0").when((Object)mockDnReg)).getSoftwareVersion();
            try {
                rpcServer.registerDatanode(mockDnReg);
                Assert.fail((String)"Should not have been able to register DN with too-low version.");
            }
            catch (IncorrectVersionException ive) {
                GenericTestUtils.assertExceptionContains((String)"The reported DataNode version is too low", (Throwable)ive);
                LOG.info((Object)"Got expected exception", (Throwable)ive);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegistrationWithDifferentSoftwareVersionsDuringUpgrade() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.min.supported.namenode.version", "1.0.0");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            NamenodeProtocols rpcServer = cluster.getNameNodeRpc();
            long nnCTime = cluster.getNamesystem().getFSImage().getStorage().getCTime();
            StorageInfo mockStorageInfo = (StorageInfo)Mockito.mock(StorageInfo.class);
            ((StorageInfo)Mockito.doReturn((Object)nnCTime).when((Object)mockStorageInfo)).getCTime();
            DatanodeRegistration mockDnReg = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
            ((DatanodeRegistration)Mockito.doReturn((Object)HdfsConstants.LAYOUT_VERSION).when((Object)mockDnReg)).getVersion();
            ((DatanodeRegistration)Mockito.doReturn((Object)"fake-storage-id").when((Object)mockDnReg)).getStorageID();
            ((DatanodeRegistration)Mockito.doReturn((Object)mockStorageInfo).when((Object)mockDnReg)).getStorageInfo();
            ((DatanodeRegistration)Mockito.doReturn((Object)VersionInfo.getVersion()).when((Object)mockDnReg)).getSoftwareVersion();
            rpcServer.registerDatanode(mockDnReg);
            ((StorageInfo)Mockito.doReturn((Object)(nnCTime + 1L)).when((Object)mockStorageInfo)).getCTime();
            rpcServer.registerDatanode(mockDnReg);
            ((DatanodeRegistration)Mockito.doReturn((Object)(VersionInfo.getVersion() + ".1")).when((Object)mockDnReg)).getSoftwareVersion();
            try {
                rpcServer.registerDatanode(mockDnReg);
                Assert.fail((String)"Should not have been able to register DN with different software versions and CTimes");
            }
            catch (IncorrectVersionException ive) {
                GenericTestUtils.assertExceptionContains((String)"does not match CTime of NN", (Throwable)ive);
                LOG.info((Object)"Got expected exception", (Throwable)ive);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

