/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.io.MD5Hash;
import org.junit.Assert;
import org.junit.Test;

public class TestFetchImage {
    private static File FETCHED_IMAGE_FILE = new File(System.getProperty("build.test.dir"), "fetched-image-dir");
    private static final Pattern IMAGE_REGEX = Pattern.compile("fsimage_(\\d+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFetchImage() throws Exception {
        FETCHED_IMAGE_FILE.mkdirs();
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        DistributedFileSystem fs = null;
        try {
            DFSAdmin dfsAdmin = new DFSAdmin();
            dfsAdmin.setConf(conf);
            TestFetchImage.runFetchImage(dfsAdmin, cluster);
            fs = cluster.getFileSystem();
            fs.mkdirs(new Path("/foo"));
            fs.mkdirs(new Path("/foo2"));
            fs.mkdirs(new Path("/foo3"));
            cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNodeRpc().saveNamespace();
            cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            TestFetchImage.runFetchImage(dfsAdmin, cluster);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void runFetchImage(DFSAdmin dfsAdmin, MiniDFSCluster cluster) throws Exception {
        int retVal = dfsAdmin.run(new String[]{"-fetchImage", FETCHED_IMAGE_FILE.getPath()});
        Assert.assertEquals((long)0L, (long)retVal);
        File highestImageOnNn = TestFetchImage.getHighestFsImageOnCluster(cluster);
        MD5Hash expected = MD5FileUtils.computeMd5ForFile((File)highestImageOnNn);
        MD5Hash actual = MD5FileUtils.computeMd5ForFile((File)new File(FETCHED_IMAGE_FILE, highestImageOnNn.getName()));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private static File getHighestFsImageOnCluster(MiniDFSCluster cluster) {
        long highestImageTxId = -1L;
        File highestImageOnNn = null;
        for (URI nameDir : cluster.getNameDirs(0)) {
            for (File imageFile : new File(new File(nameDir), "current").listFiles()) {
                long imageTxId;
                Matcher imageMatch = IMAGE_REGEX.matcher(imageFile.getName());
                if (!imageMatch.matches() || (imageTxId = Long.valueOf(imageMatch.group(1)).longValue()) <= highestImageTxId) continue;
                highestImageTxId = imageTxId;
                highestImageOnNn = imageFile;
            }
        }
        return highestImageOnNn;
    }
}

