/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestFileLengthOnClusterRestart {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFileLengthWithHSyncAndClusterRestartWithOutDNsRegister() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.blocksize", 512);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        HdfsDataInputStream in = null;
        try {
            Path path = new Path(MiniDFSCluster.getBaseDirectory(), "test");
            DistributedFileSystem dfs = cluster.getFileSystem();
            FSDataOutputStream out = dfs.create(path);
            int fileLength = 1030;
            out.write(new byte[fileLength]);
            out.hsync();
            cluster.restartNameNode();
            cluster.waitActive();
            in = dfs.open(path, 1024);
            Assert.assertEquals((long)fileLength, (long)in.getVisibleLength());
            cluster.shutdownDataNodes();
            cluster.restartNameNode(false);
            this.verifyNNIsInSafeMode(dfs);
            try {
                in = (HdfsDataInputStream)dfs.open(path);
                Assert.fail((String)"Expected IOException");
            }
            catch (IOException e) {
                Assert.assertTrue((e.getLocalizedMessage().indexOf("Name node is in safe mode") >= 0 ? 1 : 0) != 0);
            }
        }
        finally {
            if (null != in) {
                in.close();
            }
            cluster.shutdown();
        }
    }

    private void verifyNNIsInSafeMode(DistributedFileSystem dfs) throws IOException {
        while (true) {
            try {
                if (dfs.isInSafeMode()) {
                    return;
                }
                throw new IOException("Expected to be in SafeMode");
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }
}

