/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestHFlush {
    private final String fName = "hflushtest.dat";

    public TestHFlush() {
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        this.fName = "hflushtest.dat";
    }

    @Test
    public void hFlush_01() throws IOException {
        TestHFlush.doTheJob((Configuration)new HdfsConfiguration(), "hflushtest.dat", 1024L, (short)2);
    }

    @Test
    public void hFlush_02() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int customPerChecksumSize = 512;
        int customBlockSize = customPerChecksumSize * 3;
        conf.setInt("dfs.bytes-per-checksum", customPerChecksumSize);
        conf.setLong("dfs.blocksize", (long)customBlockSize);
        TestHFlush.doTheJob((Configuration)conf, "hflushtest.dat", customBlockSize, (short)2);
    }

    @Test
    public void hFlush_03() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int customPerChecksumSize = 400;
        int customBlockSize = customPerChecksumSize * 3;
        conf.setInt("dfs.bytes-per-checksum", customPerChecksumSize);
        conf.setLong("dfs.blocksize", (long)customBlockSize);
        TestHFlush.doTheJob((Configuration)conf, "hflushtest.dat", customBlockSize, (short)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doTheJob(Configuration conf, String fileName, long block_size, short replicas) throws IOException {
        int SECTIONS = 10;
        byte[] fileContent = AppendTestUtil.initBuffer(10241);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(replicas).build();
        DistributedFileSystem fileSystem = cluster.getFileSystem();
        try {
            Path path = new Path(fileName);
            FSDataOutputStream stm = fileSystem.create(path, false, 4096, replicas, block_size);
            System.out.println("Created file " + fileName);
            int tenth = 1024;
            int rounding = 10241 - tenth * 10;
            for (int i = 0; i < 10; ++i) {
                System.out.println("Writing " + tenth * i + " to " + tenth * (i + 1) + " section to file " + fileName);
                stm.write(fileContent, tenth * i, tenth);
                ((DFSOutputStream)stm.getWrappedStream()).hflush();
                byte[] toRead = new byte[tenth];
                byte[] expected = new byte[tenth];
                System.arraycopy(fileContent, tenth * i, expected, 0, tenth);
                FSDataInputStream is = fileSystem.open(path);
                is.seek((long)(tenth * i));
                int readBytes = is.read(toRead, 0, tenth);
                System.out.println("Has read " + readBytes);
                Assert.assertTrue((String)"Should've get more bytes", (readBytes > 0 && readBytes <= tenth ? 1 : 0) != 0);
                is.close();
                TestHFlush.checkData(toRead, 0, readBytes, expected, "Partial verification");
            }
            System.out.println("Writing " + tenth * 10 + " to " + (tenth * 10 + rounding) + " section to file " + fileName);
            stm.write(fileContent, tenth * 10, rounding);
            stm.close();
            Assert.assertEquals((String)"File size doesn't match ", (long)10241L, (long)fileSystem.getFileStatus(path).getLen());
            AppendTestUtil.checkFullFile((FileSystem)fileSystem, path, fileContent.length, fileContent, "hflush()");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            fileSystem.close();
            cluster.shutdown();
        }
    }

    static void checkData(byte[] actual, int from, int len, byte[] expected, String message) {
        for (int idx = 0; idx < len; ++idx) {
            Assert.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (long)expected[from + idx], (long)actual[idx]);
            actual[idx] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPipelineHeartbeat() throws Exception {
        int DATANODE_NUM = 2;
        int fileLen = 6;
        HdfsConfiguration conf = new HdfsConfiguration();
        int timeout = 2000;
        conf.setInt("dfs.client.socket-timeout", 2000);
        Path p = new Path("/pipelineHeartbeat/foo");
        System.out.println("p=" + p);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            byte[] fileContents = AppendTestUtil.initBuffer(6);
            FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, p, 2);
            stm.write(fileContents, 0, 1);
            Thread.sleep(2000L);
            stm.hflush();
            System.out.println("Wrote 1 byte and hflush " + p);
            Thread.sleep(2000L);
            stm.write(fileContents, 1, 1);
            stm.hflush();
            stm.write(fileContents, 2, 1);
            Thread.sleep(2000L);
            stm.hflush();
            stm.write(fileContents, 3, 1);
            Thread.sleep(2000L);
            stm.write(fileContents, 4, 1);
            stm.hflush();
            stm.write(fileContents, 5, 1);
            Thread.sleep(2000L);
            stm.close();
            AppendTestUtil.checkFullFile((FileSystem)fs, p, 6, fileContents, "Failed to slowly write to a file");
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHFlushInterrupted() throws Exception {
        int DATANODE_NUM = 2;
        int fileLen = 6;
        byte[] fileContents = AppendTestUtil.initBuffer(6);
        HdfsConfiguration conf = new HdfsConfiguration();
        Path p = new Path("/hflush-interrupted");
        System.out.println("p=" + p);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, p, 2);
            stm.write(fileContents, 0, 2);
            Thread.currentThread().interrupt();
            try {
                stm.hflush();
                Thread.currentThread();
                Assert.assertTrue((boolean)Thread.interrupted());
            }
            catch (InterruptedIOException ie) {
                System.out.println("Got expected exception during flush");
            }
            Thread.currentThread();
            Assert.assertFalse((boolean)Thread.interrupted());
            stm.hflush();
            stm.write(fileContents, 2, 2);
            stm.hflush();
            stm.write(fileContents, 4, 2);
            Thread.currentThread().interrupt();
            try {
                stm.close();
                Thread.currentThread();
                Assert.assertTrue((boolean)Thread.interrupted());
            }
            catch (InterruptedIOException ioe) {
                System.out.println("Got expected exception during close");
                Thread.currentThread();
                Assert.assertFalse((boolean)Thread.interrupted());
                stm.close();
            }
            AppendTestUtil.checkFullFile((FileSystem)fs, p, 6, fileContents, "Failed to deal with thread interruptions");
        }
        finally {
            cluster.shutdown();
        }
    }
}

