/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.HsftpFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtilTestHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;

public class TestHftpDelegationToken {
    @Test
    public void testHdfsDelegationToken() throws Exception {
        final Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"oom", (String[])new String[]{"memory"});
        Token token = new Token(new byte[0], new byte[0], DelegationTokenIdentifier.HDFS_DELEGATION_KIND, new Text("127.0.0.1:8020"));
        user.addToken(token);
        Token token2 = new Token(null, null, new Text("other token"), new Text("127.0.0.1:8020"));
        user.addToken(token2);
        Assert.assertEquals((String)"wrong tokens in user", (long)2L, (long)user.getTokens().size());
        FileSystem fs = (FileSystem)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)new URI("hftp://localhost:50470/"), (Configuration)conf);
            }
        });
        Assert.assertSame((String)"wrong kind of file system", HftpFileSystem.class, fs.getClass());
        Field renewToken = HftpFileSystem.class.getDeclaredField("renewToken");
        renewToken.setAccessible(true);
        Assert.assertSame((String)"wrong token", (Object)token, (Object)renewToken.get(fs));
    }

    @Test
    public void testSelectHftpDelegationToken() throws Exception {
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        Configuration conf = new Configuration();
        conf.setClass("fs.hftp.impl", MyHftpFileSystem.class, FileSystem.class);
        int httpPort = 80;
        int httpsPort = 443;
        conf.setInt("dfs.http.port", httpPort);
        conf.setInt("dfs.https.port", httpsPort);
        URI fsUri = URI.create("hftp://localhost");
        MyHftpFileSystem fs = (MyHftpFileSystem)FileSystem.newInstance((URI)fsUri, (Configuration)conf);
        Assert.assertEquals((long)httpPort, (long)fs.getCanonicalUri().getPort());
        this.checkTokenSelection(fs, httpsPort, conf);
        fsUri = URI.create("hftp://localhost:" + httpPort);
        fs = (MyHftpFileSystem)FileSystem.newInstance((URI)fsUri, (Configuration)conf);
        Assert.assertEquals((long)httpPort, (long)fs.getCanonicalUri().getPort());
        this.checkTokenSelection(fs, httpsPort, conf);
        fsUri = URI.create("hftp://localhost:" + (httpPort + 1));
        fs = (MyHftpFileSystem)FileSystem.newInstance((URI)fsUri, (Configuration)conf);
        Assert.assertEquals((long)(httpPort + 1), (long)fs.getCanonicalUri().getPort());
        this.checkTokenSelection(fs, httpsPort, conf);
        conf.setInt("dfs.https.port", 5);
    }

    @Test
    public void testSelectHsftpDelegationToken() throws Exception {
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        Configuration conf = new Configuration();
        conf.setClass("fs.hsftp.impl", MyHsftpFileSystem.class, FileSystem.class);
        int httpPort = 80;
        int httpsPort = 443;
        conf.setInt("dfs.http.port", httpPort);
        conf.setInt("dfs.https.port", httpsPort);
        URI fsUri = URI.create("hsftp://localhost");
        MyHsftpFileSystem fs = (MyHsftpFileSystem)FileSystem.newInstance((URI)fsUri, (Configuration)conf);
        Assert.assertEquals((long)httpsPort, (long)fs.getCanonicalUri().getPort());
        this.checkTokenSelection((HftpFileSystem)fs, httpsPort, conf);
        fsUri = URI.create("hsftp://localhost:" + httpsPort);
        fs = (MyHsftpFileSystem)FileSystem.newInstance((URI)fsUri, (Configuration)conf);
        Assert.assertEquals((long)httpsPort, (long)fs.getCanonicalUri().getPort());
        this.checkTokenSelection((HftpFileSystem)fs, httpsPort, conf);
        fsUri = URI.create("hsftp://localhost:" + (httpsPort + 1));
        fs = (MyHsftpFileSystem)FileSystem.newInstance((URI)fsUri, (Configuration)conf);
        Assert.assertEquals((long)(httpsPort + 1), (long)fs.getCanonicalUri().getPort());
        this.checkTokenSelection((HftpFileSystem)fs, httpsPort + 1, conf);
        conf.setInt("dfs.https.port", 5);
    }

    private void checkTokenSelection(HftpFileSystem fs, int port, Configuration conf) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)fs.getUri().getAuthority(), (String[])new String[0]);
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        Token hdfsToken = new Token(new byte[0], new byte[0], DelegationTokenIdentifier.HDFS_DELEGATION_KIND, new Text("127.0.0.1:8020"));
        ugi.addToken(hdfsToken);
        Token token = fs.selectDelegationToken(ugi);
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)hdfsToken, (Object)token);
        Token hftpToken = new Token(new byte[0], new byte[0], HftpFileSystem.TOKEN_KIND, new Text("127.0.0.1:" + port));
        ugi.addToken(hftpToken);
        token = fs.selectDelegationToken(ugi);
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)hftpToken, (Object)token);
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)false);
        token = fs.selectDelegationToken(ugi);
        Assert.assertNull((Object)token);
        hdfsToken = new Token(new byte[0], new byte[0], DelegationTokenIdentifier.HDFS_DELEGATION_KIND, new Text("localhost:8020"));
        ugi.addToken(hdfsToken);
        token = fs.selectDelegationToken(ugi);
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)hdfsToken, (Object)token);
        hftpToken = new Token(new byte[0], new byte[0], HftpFileSystem.TOKEN_KIND, new Text("localhost:" + port));
        ugi.addToken(hftpToken);
        token = fs.selectDelegationToken(ugi);
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)hftpToken, (Object)token);
    }

    static class MyHsftpFileSystem
    extends HsftpFileSystem {
        MyHsftpFileSystem() {
        }

        public URI getCanonicalUri() {
            return super.getCanonicalUri();
        }

        public int getDefaultPort() {
            return super.getDefaultPort();
        }

        protected void initDelegationToken() throws IOException {
        }
    }

    static class MyHftpFileSystem
    extends HftpFileSystem {
        MyHftpFileSystem() {
        }

        public URI getCanonicalUri() {
            return super.getCanonicalUri();
        }

        public int getDefaultPort() {
            return super.getDefaultPort();
        }

        protected void initDelegationToken() throws IOException {
        }
    }
}

