/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.HsftpFileSystem;
import org.apache.hadoop.hdfs.web.URLUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHftpURLTimeouts {
    @BeforeClass
    public static void setup() {
        URLUtils.SOCKET_TIMEOUT = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHftpSocketTimeout() throws Exception {
        Configuration conf = new Configuration();
        ServerSocket socket = new ServerSocket(0, 1);
        URI uri = new URI("hftp", null, InetAddress.getByName(null).getHostAddress(), socket.getLocalPort(), null, null, null);
        boolean timedout = false;
        HftpFileSystem fs = (HftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        HttpURLConnection conn = fs.openConnection("/", "");
        timedout = false;
        try {
            conn.getInputStream();
        }
        catch (SocketTimeoutException ste) {
            timedout = true;
            Assert.assertEquals((Object)"Read timed out", (Object)ste.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        Assert.assertTrue((String)"read timedout", (boolean)timedout);
        Assert.assertTrue((String)"connect timedout", (boolean)this.checkConnectTimeout(fs, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHsftpSocketTimeout() throws Exception {
        Configuration conf = new Configuration();
        ServerSocket socket = new ServerSocket(0, 1);
        URI uri = new URI("hsftp", null, InetAddress.getByName(null).getHostAddress(), socket.getLocalPort(), null, null, null);
        boolean timedout = false;
        HsftpFileSystem fs = (HsftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        HttpURLConnection conn = null;
        timedout = false;
        try {
            conn = fs.openConnection("/", "");
        }
        catch (SocketTimeoutException ste) {
            timedout = true;
            Assert.assertEquals((Object)"Read timed out", (Object)ste.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        Assert.assertTrue((String)"ssl read connect timedout", (boolean)timedout);
        Assert.assertTrue((String)"connect timedout", (boolean)this.checkConnectTimeout((HftpFileSystem)fs, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConnectTimeout(HftpFileSystem fs, boolean ignoreReadTimeout) throws IOException {
        boolean timedout = false;
        LinkedList<HttpURLConnection> conns = new LinkedList<HttpURLConnection>();
        try {
            for (int n = 32; !timedout && n > 0; --n) {
                try {
                    conns.add(fs.openConnection("/", ""));
                    continue;
                }
                catch (SocketTimeoutException ste) {
                    String message = ste.getMessage();
                    if (ignoreReadTimeout && message.equals("Read timed out")) continue;
                    timedout = true;
                    Assert.assertEquals((Object)"connect timed out", (Object)message);
                }
            }
        }
        finally {
            for (HttpURLConnection conn : conns) {
                conn.disconnect();
            }
        }
        return timedout;
    }
}

