/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestParallelReadUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestParallelLocalRead
extends TestParallelReadUtil {
    @BeforeClass
    public static void setupCluster() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.client.read.shortcircuit", true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        conf.set("dfs.block.local-path-access.user", UserGroupInformation.getCurrentUser().getShortUserName());
        TestParallelLocalRead.setupCluster(1, conf);
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        TestParallelReadUtil.teardownCluster();
    }

    @Test
    public void testParallelReadCopying() throws IOException {
        this.runTestWorkload(new TestParallelReadUtil.CopyingReadWorkerHelper());
    }

    @Test
    public void testParallelReadByteBuffer() throws IOException {
        this.runTestWorkload(new TestParallelReadUtil.DirectReadWorkerHelper());
    }

    @Test
    public void testParallelReadMixed() throws IOException {
        this.runTestWorkload(new TestParallelReadUtil.MixedWorkloadHelper());
    }
}

