/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingReplicationBlocks;
import org.junit.Assert;
import org.junit.Test;

public class TestPendingReplication {
    static final int TIMEOUT = 3;

    @Test
    public void testPendingReplication() {
        Block block;
        int i;
        PendingReplicationBlocks pendingReplications = new PendingReplicationBlocks(3000L);
        pendingReplications.start();
        for (int i2 = 0; i2 < 10; ++i2) {
            Block block2 = new Block((long)i2, (long)i2, 0L);
            pendingReplications.add(block2, i2);
        }
        Assert.assertEquals((String)"Size of pendingReplications ", (long)10L, (long)pendingReplications.size());
        Block blk = new Block(8L, 8L, 0L);
        pendingReplications.remove(blk);
        Assert.assertEquals((String)"pendingReplications.getNumReplicas ", (long)7L, (long)pendingReplications.getNumReplicas(blk));
        for (i = 0; i < 7; ++i) {
            pendingReplications.remove(blk);
        }
        Assert.assertTrue((pendingReplications.size() == 9 ? 1 : 0) != 0);
        pendingReplications.add(blk, 8);
        Assert.assertTrue((pendingReplications.size() == 10 ? 1 : 0) != 0);
        for (i = 0; i < 10; ++i) {
            block = new Block((long)i, (long)i, 0L);
            int numReplicas = pendingReplications.getNumReplicas(block);
            Assert.assertTrue((numReplicas == i ? 1 : 0) != 0);
        }
        Assert.assertTrue((pendingReplications.getTimedOutBlocks() == null ? 1 : 0) != 0);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i3 = 10; i3 < 15; ++i3) {
            block = new Block((long)i3, (long)i3, 0L);
            pendingReplications.add(block, i3);
        }
        Assert.assertTrue((pendingReplications.size() == 15 ? 1 : 0) != 0);
        int loop = 0;
        while (pendingReplications.size() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++loop;
        }
        System.out.println("Had to wait for " + loop + " seconds for the lot to timeout");
        Assert.assertEquals((String)"Size of pendingReplications ", (long)0L, (long)pendingReplications.size());
        Block[] timedOut = pendingReplications.getTimedOutBlocks();
        Assert.assertTrue((timedOut != null && timedOut.length == 15 ? 1 : 0) != 0);
        for (int i4 = 0; i4 < timedOut.length; ++i4) {
            Assert.assertTrue((timedOut[i4].getBlockId() < 15L ? 1 : 0) != 0);
        }
        pendingReplications.stop();
    }
}

