/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;

public class TestRBWBlockInvalidation {
    private static NumberReplicas countReplicas(FSNamesystem namesystem, ExtendedBlock block) {
        return namesystem.getBlockManager().countNodes(block.getLocalBlock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockInvalidationWhenRBWReplicaMissedInDN() throws IOException, InterruptedException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 2);
        conf.setLong("dfs.blockreport.intervalMsec", 300L);
        conf.setLong("dfs.datanode.directoryscan.interval", 1L);
        conf.setLong("dfs.heartbeat.interval", 1L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        FSDataOutputStream out = null;
        try {
            FSNamesystem namesystem = cluster.getNamesystem();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testPath = new Path(MiniDFSCluster.getBaseDirectory(), "foo1");
            out = fs.create(testPath, (short)2);
            out.writeBytes("HDFS-3157: " + testPath);
            out.hsync();
            cluster.startDataNodes((Configuration)conf, 1, true, null, null, null);
            String bpid = namesystem.getBlockPoolId();
            ExtendedBlock blk = DFSTestUtil.getFirstBlock((FileSystem)fs, testPath);
            Block block = blk.getLocalBlock();
            DataNode dn = cluster.getDataNodes().get(0);
            File blockFile = DataNodeTestUtils.getBlockFile(dn, bpid, block);
            File metaFile = DataNodeTestUtils.getMetaFile(dn, bpid, block);
            Assert.assertTrue((String)"Could not delete the block file from the RBW folder", (boolean)blockFile.delete());
            Assert.assertTrue((String)"Could not delete the block meta file from the RBW folder", (boolean)metaFile.delete());
            out.close();
            boolean isCorruptReported = false;
            while (!isCorruptReported) {
                if (TestRBWBlockInvalidation.countReplicas(namesystem, blk).corruptReplicas() > 0) {
                    isCorruptReported = true;
                }
                Thread.sleep(100L);
            }
            Assert.assertEquals((String)"There should be 1 replica in the corruptReplicasMap", (long)1L, (long)TestRBWBlockInvalidation.countReplicas(namesystem, blk).corruptReplicas());
            blk = DFSTestUtil.getFirstBlock((FileSystem)fs, testPath);
            boolean isReplicated = false;
            while (!isReplicated) {
                if (TestRBWBlockInvalidation.countReplicas(namesystem, blk).liveReplicas() > 1) {
                    isReplicated = true;
                }
                Thread.sleep(100L);
            }
            Assert.assertEquals((String)"There should be two live replicas", (long)2L, (long)TestRBWBlockInvalidation.countReplicas(namesystem, blk).liveReplicas());
            Thread.sleep(1000L);
            Assert.assertEquals((String)"There should not be any replica in the corruptReplicasMap", (long)0L, (long)TestRBWBlockInvalidation.countReplicas(namesystem, blk).corruptReplicas());
        }
        finally {
            if (out != null) {
                out.close();
            }
            cluster.shutdown();
        }
    }
}

