/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class TestUnderReplicatedBlocks {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetrepIncWithUnderReplicatedBlocks() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int REPLICATION_FACTOR = 2;
        String FILE_NAME = "/testFile";
        Path FILE_PATH = new Path("/testFile");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, FILE_PATH, 1L, (short)2, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, FILE_PATH, (short)2);
            BlockManager bm = cluster.getNamesystem().getBlockManager();
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, FILE_PATH);
            DatanodeDescriptor dn = (DatanodeDescriptor)bm.blocksMap.nodeIterator(b.getLocalBlock()).next();
            bm.addToInvalidates(b.getLocalBlock(), (DatanodeInfo)dn);
            bm.blocksMap.removeNode(b.getLocalBlock(), dn);
            FsShell shell = new FsShell((Configuration)conf);
            Assert.assertEquals((long)0L, (long)shell.run(new String[]{"-setrep", "-w", Integer.toString(3), "/testFile"}));
        }
        finally {
            cluster.shutdown();
        }
    }
}

