/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestDirectoryScanner {
    private static final Log LOG = LogFactory.getLog(TestDirectoryScanner.class);
    private static final Configuration CONF = new HdfsConfiguration();
    private static final int DEFAULT_GEN_STAMP = 9999;
    private MiniDFSCluster cluster;
    private String bpid;
    private FsDatasetSpi<? extends FsVolumeSpi> fds = null;
    private DirectoryScanner scanner = null;
    private Random rand = new Random();
    private Random r = new Random();

    private void createFile(String fileName, long fileLen) throws IOException {
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path filePath = new Path(fileName);
        DFSTestUtil.createFile((FileSystem)fs, filePath, fileLen, (short)1, this.r.nextLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long truncateBlockFile() throws IOException {
        FsDatasetSpi<? extends FsVolumeSpi> fsDatasetSpi = this.fds;
        synchronized (fsDatasetSpi) {
            for (ReplicaInfo b : FsDatasetTestUtil.getReplicas(this.fds, this.bpid)) {
                File f = b.getBlockFile();
                File mf = b.getMetaFile();
                if (!f.exists() || f.length() == 0L || !mf.exists()) continue;
                FileOutputStream s = new FileOutputStream(f);
                FileChannel channel = s.getChannel();
                channel.truncate(0L);
                LOG.info((Object)("Truncated block file " + f.getAbsolutePath()));
                return b.getBlockId();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long deleteBlockFile() {
        FsDatasetSpi<? extends FsVolumeSpi> fsDatasetSpi = this.fds;
        synchronized (fsDatasetSpi) {
            for (ReplicaInfo b : FsDatasetTestUtil.getReplicas(this.fds, this.bpid)) {
                File f = b.getBlockFile();
                File mf = b.getMetaFile();
                if (!f.exists() || !mf.exists() || !f.delete()) continue;
                LOG.info((Object)("Deleting block file " + f.getAbsolutePath()));
                return b.getBlockId();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long deleteMetaFile() {
        FsDatasetSpi<? extends FsVolumeSpi> fsDatasetSpi = this.fds;
        synchronized (fsDatasetSpi) {
            for (ReplicaInfo b : FsDatasetTestUtil.getReplicas(this.fds, this.bpid)) {
                File file = b.getMetaFile();
                if (!file.exists() || !file.delete()) continue;
                LOG.info((Object)("Deleting metadata file " + file.getAbsolutePath()));
                return b.getBlockId();
            }
        }
        return 0L;
    }

    private long getFreeBlockId() {
        long id = this.rand.nextLong();
        while (FsDatasetTestUtil.fetchReplicaInfo(this.fds, this.bpid, id = this.rand.nextLong()) != null) {
        }
        return id;
    }

    private String getBlockFile(long id) {
        return "blk_" + id;
    }

    private String getMetaFile(long id) {
        return "blk_" + id + "_" + 9999 + ".meta";
    }

    private long createBlockFile() throws IOException {
        List volumes = this.fds.getVolumes();
        int index = this.rand.nextInt(volumes.size() - 1);
        long id = this.getFreeBlockId();
        File finalizedDir = ((FsVolumeSpi)volumes.get(index)).getFinalizedDir(this.bpid);
        File file = new File(finalizedDir, this.getBlockFile(id));
        if (file.createNewFile()) {
            LOG.info((Object)("Created block file " + file.getName()));
        }
        return id;
    }

    private long createMetaFile() throws IOException {
        List volumes = this.fds.getVolumes();
        int index = this.rand.nextInt(volumes.size() - 1);
        long id = this.getFreeBlockId();
        File finalizedDir = ((FsVolumeSpi)volumes.get(index)).getFinalizedDir(this.bpid);
        File file = new File(finalizedDir, this.getMetaFile(id));
        if (file.createNewFile()) {
            LOG.info((Object)("Created metafile " + file.getName()));
        }
        return id;
    }

    private long createBlockMetaFile() throws IOException {
        List volumes = this.fds.getVolumes();
        int index = this.rand.nextInt(volumes.size() - 1);
        long id = this.getFreeBlockId();
        File finalizedDir = ((FsVolumeSpi)volumes.get(index)).getFinalizedDir(this.bpid);
        File file = new File(finalizedDir, this.getBlockFile(id));
        if (file.createNewFile()) {
            LOG.info((Object)("Created block file " + file.getName()));
            String name1 = file.getAbsolutePath() + ".l";
            String name2 = file.getAbsolutePath() + ".n";
            file = new File(name1);
            if (file.createNewFile()) {
                LOG.info((Object)("Created extraneous file " + name1));
            }
            if ((file = new File(name2)).createNewFile()) {
                LOG.info((Object)("Created extraneous file " + name2));
            }
            if ((file = new File(finalizedDir, this.getMetaFile(id))).createNewFile()) {
                LOG.info((Object)("Created metafile " + file.getName()));
            }
        }
        return id;
    }

    private void scan(long totalBlocks, int diffsize, long missingMetaFile, long missingBlockFile, long missingMemoryBlocks, long mismatchBlocks) {
        this.scanner.reconcile();
        Assert.assertTrue((boolean)this.scanner.diffs.containsKey((Object)this.bpid));
        LinkedList diff = (LinkedList)this.scanner.diffs.get((Object)this.bpid);
        Assert.assertTrue((boolean)this.scanner.stats.containsKey(this.bpid));
        DirectoryScanner.Stats stats = (DirectoryScanner.Stats)this.scanner.stats.get(this.bpid);
        Assert.assertEquals((long)diffsize, (long)diff.size());
        Assert.assertEquals((long)totalBlocks, (long)stats.totalBlocks);
        Assert.assertEquals((long)missingMetaFile, (long)stats.missingMetaFile);
        Assert.assertEquals((long)missingBlockFile, (long)stats.missingBlockFile);
        Assert.assertEquals((long)missingMemoryBlocks, (long)stats.missingMemoryBlocks);
        Assert.assertEquals((long)mismatchBlocks, (long)stats.mismatchBlocks);
    }

    @Test
    public void testDirectoryScanner() throws Exception {
        for (int parallelism = 1; parallelism < 3; ++parallelism) {
            this.runTest(parallelism);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(int parallelism) throws Exception {
        this.cluster = new MiniDFSCluster.Builder(CONF).build();
        try {
            int i;
            this.cluster.waitActive();
            this.bpid = this.cluster.getNamesystem().getBlockPoolId();
            this.fds = DataNodeTestUtils.getFSDataset(this.cluster.getDataNodes().get(0));
            CONF.setInt("dfs.datanode.directoryscan.threads", parallelism);
            DataNode dn = this.cluster.getDataNodes().get(0);
            this.scanner = new DirectoryScanner(dn, this.fds, CONF);
            this.scanner.setRetainDiffs(true);
            this.createFile("/tmp/t1", 10000L);
            long totalBlocks = 100L;
            this.scan(100L, 0, 0L, 0L, 0L, 0L);
            long blockId = this.deleteMetaFile();
            this.scan(totalBlocks, 1, 1L, 0L, 0L, 1L);
            this.verifyGenStamp(blockId, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            blockId = this.deleteBlockFile();
            this.scan(totalBlocks, 1, 0L, 1L, 0L, 0L);
            this.verifyDeletion(blockId);
            this.scan(--totalBlocks, 0, 0L, 0L, 0L, 0L);
            blockId = this.createBlockFile();
            this.scan(++totalBlocks, 1, 1L, 0L, 1L, 0L);
            this.verifyAddition(blockId, 0L, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            blockId = this.createMetaFile();
            this.scan(totalBlocks + 1L, 1, 0L, 1L, 1L, 0L);
            File metafile = new File(this.getMetaFile(blockId));
            Assert.assertTrue((!metafile.exists() ? 1 : 0) != 0);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            blockId = this.createBlockMetaFile();
            this.scan(++totalBlocks, 1, 0L, 0L, 1L, 0L);
            this.verifyAddition(blockId, 9999L, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            for (i = 0; i < 10; ++i) {
                blockId = this.deleteMetaFile();
            }
            this.scan(totalBlocks, 10, 10L, 0L, 0L, 10L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            for (i = 0; i < 10; ++i) {
                blockId = this.deleteBlockFile();
            }
            this.scan(totalBlocks, 10, 0L, 10L, 0L, 0L);
            this.scan(totalBlocks -= 10L, 0, 0L, 0L, 0L, 0L);
            for (i = 0; i < 10; ++i) {
                blockId = this.createBlockFile();
            }
            this.scan(totalBlocks += 10L, 10, 10L, 0L, 10L, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            for (i = 0; i < 10; ++i) {
                blockId = this.createMetaFile();
            }
            this.scan(totalBlocks + 10L, 10, 0L, 10L, 10L, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            for (i = 0; i < 10; ++i) {
                blockId = this.createBlockMetaFile();
            }
            this.scan(totalBlocks += 10L, 10, 0L, 0L, 10L, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            for (i = 0; i < 10; ++i) {
                this.truncateBlockFile();
            }
            this.scan(totalBlocks, 10, 0L, 0L, 0L, 10L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            this.createMetaFile();
            this.createBlockFile();
            this.createBlockMetaFile();
            this.deleteMetaFile();
            this.deleteBlockFile();
            this.truncateBlockFile();
            this.scan(totalBlocks + 3L, 6, 2L, 2L, 3L, 2L);
            this.scan(totalBlocks + 1L, 0, 0L, 0L, 0L, 0L);
            this.scanner.shutdown();
            Assert.assertFalse((boolean)this.scanner.getRunStatus());
        }
        finally {
            this.scanner.shutdown();
            this.cluster.shutdown();
        }
    }

    private void verifyAddition(long blockId, long genStamp, long size) {
        ReplicaInfo replicainfo = FsDatasetTestUtil.fetchReplicaInfo(this.fds, this.bpid, blockId);
        Assert.assertNotNull((Object)replicainfo);
        File file = new File(this.getBlockFile(blockId));
        Assert.assertEquals((Object)file.getName(), (Object)FsDatasetTestUtil.getFile(this.fds, this.bpid, blockId).getName());
        Assert.assertEquals((long)genStamp, (long)replicainfo.getGenerationStamp());
        Assert.assertEquals((long)size, (long)replicainfo.getNumBytes());
    }

    private void verifyDeletion(long blockId) {
        Assert.assertNull((Object)FsDatasetTestUtil.fetchReplicaInfo(this.fds, this.bpid, blockId));
    }

    private void verifyGenStamp(long blockId, long genStamp) {
        ReplicaInfo memBlock = FsDatasetTestUtil.fetchReplicaInfo(this.fds, this.bpid, blockId);
        Assert.assertNotNull((Object)memBlock);
        Assert.assertEquals((long)genStamp, (long)memBlock.getGenerationStamp());
    }

    static {
        CONF.setLong("dfs.blocksize", 100L);
        CONF.setInt("dfs.bytes-per-checksum", 1);
        CONF.setLong("dfs.heartbeat.interval", 1L);
    }
}

