/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OfflineEditsViewerHelper {
    private static final Log LOG = LogFactory.getLog(OfflineEditsViewerHelper.class);
    long blockSize = 512L;
    MiniDFSCluster cluster = null;
    Configuration config = new Configuration();

    public String generateEdits() throws IOException {
        CheckpointSignature signature = this.runOperations();
        return this.getEditsFilename(signature);
    }

    private String getEditsFilename(CheckpointSignature sig) throws IOException {
        FSImage image = this.cluster.getNameNode().getFSImage();
        Iterator it = image.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS);
        Storage.StorageDirectory sd = (Storage.StorageDirectory)it.next();
        File ret = NNStorage.getFinalizedEditsFile((Storage.StorageDirectory)sd, (long)1L, (long)(sig.curSegmentTxId - 1L));
        assert (ret.exists()) : "expected " + ret + " exists";
        return ret.getAbsolutePath();
    }

    public void startCluster(String dfsDir) throws IOException {
        this.config.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(dfsDir, "name")).toString());
        this.config.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(dfsDir, "namesecondary1")).toString());
        this.config.setLong("dfs.blocksize", this.blockSize);
        this.config.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](JobTracker@.*FOO.COM)s/@.*//DEFAULT");
        this.config.setBoolean("dfs.namenode.delegation.token.always-use", true);
        this.cluster = new MiniDFSCluster.Builder(this.config).manageNameDfsDirs(false).build();
        this.cluster.waitClusterUp();
    }

    public void shutdownCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private CheckpointSignature runOperations() throws IOException {
        LocatedBlocks locatedBlocks;
        long mtime;
        LOG.info((Object)"Creating edits by performing fs operations");
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        FileContext fc = FileContext.getFileContext((URI)this.cluster.getURI(0), (Configuration)this.config);
        Path pathFileCreate = new Path("/file_create");
        FSDataOutputStream s = dfs.create(pathFileCreate);
        s.close();
        Path pathFileMoved = new Path("/file_moved");
        dfs.rename(pathFileCreate, pathFileMoved);
        dfs.delete(pathFileMoved, false);
        Path pathDirectoryMkdir = new Path("/directory_mkdir");
        dfs.mkdirs(pathDirectoryMkdir);
        s = dfs.create(pathFileCreate);
        s.close();
        dfs.setReplication(pathFileCreate, (short)1);
        Short permission = 511;
        dfs.setPermission(pathFileCreate, new FsPermission(permission.shortValue()));
        dfs.setOwner(pathFileCreate, new String("newOwner"), null);
        long atime = mtime = 1285195527000L;
        dfs.setTimes(pathFileCreate, mtime, atime);
        dfs.setQuota(pathDirectoryMkdir, 1000L, Long.MAX_VALUE);
        fc.rename(pathFileCreate, pathFileMoved, new Options.Rename[]{Options.Rename.NONE});
        Path pathConcatTarget = new Path("/file_concat_target");
        Path[] pathConcatFiles = new Path[]{new Path("/file_concat_0"), new Path("/file_concat_1")};
        long length = this.blockSize * 3L;
        short replication = 1;
        long seed = 1L;
        DFSTestUtil.createFile((FileSystem)dfs, pathConcatTarget, length, replication, seed);
        DFSTestUtil.createFile((FileSystem)dfs, pathConcatFiles[0], length, replication, seed);
        DFSTestUtil.createFile((FileSystem)dfs, pathConcatFiles[1], length, replication, seed);
        dfs.concat(pathConcatTarget, pathConcatFiles);
        Path pathSymlink = new Path("/file_symlink");
        fc.createSymlink(pathConcatTarget, pathSymlink, false);
        final Token token = dfs.getDelegationToken("JobTracker");
        UserGroupInformation longUgi = UserGroupInformation.createRemoteUser((String)"JobTracker/foo.com@FOO.COM");
        try {
            longUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, InterruptedException {
                    token.renew(OfflineEditsViewerHelper.this.config);
                    token.cancel(OfflineEditsViewerHelper.this.config);
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException("renewDelegationToken threw InterruptedException", e);
        }
        this.cluster.getNameNode().getFSImage().getEditLog().logSync();
        String filePath = "/hard-lease-recovery-test";
        byte[] bytes = "foo-bar-baz".getBytes();
        DFSClientAdapter.stopLeaseRenewer(dfs);
        FSDataOutputStream leaseRecoveryPath = dfs.create(new Path(filePath));
        leaseRecoveryPath.write(bytes);
        leaseRecoveryPath.hflush();
        this.cluster.setLeasePeriod(60000L, 1000L);
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Innocuous exception", (Throwable)e);
            }
        } while ((locatedBlocks = DFSClientAdapter.callGetBlockLocations((ClientProtocol)this.cluster.getNameNodeRpc(), filePath, 0L, bytes.length)).isUnderConstruction());
        return this.cluster.getNameNodeRpc().rollEditLog();
    }
}

