/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TestGenericJournalConf;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.util.StringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAllowFormat {
    public static final String NAME_NODE_HOST = "localhost:";
    public static final String NAME_NODE_HTTP_HOST = "0.0.0.0:";
    private static final Log LOG = LogFactory.getLog((String)TestAllowFormat.class.getName());
    private static Configuration config;
    private static MiniDFSCluster cluster;
    private static File hdfsDir;

    @BeforeClass
    public static void setUp() throws Exception {
        config = new Configuration();
        String baseDir = System.getProperty("test.build.data", "build/test/data");
        hdfsDir = new File(baseDir, "dfs");
        if (hdfsDir.exists() && !FileUtil.fullyDelete((File)hdfsDir)) {
            throw new IOException("Could not delete hdfs directory '" + hdfsDir + "'");
        }
        LOG.info((Object)("hdfsdir is " + hdfsDir.getAbsolutePath()));
        File nameDir1 = new File(hdfsDir, "name1");
        File nameDir2 = new File(hdfsDir, "name2");
        nameDir1.mkdirs();
        config.set("dfs.namenode.name.dir", nameDir1.getPath() + "," + nameDir2.getPath());
        config.set("dfs.datanode.data.dir", new File(hdfsDir, "data").getPath());
        config.set("dfs.namenode.checkpoint.dir", new File(hdfsDir, "secondary").getPath());
        FileSystem.setDefaultUri((Configuration)config, (String)"hdfs://localhost:0");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            LOG.info((Object)"Stopping mini cluster");
        }
        if (hdfsDir.exists() && !FileUtil.fullyDelete((File)hdfsDir)) {
            throw new IOException("Could not delete hdfs directory in tearDown '" + hdfsDir + "'");
        }
    }

    @Test
    public void testAllowFormat() throws IOException {
        LOG.info((Object)"--starting mini cluster");
        config.setBoolean("dfs.namenode.support.allow.format", true);
        cluster = new MiniDFSCluster.Builder(config).manageDataDfsDirs(false).manageNameDfsDirs(false).build();
        cluster.waitActive();
        Assert.assertNotNull((Object)cluster);
        NameNode nn = cluster.getNameNode();
        Assert.assertNotNull((Object)nn);
        LOG.info((Object)"Mini cluster created OK");
        LOG.info((Object)"Verifying format will fail with allowformat false");
        config.setBoolean("dfs.namenode.support.allow.format", false);
        try {
            cluster.shutdown();
            NameNode.format((Configuration)config);
            Assert.fail((String)"Format succeeded, when it should have failed");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"Exception was not about formatting Namenode", (boolean)e.getMessage().startsWith("The option dfs.namenode.support.allow.format"));
            LOG.info((Object)("Expected failure: " + StringUtils.stringifyException((Throwable)e)));
            LOG.info((Object)"Done verifying format will fail with allowformat false");
        }
        LOG.info((Object)"Verifying format will succeed with allowformat true");
        config.setBoolean("dfs.namenode.support.allow.format", true);
        NameNode.format((Configuration)config);
        LOG.info((Object)"Done verifying format will succeed with allowformat true");
    }

    @Test
    public void testFormatShouldBeIgnoredForNonFileBasedDirs() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String logicalName = "mycluster";
        String localhost = "127.0.0.1";
        InetSocketAddress nnAddr1 = new InetSocketAddress(localhost, 8020);
        InetSocketAddress nnAddr2 = new InetSocketAddress(localhost, 9020);
        HATestUtil.setFailoverConfigurations((Configuration)conf, logicalName, nnAddr1, nnAddr2);
        conf.setBoolean("dfs.namenode.support.allow.format", true);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.edits.journal-plugin", (String[])new String[]{"dummy"}), TestGenericJournalConf.DummyJournalManager.class.getName());
        conf.set("dfs.namenode.shared.edits.dir", "dummy://" + localhost + ":2181/ledgers");
        conf.set("dfs.ha.namenode.id", "nn1");
        NameNode.format((Configuration)conf);
    }

    static {
        cluster = null;
        hdfsDir = null;
    }
}

