/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URL;
import java.util.EnumMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.TestEditLog;
import org.apache.hadoop.hdfs.util.Holder;
import org.apache.hadoop.http.HttpServer;
import org.junit.Assert;
import org.junit.Test;

public class TestEditLogFileInputStream {
    private static final byte[] FAKE_LOG_DATA = TestEditLog.HADOOP20_SOME_EDITS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadURL() throws Exception {
        HttpServer server = new HttpServer("test", "0.0.0.0", 0, true);
        server.start();
        try {
            server.addServlet("fakeLog", "/fakeLog", FakeLogServlet.class);
            URL url = new URL("http://localhost:" + server.getPort() + "/fakeLog");
            EditLogInputStream elis = EditLogFileInputStream.fromUrl((URL)url, (long)-12345L, (long)-12345L, (boolean)false);
            EnumMap<FSEditLogOpCodes, Holder<Integer>> counts = FSImageTestUtil.countEditLogOpTypes(elis);
            Assert.assertEquals((long)1L, (long)((Integer)counts.get((Object)FSEditLogOpCodes.OP_ADD).held).intValue());
            Assert.assertEquals((long)1L, (long)((Integer)counts.get((Object)FSEditLogOpCodes.OP_SET_GENSTAMP).held).intValue());
            Assert.assertEquals((long)1L, (long)((Integer)counts.get((Object)FSEditLogOpCodes.OP_CLOSE).held).intValue());
            Assert.assertEquals((long)FAKE_LOG_DATA.length, (long)elis.length());
            elis.close();
        }
        finally {
            server.stop();
        }
    }

    public static class FakeLogServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setHeader("Content-Length", String.valueOf(FAKE_LOG_DATA.length));
            ServletOutputStream out = response.getOutputStream();
            out.write(FAKE_LOG_DATA);
            out.close();
        }
    }
}

