/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestEditLogFileOutputStream {
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", "/tmp"));
    private static final File TEST_EDITS = new File(TEST_DIR, "testEditLogFileOutput.log");
    static final int MIN_PREALLOCATION_LENGTH = 0x100000;

    @Before
    @After
    public void deleteEditsFile() {
        if (TEST_EDITS.exists()) {
            TEST_EDITS.delete();
        }
    }

    static void flushAndCheckLength(EditLogFileOutputStream elos, long expectedLength) throws IOException {
        elos.setReadyToFlush();
        elos.flushAndSync(true);
        Assert.assertEquals((long)expectedLength, (long)elos.getFile().length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRawWrites() throws IOException {
        EditLogFileOutputStream elos = new EditLogFileOutputStream(TEST_EDITS, 0);
        try {
            int toWrite;
            byte[] small = new byte[]{1, 2, 3, 4, 5, 8, 7};
            elos.create();
            elos.writeRaw(small, 0, small.length);
            TestEditLogFileOutputStream.flushAndCheckLength(elos, 0x100000L);
            elos.writeRaw(small, 0, small.length);
            TestEditLogFileOutputStream.flushAndCheckLength(elos, 0x100000L);
            int BIG_WRITE_LENGTH = 0x300000;
            byte[] buf = new byte[4096];
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = 0;
            }
            for (int total = 0x300000; total > 0; total -= toWrite) {
                toWrite = total > buf.length ? buf.length : total;
                elos.writeRaw(buf, 0, toWrite);
            }
            TestEditLogFileOutputStream.flushAndCheckLength(elos, 0x400000L);
        }
        finally {
            if (elos != null) {
                elos.close();
            }
        }
    }

    @Test
    public void testEditLogFileOutputStreamCloseAbort() throws IOException {
        EditLogFileOutputStream editLogStream = new EditLogFileOutputStream(TEST_EDITS, 0);
        editLogStream.close();
        editLogStream.abort();
    }

    @Test
    public void testEditLogFileOutputStreamCloseClose() throws IOException {
        EditLogFileOutputStream editLogStream = new EditLogFileOutputStream(TEST_EDITS, 0);
        editLogStream.close();
        try {
            editLogStream.close();
        }
        catch (IOException ioe) {
            String msg = StringUtils.stringifyException((Throwable)ioe);
            Assert.assertTrue((String)msg, (boolean)msg.contains("Trying to use aborted output stream"));
        }
    }

    @Test
    public void testEditLogFileOutputStreamAbortAbort() throws IOException {
        EditLogFileOutputStream editLogStream = new EditLogFileOutputStream(TEST_EDITS, 0);
        editLogStream.abort();
        editLogStream.abort();
    }

    static {
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
    }
}

