/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSImageTransactionalStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.junit.Assert;
import org.junit.Test;

public class TestFSImageStorageInspector {
    private static final Log LOG = LogFactory.getLog(TestFSImageStorageInspector.class);

    @Test
    public void testCurrentStorageInspector() throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        Storage.StorageDirectory mockDir = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE_AND_EDITS, false, "/foo/current/" + NNStorage.getImageFileName((long)123L), "/foo/current/" + NNStorage.getFinalizedEditsFileName((long)123L, (long)456L), "/foo/current/" + NNStorage.getImageFileName((long)456L), "/foo/current/" + NNStorage.getInProgressEditsFileName((long)457L));
        inspector.inspectDirectory(mockDir);
        Assert.assertEquals((long)2L, (long)inspector.foundImages.size());
        FSImageStorageInspector.FSImageFile latestImage = inspector.getLatestImage();
        Assert.assertEquals((long)456L, (long)latestImage.txId);
        Assert.assertSame((Object)mockDir, (Object)latestImage.sd);
        Assert.assertTrue((boolean)inspector.isUpgradeFinalized());
        Assert.assertEquals((Object)new File("/foo/current/" + NNStorage.getImageFileName((long)456L)), (Object)latestImage.getFile());
    }
}

