/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.Assert;
import org.junit.Test;

public class TestFSNamesystem {
    @Test
    public void testUniqueEditDirs() throws IOException {
        Configuration config = new Configuration();
        config.set("dfs.namenode.edits.dir", "file://edits/dir, file://edits/dir1,file://edits/dir1");
        List editsDirs = FSNamesystem.getNamespaceEditsDirs((Configuration)config);
        Assert.assertEquals((long)2L, (long)editsDirs.size());
    }

    @Test
    public void testFSNamespaceClearLeases() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode((Configuration)conf);
        FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf);
        LeaseManager leaseMan = fsn.getLeaseManager();
        leaseMan.addLease("client1", "importantFile");
        Assert.assertEquals((long)1L, (long)leaseMan.countLease());
        fsn.clear();
        leaseMan = fsn.getLeaseManager();
        Assert.assertEquals((long)0L, (long)leaseMan.countLease());
    }
}

