/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNameNodeRecovery {
    private static final Log LOG = LogFactory.getLog(TestNameNodeRecovery.class);
    private static HdfsServerConstants.StartupOption recoverStartOpt = HdfsServerConstants.StartupOption.RECOVER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runEditLogTest(EditLogTestSetup elts) throws IOException {
        String TEST_LOG_NAME = "test_edit_log";
        FSEditLogOp.OpInstanceCache cache = new FSEditLogOp.OpInstanceCache();
        EditLogFileOutputStream elfos = null;
        File file = null;
        EditLogFileInputStream elfis = null;
        try {
            file = new File("test_edit_log");
            elfos = new EditLogFileOutputStream(file, 0);
            elfos.create();
            elts.addTransactionsToLog((EditLogOutputStream)elfos, cache);
            elfos.setReadyToFlush();
            elfos.flushAndSync(true);
            elfos.close();
            elfos = null;
            file = new File("test_edit_log");
            elfis = new EditLogFileInputStream(file);
            Set<Long> validTxIds = elts.getValidTxIds();
            FSEditLogOp op = null;
            long prevTxId = 0L;
            try {
                while ((op = elfis.nextOp()) != null) {
                    LOG.debug((Object)("read txid " + op.txid));
                    if (!validTxIds.contains(op.getTransactionId())) {
                        Assert.fail((String)("read txid " + op.getTransactionId() + ", which we did not expect to find."));
                    }
                    validTxIds.remove(op.getTransactionId());
                    prevTxId = op.getTransactionId();
                }
                if (elts.getLastValidTxId() != -1L) {
                    Assert.fail((String)"failed to throw IoException as expected");
                }
            }
            catch (IOException e) {
                if (elts.getLastValidTxId() == -1L) {
                    Assert.fail((String)("expected all transactions to be valid, but got exception on txid " + prevTxId));
                }
                Assert.assertEquals((long)prevTxId, (long)elts.getLastValidTxId());
            }
            if (elts.getLastValidTxId() != -1L) {
                op = null;
                prevTxId = 0L;
                try {
                    while ((op = elfis.nextValidOp()) != null) {
                        prevTxId = op.getTransactionId();
                        Assert.assertTrue((boolean)validTxIds.remove(op.getTransactionId()));
                    }
                }
                catch (Throwable e) {
                    Assert.fail((String)("caught IOException while trying to skip over bad transaction.   message was " + e.getMessage() + "\nstack trace\n" + StringUtils.stringifyException((Throwable)e)));
                }
            }
            Assert.assertTrue((boolean)validTxIds.isEmpty());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{elfos, elfis});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{elfos, elfis});
    }

    static void padEditLog(EditLogOutputStream elos, int paddingLength) throws IOException {
        int toWrite;
        if (paddingLength <= 0) {
            return;
        }
        byte[] buf = new byte[4096];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = -1;
        }
        for (int pad = paddingLength; pad > 0; pad -= toWrite) {
            toWrite = pad > buf.length ? buf.length : pad;
            elos.writeRaw(buf, 0, toWrite);
        }
    }

    static void addDeleteOpcode(EditLogOutputStream elos, FSEditLogOp.OpInstanceCache cache) throws IOException {
        FSEditLogOp.DeleteOp op = FSEditLogOp.DeleteOp.getInstance((FSEditLogOp.OpInstanceCache)cache);
        op.setTransactionId(0L);
        op.setPath("/foo");
        op.setTimestamp(0L);
        elos.write((FSEditLogOp)op);
    }

    @Test(timeout=180000L)
    public void testEmptyLog() throws IOException {
        TestNameNodeRecovery.runEditLogTest(new EltsTestEmptyLog(0));
    }

    @Test(timeout=180000L)
    public void testEmptyPaddedLog() throws IOException {
        TestNameNodeRecovery.runEditLogTest(new EltsTestEmptyLog(0x100000));
    }

    @Test(timeout=180000L)
    public void testEmptyExtraPaddedLog() throws IOException {
        TestNameNodeRecovery.runEditLogTest(new EltsTestEmptyLog(0x300000));
    }

    @Test(timeout=180000L)
    public void testOpcodesAfterPadding() throws IOException {
        TestNameNodeRecovery.runEditLogTest(new EltsTestOpcodesAfterPadding(0x100000));
    }

    @Test(timeout=180000L)
    public void testOpcodesAfterExtraPadding() throws IOException {
        TestNameNodeRecovery.runEditLogTest(new EltsTestOpcodesAfterPadding(0x300000));
    }

    @Test(timeout=180000L)
    public void testSkipEdit() throws IOException {
        TestNameNodeRecovery.runEditLogTest(new EltsTestGarbageInEditLog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testNameNodeRecoveryImpl(Corruptor corruptor, boolean finalize) throws IOException {
        String TEST_PATH = "/test/path/dir";
        String TEST_PATH2 = "/second/dir";
        boolean needRecovery = corruptor.needRecovery(finalize);
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        Storage.StorageDirectory sd = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).enableManagedDfsDirsRedundancy(false).build();
            cluster.waitActive();
            if (!finalize) {
                FSEditLog spyLog = (FSEditLog)Mockito.spy((Object)cluster.getNameNode().getFSImage().getEditLog());
                ((FSEditLog)Mockito.doNothing().when((Object)spyLog)).endCurrentLogSegment(true);
                cluster.getNameNode().getFSImage().setEditLogForTesting(spyLog);
            }
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            FSImage fsimage = namesystem.getFSImage();
            fileSys.mkdirs(new Path("/test/path/dir"));
            fileSys.mkdirs(new Path("/second/dir"));
            sd = (Storage.StorageDirectory)fsimage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        File editFile = FSImageTestUtil.findLatestEditsLog(sd).getFile();
        Assert.assertTrue((String)("Should exist: " + editFile), (boolean)editFile.exists());
        LOG.info((Object)("corrupting edit log file '" + editFile + "'"));
        corruptor.corrupt(editFile);
        cluster = null;
        try {
            LOG.debug((Object)"trying to start normally (this should fail)...");
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).enableManagedDfsDirsRedundancy(false).format(false).build();
            cluster.waitActive();
            cluster.shutdown();
            if (needRecovery) {
                Assert.fail((String)"expected the corrupted edit log to prevent normal startup");
            }
        }
        catch (IOException e) {
            if (!needRecovery) {
                LOG.error((Object)("Got unexpected failure with " + corruptor.getName() + corruptor), (Throwable)e);
                Assert.fail((String)("got unexpected exception " + e.getMessage()));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        cluster = null;
        try {
            LOG.debug((Object)"running recovery...");
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).enableManagedDfsDirsRedundancy(false).format(false).startupOption(recoverStartOpt).build();
        }
        catch (IOException e) {
            Assert.fail((String)("caught IOException while trying to recover. message was " + e.getMessage() + "\nstack trace\n" + StringUtils.stringifyException((Throwable)e)));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        cluster = null;
        try {
            LOG.debug((Object)"starting cluster normally after recovery...");
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).enableManagedDfsDirsRedundancy(false).format(false).build();
            LOG.debug((Object)("successfully recovered the " + corruptor.getName() + " corrupted edit log"));
            cluster.waitActive();
            Assert.assertTrue((boolean)cluster.getFileSystem().exists(new Path("/test/path/dir")));
        }
        catch (IOException e) {
            Assert.fail((String)("failed to recover.  Error message: " + e.getMessage()));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test(timeout=180000L)
    public void testRecoverTruncatedEditLog() throws IOException {
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new TruncatingCorruptor(), true);
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new TruncatingCorruptor(), false);
    }

    @Test(timeout=180000L)
    public void testRecoverPaddedEditLog() throws IOException {
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new PaddingCorruptor(), true);
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new PaddingCorruptor(), false);
    }

    @Test(timeout=180000L)
    public void testRecoverZeroPaddedEditLog() throws IOException {
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new SafePaddingCorruptor(0), true);
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new SafePaddingCorruptor(0), false);
    }

    @Test(timeout=180000L)
    public void testRecoverNegativeOnePaddedEditLog() throws IOException {
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new SafePaddingCorruptor(-1), true);
        TestNameNodeRecovery.testNameNodeRecoveryImpl(new SafePaddingCorruptor(-1), false);
    }

    static {
        recoverStartOpt.setForce(2);
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
    }

    static class SafePaddingCorruptor
    implements Corruptor {
        private byte padByte;

        public SafePaddingCorruptor(byte padByte) {
            this.padByte = padByte;
            assert (this.padByte == 0 || this.padByte == -1);
        }

        @Override
        public void corrupt(File editFile) throws IOException {
            RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
            rwf.seek(editFile.length());
            rwf.write(-1);
            for (int i = 0; i < 1024; ++i) {
                rwf.write(this.padByte);
            }
            rwf.close();
        }

        @Override
        public boolean needRecovery(boolean finalized) {
            return false;
        }

        @Override
        public String getName() {
            return "pad" + this.padByte;
        }
    }

    static class PaddingCorruptor
    implements Corruptor {
        PaddingCorruptor() {
        }

        @Override
        public void corrupt(File editFile) throws IOException {
            RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
            rwf.seek(editFile.length());
            for (int i = 0; i < 129; ++i) {
                rwf.write(0);
            }
            rwf.write(13);
            rwf.write(14);
            rwf.write(10);
            rwf.write(13);
            rwf.close();
        }

        @Override
        public boolean needRecovery(boolean finalized) {
            return false;
        }

        @Override
        public String getName() {
            return "padFatal";
        }
    }

    static class TruncatingCorruptor
    implements Corruptor {
        TruncatingCorruptor() {
        }

        @Override
        public void corrupt(File editFile) throws IOException {
            long fileLen = editFile.length();
            RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
            rwf.setLength(fileLen - 1L);
            rwf.close();
        }

        @Override
        public boolean needRecovery(boolean finalized) {
            return finalized;
        }

        @Override
        public String getName() {
            return "truncated";
        }
    }

    static interface Corruptor {
        public void corrupt(File var1) throws IOException;

        public boolean needRecovery(boolean var1);

        public String getName();
    }

    private static class EltsTestGarbageInEditLog
    implements EditLogTestSetup {
        private final long BAD_TXID = 4L;
        private final long MAX_TXID = 10L;

        private EltsTestGarbageInEditLog() {
        }

        @Override
        public void addTransactionsToLog(EditLogOutputStream elos, FSEditLogOp.OpInstanceCache cache) throws IOException {
            for (long txid = 1L; txid <= 10L; ++txid) {
                if (txid == 4L) {
                    byte[] garbage = new byte[]{1, 2, 3};
                    elos.writeRaw(garbage, 0, garbage.length);
                    continue;
                }
                FSEditLogOp.DeleteOp op = FSEditLogOp.DeleteOp.getInstance((FSEditLogOp.OpInstanceCache)cache);
                op.setTransactionId(txid);
                op.setPath("/foo." + txid);
                op.setTimestamp(txid);
                elos.write((FSEditLogOp)op);
            }
        }

        @Override
        public long getLastValidTxId() {
            return 3L;
        }

        @Override
        public Set<Long> getValidTxIds() {
            return Sets.newHashSet((Object[])new Long[]{1L, 2L, 3L, 5L, 6L, 7L, 8L, 9L, 10L});
        }
    }

    private static class EltsTestOpcodesAfterPadding
    implements EditLogTestSetup {
        private int paddingLength;

        public EltsTestOpcodesAfterPadding(int paddingLength) {
            this.paddingLength = paddingLength;
        }

        @Override
        public void addTransactionsToLog(EditLogOutputStream elos, FSEditLogOp.OpInstanceCache cache) throws IOException {
            TestNameNodeRecovery.padEditLog(elos, this.paddingLength);
            TestNameNodeRecovery.addDeleteOpcode(elos, cache);
        }

        @Override
        public long getLastValidTxId() {
            return 0L;
        }

        @Override
        public Set<Long> getValidTxIds() {
            return Sets.newHashSet((Object[])new Long[]{0L});
        }
    }

    private static class EltsTestEmptyLog
    implements EditLogTestSetup {
        private int paddingLength;

        public EltsTestEmptyLog(int paddingLength) {
            this.paddingLength = paddingLength;
        }

        @Override
        public void addTransactionsToLog(EditLogOutputStream elos, FSEditLogOp.OpInstanceCache cache) throws IOException {
            TestNameNodeRecovery.padEditLog(elos, this.paddingLength);
        }

        @Override
        public long getLastValidTxId() {
            return -1L;
        }

        @Override
        public Set<Long> getValidTxIds() {
            return new HashSet<Long>();
        }
    }

    private static interface EditLogTestSetup {
        public void addTransactionsToLog(EditLogOutputStream var1, FSEditLogOp.OpInstanceCache var2) throws IOException;

        public long getLastValidTxId();

        public Set<Long> getValidTxIds();
    }
}

