/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestStateTransitionFailure {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailureToTransitionCausesShutdown() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            conf.setLong("fs.trash.interval", -1L);
            cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).checkExitOnShutdown(false).build();
            cluster.waitActive();
            try {
                cluster.transitionToActive(0);
                Assert.fail((String)"Transitioned to active but should not have been able to.");
            }
            catch (ExitUtil.ExitException ee) {
                GenericTestUtils.assertExceptionContains((String)"Cannot start tresh emptier with negative interval", (Throwable)ee);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

