/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestJsonUtil {
    static FileStatus toFileStatus(HdfsFileStatus f, String parent) {
        return new FileStatus(f.getLen(), f.isDir(), (int)f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.isSymlink() ? new Path(f.getSymlink()) : null, new Path(f.getFullName(parent)));
    }

    @Test
    public void testHdfsFileStatus() {
        long now = Time.now();
        String parent = "/dir";
        HdfsFileStatus status = new HdfsFileStatus(1001L, false, 3, 0x4000000L, now, now + 10L, new FsPermission(420), "user", "group", DFSUtil.string2Bytes((String)"bar"), DFSUtil.string2Bytes((String)"foo"));
        FileStatus fstatus = TestJsonUtil.toFileStatus(status, "/dir");
        System.out.println("status  = " + status);
        System.out.println("fstatus = " + fstatus);
        String json = JsonUtil.toJsonString((HdfsFileStatus)status, (boolean)true);
        System.out.println("json    = " + json.replace(",", ",\n  "));
        HdfsFileStatus s2 = JsonUtil.toFileStatus((Map)((Map)JSON.parse((String)json)), (boolean)true);
        FileStatus fs2 = TestJsonUtil.toFileStatus(s2, "/dir");
        System.out.println("s2      = " + s2);
        System.out.println("fs2     = " + fs2);
        Assert.assertEquals((Object)fstatus, (Object)fs2);
    }
}

