/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtilTestHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestWebHdfsUrl {
    @Test
    public void testDelegationTokenInUrl() throws IOException {
        Configuration conf = new Configuration();
        String uri = "webhdfs://127.0.0.1:9071";
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(new Text(ugi.getUserName()), null, null);
        FSNamesystem namesystem = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        DelegationTokenSecretManager dtSecretManager = new DelegationTokenSecretManager(86400000L, 86400000L, 86400000L, 86400000L, namesystem);
        dtSecretManager.startThreads();
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)dtSecretManager);
        token.setService(new Text("127.0.0.1:9071"));
        token.setKind(WebHdfsFileSystem.TOKEN_KIND);
        ugi.addToken(token);
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)URI.create("webhdfs://127.0.0.1:9071"), (Configuration)conf);
        String tokenString = token.encodeToUrlString();
        Path fsPath = new Path("/");
        URL renewTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        URL cancelTokenUrl = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, fsPath, new Param[]{new TokenArgumentParam(tokenString)});
        Assert.assertEquals((Object)(this.generateUrlQueryPrefix((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN, ugi.getUserName()) + "&token=" + tokenString), (Object)renewTokenUrl.getQuery());
        Token delegationToken = new Token(token);
        delegationToken.setKind(WebHdfsFileSystem.TOKEN_KIND);
        Assert.assertEquals((Object)(this.generateUrlQueryPrefix((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, ugi.getUserName()) + "&token=" + tokenString + "&" + "delegation" + "=" + delegationToken.encodeToUrlString()), (Object)cancelTokenUrl.getQuery());
    }

    private String generateUrlQueryPrefix(HttpOpParam.Op op, String username) {
        return "op=" + op.toString() + "&user.name=" + username;
    }

    @Test
    public void testSelectHdfsDelegationToken() throws Exception {
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        Configuration conf = new Configuration();
        conf.setClass("fs.webhdfs.impl", MyWebHdfsFileSystem.class, FileSystem.class);
        URI fsUri = URI.create("webhdfs://localhost");
        MyWebHdfsFileSystem fs = (MyWebHdfsFileSystem)FileSystem.get((URI)fsUri, (Configuration)conf);
        this.checkTokenSelection(fs, conf);
        fsUri = URI.create("webhdfs://localhost:" + fs.getDefaultPort());
        fs = (MyWebHdfsFileSystem)FileSystem.get((URI)fsUri, (Configuration)conf);
        this.checkTokenSelection(fs, conf);
        fsUri = URI.create("webhdfs://localhost:" + (fs.getDefaultPort() - 1));
        fs = (MyWebHdfsFileSystem)FileSystem.get((URI)fsUri, (Configuration)conf);
        this.checkTokenSelection(fs, conf);
    }

    private void checkTokenSelection(MyWebHdfsFileSystem fs, Configuration conf) throws IOException {
        int port = fs.getCanonicalUri().getPort();
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)fs.getUri().getAuthority(), (String[])new String[0]);
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        Token hdfsToken = new Token(new byte[0], new byte[0], DelegationTokenIdentifier.HDFS_DELEGATION_KIND, new Text("127.0.0.1:8020"));
        ugi.addToken(hdfsToken);
        Token token = fs.selectDelegationToken(ugi);
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)hdfsToken, (Object)token);
        Token webHdfsToken = new Token(new byte[0], new byte[0], WebHdfsFileSystem.TOKEN_KIND, new Text("127.0.0.1:" + port));
        ugi.addToken(webHdfsToken);
        token = fs.selectDelegationToken(ugi);
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)webHdfsToken, (Object)token);
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)false);
        token = fs.selectDelegationToken(ugi);
        Assert.assertNull((Object)token);
        hdfsToken = new Token(new byte[0], new byte[0], DelegationTokenIdentifier.HDFS_DELEGATION_KIND, new Text("localhost:8020"));
        ugi.addToken(hdfsToken);
        token = fs.selectDelegationToken(ugi);
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)hdfsToken, (Object)token);
        webHdfsToken = new Token(new byte[0], new byte[0], WebHdfsFileSystem.TOKEN_KIND, new Text("localhost:" + port));
        ugi.addToken(webHdfsToken);
        token = fs.selectDelegationToken(ugi);
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)webHdfsToken, (Object)token);
    }

    static class MyWebHdfsFileSystem
    extends WebHdfsFileSystem {
        MyWebHdfsFileSystem() {
        }

        public URI getCanonicalUri() {
            return super.getCanonicalUri();
        }

        public int getDefaultPort() {
            return super.getDefaultPort();
        }

        protected void initDelegationToken() throws IOException {
        }
    }
}

