/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocol;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.qjournal.protocol.RequestInfo;
import org.apache.hadoop.hdfs.qjournal.protocolPB.QJournalProtocolPB;
import org.apache.hadoop.hdfs.qjournal.protocolPB.QJournalProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.PolicyProvider;

class JournalNodeRpcServer
implements QJournalProtocol {
    private static final int HANDLER_COUNT = 5;
    private JournalNode jn;
    private RPC.Server server;

    JournalNodeRpcServer(Configuration conf, JournalNode jn) throws IOException {
        this.jn = jn;
        Configuration confCopy = new Configuration(conf);
        confCopy.setBoolean("ipc.server.tcpnodelay", true);
        InetSocketAddress addr = JournalNodeRpcServer.getAddress(confCopy);
        RPC.setProtocolEngine((Configuration)confCopy, QJournalProtocolPB.class, ProtobufRpcEngine.class);
        QJournalProtocolServerSideTranslatorPB translator = new QJournalProtocolServerSideTranslatorPB(this);
        BlockingService service = QJournalProtocolProtos.QJournalProtocolService.newReflectiveBlockingService(translator);
        this.server = RPC.getServer(QJournalProtocolPB.class, (Object)service, (String)addr.getHostName(), (int)addr.getPort(), (int)5, (boolean)false, (Configuration)confCopy, null);
        if (confCopy.getBoolean("hadoop.security.authorization", false)) {
            this.server.refreshServiceAcl(confCopy, (PolicyProvider)new HDFSPolicyProvider());
        }
    }

    void start() {
        this.server.start();
    }

    public InetSocketAddress getAddress() {
        return this.server.getListenerAddress();
    }

    void join() throws InterruptedException {
        this.server.join();
    }

    void stop() {
        this.server.stop();
    }

    static InetSocketAddress getAddress(Configuration conf) {
        String addr = conf.get("dfs.journalnode.rpc-address", "0.0.0.0:8485");
        return NetUtils.createSocketAddr((String)addr, (int)0, (String)"dfs.journalnode.rpc-address");
    }

    @Override
    public boolean isFormatted(String journalId) throws IOException {
        return this.jn.getOrCreateJournal(journalId).isFormatted();
    }

    @Override
    public QJournalProtocolProtos.GetJournalStateResponseProto getJournalState(String journalId) throws IOException {
        long epoch = this.jn.getOrCreateJournal(journalId).getLastPromisedEpoch();
        return QJournalProtocolProtos.GetJournalStateResponseProto.newBuilder().setLastPromisedEpoch(epoch).setHttpPort(this.jn.getBoundHttpAddress().getPort()).build();
    }

    @Override
    public QJournalProtocolProtos.NewEpochResponseProto newEpoch(String journalId, NamespaceInfo nsInfo, long epoch) throws IOException {
        return this.jn.getOrCreateJournal(journalId).newEpoch(nsInfo, epoch);
    }

    @Override
    public void format(String journalId, NamespaceInfo nsInfo) throws IOException {
        this.jn.getOrCreateJournal(journalId).format(nsInfo);
    }

    @Override
    public void journal(RequestInfo reqInfo, long segmentTxId, long firstTxnId, int numTxns, byte[] records) throws IOException {
        this.jn.getOrCreateJournal(reqInfo.getJournalId()).journal(reqInfo, segmentTxId, firstTxnId, numTxns, records);
    }

    @Override
    public void heartbeat(RequestInfo reqInfo) throws IOException {
        this.jn.getOrCreateJournal(reqInfo.getJournalId()).heartbeat(reqInfo);
    }

    @Override
    public void startLogSegment(RequestInfo reqInfo, long txid) throws IOException {
        this.jn.getOrCreateJournal(reqInfo.getJournalId()).startLogSegment(reqInfo, txid);
    }

    @Override
    public void finalizeLogSegment(RequestInfo reqInfo, long startTxId, long endTxId) throws IOException {
        this.jn.getOrCreateJournal(reqInfo.getJournalId()).finalizeLogSegment(reqInfo, startTxId, endTxId);
    }

    @Override
    public void purgeLogsOlderThan(RequestInfo reqInfo, long minTxIdToKeep) throws IOException {
        this.jn.getOrCreateJournal(reqInfo.getJournalId()).purgeLogsOlderThan(reqInfo, minTxIdToKeep);
    }

    @Override
    public QJournalProtocolProtos.GetEditLogManifestResponseProto getEditLogManifest(String jid, long sinceTxId) throws IOException {
        RemoteEditLogManifest manifest = this.jn.getOrCreateJournal(jid).getEditLogManifest(sinceTxId);
        return QJournalProtocolProtos.GetEditLogManifestResponseProto.newBuilder().setManifest(PBHelper.convert(manifest)).setHttpPort(this.jn.getBoundHttpAddress().getPort()).build();
    }

    @Override
    public QJournalProtocolProtos.PrepareRecoveryResponseProto prepareRecovery(RequestInfo reqInfo, long segmentTxId) throws IOException {
        return this.jn.getOrCreateJournal(reqInfo.getJournalId()).prepareRecovery(reqInfo, segmentTxId);
    }

    @Override
    public void acceptRecovery(RequestInfo reqInfo, QJournalProtocolProtos.SegmentStateProto log, URL fromUrl) throws IOException {
        this.jn.getOrCreateJournal(reqInfo.getJournalId()).acceptRecovery(reqInfo, log, fromUrl);
    }
}

