/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Joiner;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.EnumMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputException;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.MetaRecoveryContext;
import org.apache.hadoop.hdfs.server.namenode.StreamLimiter;
import org.apache.hadoop.hdfs.util.Holder;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSEditLogLoader {
    static final Log LOG = LogFactory.getLog((String)FSEditLogLoader.class.getName());
    static long REPLAY_TRANSACTION_LOG_INTERVAL = 1000L;
    private final FSNamesystem fsNamesys;
    private long lastAppliedTxId;

    public FSEditLogLoader(FSNamesystem fsNamesys, long lastAppliedTxId) {
        this.fsNamesys = fsNamesys;
        this.lastAppliedTxId = lastAppliedTxId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long loadFSEdits(EditLogInputStream edits, long expectedStartingTxId, MetaRecoveryContext recovery) throws IOException {
        this.fsNamesys.writeLock();
        try {
            long startTime = Time.now();
            long numEdits = this.loadEditRecords(edits, false, expectedStartingTxId, recovery);
            FSImage.LOG.info((Object)("Edits file " + edits.getName() + " of size " + edits.length() + " edits # " + numEdits + " loaded in " + (Time.now() - startTime) / 1000L + " seconds."));
            long l = numEdits;
            return l;
        }
        finally {
            edits.close();
            this.fsNamesys.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long loadEditRecords(EditLogInputStream in, boolean closeOnExit, long expectedStartingTxId, MetaRecoveryContext recovery) throws IOException {
        FSDirectory fsDir = this.fsNamesys.dir;
        EnumMap<FSEditLogOpCodes, Holder<Integer>> opCounts = new EnumMap<FSEditLogOpCodes, Holder<Integer>>(FSEditLogOpCodes.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Acquiring write lock to replay edit log");
        }
        this.fsNamesys.writeLock();
        fsDir.writeLock();
        long[] recentOpcodeOffsets = new long[4];
        Arrays.fill(recentOpcodeOffsets, -1L);
        long expectedTxId = expectedStartingTxId;
        long numEdits = 0L;
        long lastTxId = in.getLastTxId();
        long numTxns = lastTxId - expectedStartingTxId + 1L;
        long lastLogTime = Time.now();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("edit log length: " + in.length() + ", start txid: " + expectedStartingTxId + ", last txid: " + lastTxId));
        }
        try {
            try {
                while (true) {
                    long now;
                    FSEditLogOp op;
                    block23: {
                        try {
                            op = in.readOp();
                            if (op != null) break block23;
                            break;
                        }
                        catch (Throwable e) {
                            this.check203UpgradeFailure(in.getVersion(), e);
                            String errorMessage = FSEditLogLoader.formatEditLogReplayError(in, recentOpcodeOffsets, expectedTxId);
                            FSImage.LOG.error((Object)errorMessage, e);
                            if (recovery == null) {
                                throw new EditLogInputException(errorMessage, e, numEdits);
                            }
                            MetaRecoveryContext.editLogLoaderPrompt("We failed to read txId " + expectedTxId, recovery, "skipping the bad section in the log");
                            in.resync();
                            continue;
                        }
                    }
                    recentOpcodeOffsets[(int)(numEdits % (long)recentOpcodeOffsets.length)] = in.getPosition();
                    if (op.hasTransactionId()) {
                        if (op.getTransactionId() > expectedTxId) {
                            MetaRecoveryContext.editLogLoaderPrompt("There appears to be a gap in the edit log.  We expected txid " + expectedTxId + ", but got txid " + op.getTransactionId() + ".", recovery, "ignoring missing  transaction IDs");
                        } else if (op.getTransactionId() < expectedTxId) {
                            MetaRecoveryContext.editLogLoaderPrompt("There appears to be an out-of-order edit in the edit log.  We expected txid " + expectedTxId + ", but got txid " + op.getTransactionId() + ".", recovery, "skipping the out-of-order edit");
                            continue;
                        }
                    }
                    try {
                        this.applyEditLogOp(op, fsDir, in.getVersion());
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Encountered exception on operation " + op), e);
                        MetaRecoveryContext.editLogLoaderPrompt("Failed to apply edit log operation " + op + ": error " + e.getMessage(), recovery, "applying edits");
                    }
                    this.incrOpCount(op.opCode, opCounts);
                    if (op.hasTransactionId()) {
                        this.lastAppliedTxId = op.getTransactionId();
                        expectedTxId = this.lastAppliedTxId + 1L;
                    } else {
                        expectedTxId = this.lastAppliedTxId = expectedStartingTxId;
                    }
                    if (op.hasTransactionId() && (now = Time.now()) - lastLogTime > REPLAY_TRANSACTION_LOG_INTERVAL) {
                        int percent = Math.round((float)this.lastAppliedTxId / (float)numTxns * 100.0f);
                        LOG.info((Object)("replaying edit log: " + this.lastAppliedTxId + "/" + numTxns + " transactions completed. (" + percent + "%)"));
                        lastLogTime = now;
                    }
                    ++numEdits;
                }
            }
            catch (MetaRecoveryContext.RequestStopException e) {
                MetaRecoveryContext.LOG.warn((Object)("Stopped reading edit log at " + in.getPosition() + "/" + in.length()));
            }
        }
        finally {
            if (closeOnExit) {
                in.close();
            }
            fsDir.writeUnlock();
            this.fsNamesys.writeUnlock();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"replaying edit log finished");
            }
            if (FSImage.LOG.isDebugEnabled()) {
                FSEditLogLoader.dumpOpCounts(opCounts);
            }
        }
        return numEdits;
    }

    private void applyEditLogOp(FSEditLogOp op, FSDirectory fsDir, int logVersion) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("replaying edit log: " + op));
        }
        switch (op.opCode) {
            case OP_ADD: {
                INodeFile oldFile;
                FSEditLogOp.AddCloseOp addCloseOp = (FSEditLogOp.AddCloseOp)op;
                if (FSNamesystem.LOG.isDebugEnabled()) {
                    FSNamesystem.LOG.debug((Object)((Object)((Object)op.opCode) + ": " + addCloseOp.path + " numblocks : " + addCloseOp.blocks.length + " clientHolder " + addCloseOp.clientName + " clientMachine " + addCloseOp.clientMachine));
                }
                INodeFile newFile = oldFile = FSEditLogLoader.getINodeFile(fsDir, addCloseOp.path);
                if (oldFile == null) {
                    short replication = this.fsNamesys.getBlockManager().adjustReplication(addCloseOp.replication);
                    assert (addCloseOp.blocks.length == 0);
                    newFile = (INodeFile)fsDir.unprotectedAddFile(addCloseOp.path, addCloseOp.permissions, replication, addCloseOp.mtime, addCloseOp.atime, addCloseOp.blockSize, true, addCloseOp.clientName, addCloseOp.clientMachine);
                    this.fsNamesys.leaseManager.addLease(addCloseOp.clientName, addCloseOp.path);
                } else if (!oldFile.isUnderConstruction()) {
                    if (FSNamesystem.LOG.isDebugEnabled()) {
                        FSNamesystem.LOG.debug((Object)"Reopening an already-closed file for append");
                    }
                    this.fsNamesys.prepareFileForWrite(addCloseOp.path, oldFile, addCloseOp.clientName, addCloseOp.clientMachine, null, false);
                    newFile = FSEditLogLoader.getINodeFile(fsDir, addCloseOp.path);
                }
                newFile.setAccessTime(addCloseOp.atime);
                newFile.setModificationTimeForce(addCloseOp.mtime);
                this.updateBlocks(fsDir, addCloseOp, newFile);
                break;
            }
            case OP_CLOSE: {
                INodeFile oldFile;
                FSEditLogOp.AddCloseOp addCloseOp = (FSEditLogOp.AddCloseOp)op;
                if (FSNamesystem.LOG.isDebugEnabled()) {
                    FSNamesystem.LOG.debug((Object)((Object)((Object)op.opCode) + ": " + addCloseOp.path + " numblocks : " + addCloseOp.blocks.length + " clientHolder " + addCloseOp.clientName + " clientMachine " + addCloseOp.clientMachine));
                }
                if ((oldFile = FSEditLogLoader.getINodeFile(fsDir, addCloseOp.path)) == null) {
                    throw new IOException("Operation trying to close non-existent file " + addCloseOp.path);
                }
                oldFile.setAccessTime(addCloseOp.atime);
                oldFile.setModificationTimeForce(addCloseOp.mtime);
                this.updateBlocks(fsDir, addCloseOp, oldFile);
                if (!oldFile.isUnderConstruction() && logVersion <= -40) {
                    throw new IOException("File is not under construction: " + addCloseOp.path);
                }
                if (!oldFile.isUnderConstruction()) break;
                INodeFileUnderConstruction ucFile = (INodeFileUnderConstruction)oldFile;
                this.fsNamesys.leaseManager.removeLeaseWithPrefixPath(addCloseOp.path);
                INodeFile newFile = ucFile.convertToInodeFile();
                fsDir.replaceNode(addCloseOp.path, ucFile, newFile);
                break;
            }
            case OP_UPDATE_BLOCKS: {
                INodeFile oldFile;
                FSEditLogOp.UpdateBlocksOp updateOp = (FSEditLogOp.UpdateBlocksOp)op;
                if (FSNamesystem.LOG.isDebugEnabled()) {
                    FSNamesystem.LOG.debug((Object)((Object)((Object)op.opCode) + ": " + updateOp.path + " numblocks : " + updateOp.blocks.length));
                }
                if ((oldFile = FSEditLogLoader.getINodeFile(fsDir, updateOp.path)) == null) {
                    throw new IOException("Operation trying to update blocks in non-existent file " + updateOp.path);
                }
                this.updateBlocks(fsDir, updateOp, oldFile);
                break;
            }
            case OP_SET_REPLICATION: {
                FSEditLogOp.SetReplicationOp setReplicationOp = (FSEditLogOp.SetReplicationOp)op;
                short replication = this.fsNamesys.getBlockManager().adjustReplication(setReplicationOp.replication);
                fsDir.unprotectedSetReplication(setReplicationOp.path, replication, null);
                break;
            }
            case OP_CONCAT_DELETE: {
                FSEditLogOp.ConcatDeleteOp concatDeleteOp = (FSEditLogOp.ConcatDeleteOp)op;
                fsDir.unprotectedConcat(concatDeleteOp.trg, concatDeleteOp.srcs, concatDeleteOp.timestamp);
                break;
            }
            case OP_RENAME_OLD: {
                FSEditLogOp.RenameOldOp renameOp = (FSEditLogOp.RenameOldOp)op;
                HdfsFileStatus dinfo = fsDir.getFileInfo(renameOp.dst, false);
                fsDir.unprotectedRenameTo(renameOp.src, renameOp.dst, renameOp.timestamp);
                this.fsNamesys.unprotectedChangeLease(renameOp.src, renameOp.dst, dinfo);
                break;
            }
            case OP_DELETE: {
                FSEditLogOp.DeleteOp deleteOp = (FSEditLogOp.DeleteOp)op;
                fsDir.unprotectedDelete(deleteOp.path, deleteOp.timestamp);
                break;
            }
            case OP_MKDIR: {
                FSEditLogOp.MkdirOp mkdirOp = (FSEditLogOp.MkdirOp)op;
                fsDir.unprotectedMkdir(mkdirOp.path, mkdirOp.permissions, mkdirOp.timestamp);
                break;
            }
            case OP_SET_GENSTAMP: {
                FSEditLogOp.SetGenstampOp setGenstampOp = (FSEditLogOp.SetGenstampOp)op;
                this.fsNamesys.setGenerationStamp(setGenstampOp.genStamp);
                break;
            }
            case OP_SET_PERMISSIONS: {
                FSEditLogOp.SetPermissionsOp setPermissionsOp = (FSEditLogOp.SetPermissionsOp)op;
                fsDir.unprotectedSetPermission(setPermissionsOp.src, setPermissionsOp.permissions);
                break;
            }
            case OP_SET_OWNER: {
                FSEditLogOp.SetOwnerOp setOwnerOp = (FSEditLogOp.SetOwnerOp)op;
                fsDir.unprotectedSetOwner(setOwnerOp.src, setOwnerOp.username, setOwnerOp.groupname);
                break;
            }
            case OP_SET_NS_QUOTA: {
                FSEditLogOp.SetNSQuotaOp setNSQuotaOp = (FSEditLogOp.SetNSQuotaOp)op;
                fsDir.unprotectedSetQuota(setNSQuotaOp.src, setNSQuotaOp.nsQuota, Long.MAX_VALUE);
                break;
            }
            case OP_CLEAR_NS_QUOTA: {
                FSEditLogOp.ClearNSQuotaOp clearNSQuotaOp = (FSEditLogOp.ClearNSQuotaOp)op;
                fsDir.unprotectedSetQuota(clearNSQuotaOp.src, -1L, Long.MAX_VALUE);
                break;
            }
            case OP_SET_QUOTA: {
                FSEditLogOp.SetQuotaOp setQuotaOp = (FSEditLogOp.SetQuotaOp)op;
                fsDir.unprotectedSetQuota(setQuotaOp.src, setQuotaOp.nsQuota, setQuotaOp.dsQuota);
                break;
            }
            case OP_TIMES: {
                FSEditLogOp.TimesOp timesOp = (FSEditLogOp.TimesOp)op;
                fsDir.unprotectedSetTimes(timesOp.path, timesOp.mtime, timesOp.atime, true);
                break;
            }
            case OP_SYMLINK: {
                FSEditLogOp.SymlinkOp symlinkOp = (FSEditLogOp.SymlinkOp)op;
                fsDir.unprotectedSymlink(symlinkOp.path, symlinkOp.value, symlinkOp.mtime, symlinkOp.atime, symlinkOp.permissionStatus);
                break;
            }
            case OP_RENAME: {
                FSEditLogOp.RenameOp renameOp = (FSEditLogOp.RenameOp)op;
                HdfsFileStatus dinfo = fsDir.getFileInfo(renameOp.dst, false);
                fsDir.unprotectedRenameTo(renameOp.src, renameOp.dst, renameOp.timestamp, renameOp.options);
                this.fsNamesys.unprotectedChangeLease(renameOp.src, renameOp.dst, dinfo);
                break;
            }
            case OP_GET_DELEGATION_TOKEN: {
                FSEditLogOp.GetDelegationTokenOp getDelegationTokenOp = (FSEditLogOp.GetDelegationTokenOp)op;
                this.fsNamesys.getDelegationTokenSecretManager().addPersistedDelegationToken(getDelegationTokenOp.token, getDelegationTokenOp.expiryTime);
                break;
            }
            case OP_RENEW_DELEGATION_TOKEN: {
                FSEditLogOp.RenewDelegationTokenOp renewDelegationTokenOp = (FSEditLogOp.RenewDelegationTokenOp)op;
                this.fsNamesys.getDelegationTokenSecretManager().updatePersistedTokenRenewal(renewDelegationTokenOp.token, renewDelegationTokenOp.expiryTime);
                break;
            }
            case OP_CANCEL_DELEGATION_TOKEN: {
                FSEditLogOp.CancelDelegationTokenOp cancelDelegationTokenOp = (FSEditLogOp.CancelDelegationTokenOp)op;
                this.fsNamesys.getDelegationTokenSecretManager().updatePersistedTokenCancellation(cancelDelegationTokenOp.token);
                break;
            }
            case OP_UPDATE_MASTER_KEY: {
                FSEditLogOp.UpdateMasterKeyOp updateMasterKeyOp = (FSEditLogOp.UpdateMasterKeyOp)op;
                this.fsNamesys.getDelegationTokenSecretManager().updatePersistedMasterKey(updateMasterKeyOp.key);
                break;
            }
            case OP_REASSIGN_LEASE: {
                FSEditLogOp.ReassignLeaseOp reassignLeaseOp = (FSEditLogOp.ReassignLeaseOp)op;
                LeaseManager.Lease lease = this.fsNamesys.leaseManager.getLease(reassignLeaseOp.leaseHolder);
                INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)fsDir.getFileINode(reassignLeaseOp.path);
                this.fsNamesys.reassignLeaseInternal(lease, reassignLeaseOp.path, reassignLeaseOp.newHolder, pendingFile);
                break;
            }
            case OP_START_LOG_SEGMENT: 
            case OP_END_LOG_SEGMENT: {
                break;
            }
            default: {
                throw new IOException("Invalid operation read " + (Object)((Object)op.opCode));
            }
        }
    }

    private static String formatEditLogReplayError(EditLogInputStream in, long[] recentOpcodeOffsets, long txid) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error replaying edit log at offset " + in.getPosition());
        sb.append(".  Expected transaction ID was ").append(txid);
        if (recentOpcodeOffsets[0] != -1L) {
            Arrays.sort(recentOpcodeOffsets);
            sb.append("\nRecent opcode offsets:");
            for (long offset : recentOpcodeOffsets) {
                if (offset == -1L) continue;
                sb.append(' ').append(offset);
            }
        }
        return sb.toString();
    }

    private static INodeFile getINodeFile(FSDirectory fsDir, String path) throws IOException {
        INode inode = fsDir.getINode(path);
        if (inode != null && !(inode instanceof INodeFile)) {
            throw new IOException("Operation trying to get non-file " + path);
        }
        return (INodeFile)inode;
    }

    private void updateBlocks(FSDirectory fsDir, FSEditLogOp.BlockListUpdatingOp op, INodeFile file) throws IOException {
        int i;
        BlockInfo[] oldBlocks = file.getBlocks();
        Block[] newBlocks = op.getBlocks();
        String path = op.getPath();
        boolean isGenStampUpdate = oldBlocks.length == newBlocks.length;
        for (i = 0; i < oldBlocks.length && i < newBlocks.length; ++i) {
            boolean isLastBlock;
            BlockInfo oldBlock = oldBlocks[i];
            Block newBlock = newBlocks[i];
            boolean bl = isLastBlock = i == newBlocks.length - 1;
            if (oldBlock.getBlockId() != newBlock.getBlockId() || oldBlock.getGenerationStamp() != newBlock.getGenerationStamp() && (!isGenStampUpdate || !isLastBlock)) {
                throw new IOException("Mismatched block IDs or generation stamps, attempting to replace block " + oldBlock + " with " + newBlock + " as block # " + i + "/" + newBlocks.length + " of " + path);
            }
            oldBlock.setNumBytes(newBlock.getNumBytes());
            boolean changeMade = oldBlock.getGenerationStamp() != newBlock.getGenerationStamp();
            oldBlock.setGenerationStamp(newBlock.getGenerationStamp());
            if (oldBlock instanceof BlockInfoUnderConstruction && (!isLastBlock || op.shouldCompleteLastBlock())) {
                changeMade = true;
                this.fsNamesys.getBlockManager().forceCompleteBlock((INodeFileUnderConstruction)file, (BlockInfoUnderConstruction)oldBlock);
            }
            if (!changeMade) continue;
            this.fsNamesys.getBlockManager().processQueuedMessagesForBlock(newBlock);
        }
        if (newBlocks.length < oldBlocks.length) {
            if (!file.isUnderConstruction()) {
                throw new IOException("Trying to remove a block from file " + path + " which is not under construction.");
            }
            if (newBlocks.length != oldBlocks.length - 1) {
                throw new IOException("Trying to remove more than one block from file " + path);
            }
            fsDir.unprotectedRemoveBlock(path, (INodeFileUnderConstruction)file, oldBlocks[oldBlocks.length - 1]);
        } else if (newBlocks.length > oldBlocks.length) {
            for (i = oldBlocks.length; i < newBlocks.length; ++i) {
                Block newBlock = newBlocks[i];
                BlockInfo newBI = !op.shouldCompleteLastBlock() ? new BlockInfoUnderConstruction(newBlock, file.getReplication()) : new BlockInfo(newBlock, file.getReplication());
                this.fsNamesys.getBlockManager().addBlockCollection(newBI, file);
                file.addBlock(newBI);
                this.fsNamesys.getBlockManager().processQueuedMessagesForBlock(newBlock);
            }
        }
    }

    private static void dumpOpCounts(EnumMap<FSEditLogOpCodes, Holder<Integer>> opCounts) {
        StringBuilder sb = new StringBuilder();
        sb.append("Summary of operations loaded from edit log:\n  ");
        Joiner.on((String)"\n  ").withKeyValueSeparator("=").appendTo(sb, opCounts);
        FSImage.LOG.debug((Object)sb.toString());
    }

    private void incrOpCount(FSEditLogOpCodes opCode, EnumMap<FSEditLogOpCodes, Holder<Integer>> opCounts) {
        Holder<Integer> holder = opCounts.get((Object)opCode);
        if (holder == null) {
            holder = new Holder<Integer>(1);
            opCounts.put(opCode, holder);
        } else {
            Holder<Integer> holder2 = holder;
            Object t = holder2.held;
            holder2.held = (Integer)holder2.held + 1;
            Integer n = holder2.held;
        }
    }

    private void check203UpgradeFailure(int logVersion, Throwable e) throws IOException {
        if (Storage.is203LayoutVersion(logVersion) && logVersion != HdfsConstants.LAYOUT_VERSION) {
            String msg = "During upgrade failed to load the editlog version " + logVersion + " from release 0.20.203. Please go back to the old " + " release and restart the namenode. This empties the editlog " + " and saves the namespace. Resume the upgrade after this step.";
            throw new IOException(msg, e);
        }
    }

    static EditLogValidation validateEditLog(EditLogInputStream in) {
        long lastPos = 0L;
        long lastTxId = -12345L;
        long numValid = 0L;
        FSEditLogOp op = null;
        while (true) {
            lastPos = in.getPosition();
            try {
                op = in.readOp();
                if (op == null) {
                    break;
                }
            }
            catch (Throwable t) {
                FSImage.LOG.warn((Object)("Caught exception after reading " + numValid + " ops from " + in + " while determining its valid length." + "Position was " + lastPos), t);
                in.resync();
                FSImage.LOG.warn((Object)("After resync, position is " + in.getPosition()));
                continue;
            }
            if (lastTxId == -12345L || op.getTransactionId() > lastTxId) {
                lastTxId = op.getTransactionId();
            }
            ++numValid;
        }
        return new EditLogValidation(lastPos, lastTxId, false);
    }

    public long getLastAppliedTxId() {
        return this.lastAppliedTxId;
    }

    public static class PositionTrackingInputStream
    extends FilterInputStream
    implements StreamLimiter {
        private long curPos = 0L;
        private long markPos = -1L;
        private long limitPos = Long.MAX_VALUE;

        public PositionTrackingInputStream(InputStream is) {
            super(is);
        }

        private void checkLimit(long amt) throws IOException {
            long extra = this.curPos + amt - this.limitPos;
            if (extra > 0L) {
                throw new IOException("Tried to read " + amt + " byte(s) past " + "the limit at offset " + this.limitPos);
            }
        }

        @Override
        public int read() throws IOException {
            this.checkLimit(1L);
            int ret = super.read();
            if (ret != -1) {
                ++this.curPos;
            }
            return ret;
        }

        @Override
        public int read(byte[] data) throws IOException {
            this.checkLimit(data.length);
            int ret = super.read(data);
            if (ret > 0) {
                this.curPos += (long)ret;
            }
            return ret;
        }

        @Override
        public int read(byte[] data, int offset, int length) throws IOException {
            this.checkLimit(length);
            int ret = super.read(data, offset, length);
            if (ret > 0) {
                this.curPos += (long)ret;
            }
            return ret;
        }

        @Override
        public void setLimit(long limit) {
            this.limitPos = this.curPos + limit;
        }

        @Override
        public void clearLimit() {
            this.limitPos = Long.MAX_VALUE;
        }

        @Override
        public void mark(int limit) {
            super.mark(limit);
            this.markPos = this.curPos;
        }

        @Override
        public void reset() throws IOException {
            if (this.markPos == -1L) {
                throw new IOException("Not marked!");
            }
            super.reset();
            this.curPos = this.markPos;
            this.markPos = -1L;
        }

        public long getPos() {
            return this.curPos;
        }

        @Override
        public long skip(long amt) throws IOException {
            long extra = this.curPos + amt - this.limitPos;
            if (extra > 0L) {
                throw new IOException("Tried to skip " + extra + " bytes past " + "the limit at offset " + this.limitPos);
            }
            long ret = super.skip(amt);
            this.curPos += ret;
            return ret;
        }
    }

    static class EditLogValidation {
        private final long validLength;
        private final long endTxId;
        private final boolean hasCorruptHeader;

        EditLogValidation(long validLength, long endTxId, boolean hasCorruptHeader) {
            this.validLength = validLength;
            this.endTxId = endTxId;
            this.hasCorruptHeader = hasCorruptHeader;
        }

        long getValidLength() {
            return this.validLength;
        }

        long getEndTxId() {
            return this.endTxId;
        }

        boolean hasCorruptHeader() {
            return this.hasCorruptHeader;
        }
    }
}

