/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;

public class GetDelegationTokenServlet
extends DfsServlet {
    private static final Log LOG = LogFactory.getLog(GetDelegationTokenServlet.class);
    public static final String PATH_SPEC = "/getDelegationToken";
    public static final String RENEWER = "renewer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserGroupInformation ugi;
        ServletContext context = this.getServletContext();
        Configuration conf = NameNodeHttpServer.getConfFromContext(context);
        try {
            ugi = this.getUGI(req, conf);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Request for token received with no authentication from " + req.getRemoteAddr()), (Throwable)ioe);
            resp.sendError(403, "Unable to identify or authenticate user");
            return;
        }
        LOG.info((Object)("Sending token: {" + ugi.getUserName() + "," + req.getRemoteAddr() + "}"));
        final NameNode nn = NameNodeHttpServer.getNameNodeFromContext(context);
        String renewer = req.getParameter(RENEWER);
        final String renewerFinal = renewer == null ? req.getUserPrincipal().getName() : renewer;
        DataOutputStream dos = null;
        try {
            final DataOutputStream dosFinal = dos = new DataOutputStream((OutputStream)resp.getOutputStream());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    Credentials ts = DelegationTokenSecretManager.createCredentials(nn, ugi, renewerFinal);
                    ts.write((DataOutput)dosFinal);
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.info((Object)"Exception while sending token. Re-throwing. ", (Throwable)e);
            resp.sendError(500);
        }
        finally {
            if (dos != null) {
                dos.close();
            }
        }
    }
}

