/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hdfs.server.namenode.EditLogBackupOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;

class BackupJournalManager
implements JournalManager {
    private final NamenodeRegistration nnReg;
    private final NamenodeRegistration bnReg;

    BackupJournalManager(NamenodeRegistration bnReg, NamenodeRegistration nnReg) {
        this.bnReg = bnReg;
        this.nnReg = nnReg;
    }

    @Override
    public void format(NamespaceInfo nsInfo) {
        throw new UnsupportedOperationException("BackupNode journal should never get formatted");
    }

    @Override
    public boolean hasSomeData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EditLogOutputStream startLogSegment(long txId) throws IOException {
        EditLogBackupOutputStream stm = new EditLogBackupOutputStream(this.bnReg, this.nnReg);
        stm.startLogSegment(txId);
        return stm;
    }

    @Override
    public void finalizeLogSegment(long firstTxId, long lastTxId) throws IOException {
    }

    @Override
    public void setOutputBufferCapacity(int size) {
    }

    @Override
    public void purgeLogsOlderThan(long minTxIdToKeep) throws IOException {
    }

    @Override
    public void selectInputStreams(Collection<EditLogInputStream> streams, long fromTxnId, boolean inProgressOk, boolean forReading) {
    }

    @Override
    public void recoverUnfinalizedSegments() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public boolean matchesRegistration(NamenodeRegistration bnReg) {
        return bnReg.getAddress().equals(this.bnReg.getAddress());
    }

    @Override
    public String toString() {
        return "BackupJournalManager";
    }
}

