/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class DatanodeProtocolClientSideTranslatorPB
implements ProtocolMetaInterface,
DatanodeProtocol,
Closeable {
    private final DatanodeProtocolPB rpcProxy;
    private static final HdfsProtos.VersionRequestProto VERSION_REQUEST = HdfsProtos.VersionRequestProto.newBuilder().build();
    private static final RpcController NULL_CONTROLLER = null;

    public DatanodeProtocolClientSideTranslatorPB(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, DatanodeProtocolPB.class, ProtobufRpcEngine.class);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.rpcProxy = DatanodeProtocolClientSideTranslatorPB.createNamenodeWithRetry(DatanodeProtocolClientSideTranslatorPB.createNamenode(nameNodeAddr, conf, ugi));
    }

    private static DatanodeProtocolPB createNamenode(InetSocketAddress nameNodeAddr, Configuration conf, UserGroupInformation ugi) throws IOException {
        return (DatanodeProtocolPB)RPC.getProtocolProxy(DatanodeProtocolPB.class, (long)RPC.getProtocolVersion(DatanodeProtocolPB.class), (InetSocketAddress)nameNodeAddr, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, DatanodeProtocolPB.class), (int)Client.getPingInterval((Configuration)conf), null).getProxy();
    }

    static DatanodeProtocolPB createNamenodeWithRetry(DatanodeProtocolPB rpcNamenode) {
        RetryPolicy createPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)5, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap<Class<AlreadyBeingCreatedException>, RetryPolicy> remoteExceptionToPolicyMap = new HashMap<Class<AlreadyBeingCreatedException>, RetryPolicy>();
        remoteExceptionToPolicyMap.put(AlreadyBeingCreatedException.class, createPolicy);
        HashMap<Class<RemoteException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<RemoteException>, RetryPolicy>();
        exceptionToPolicyMap.put(RemoteException.class, RetryPolicies.retryByRemoteException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, remoteExceptionToPolicyMap));
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("create", methodPolicy);
        return (DatanodeProtocolPB)RetryProxy.create(DatanodeProtocolPB.class, (Object)rpcNamenode, methodNameToPolicyMap);
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public DatanodeRegistration registerDatanode(DatanodeRegistration registration) throws IOException {
        DatanodeProtocolProtos.RegisterDatanodeResponseProto resp;
        DatanodeProtocolProtos.RegisterDatanodeRequestProto.Builder builder = DatanodeProtocolProtos.RegisterDatanodeRequestProto.newBuilder().setRegistration(PBHelper.convert(registration));
        try {
            resp = this.rpcProxy.registerDatanode(NULL_CONTROLLER, builder.build());
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException((ServiceException)se);
        }
        return PBHelper.convert(resp.getRegistration());
    }

    @Override
    public HeartbeatResponse sendHeartbeat(DatanodeRegistration registration, StorageReport[] reports, int xmitsInProgress, int xceiverCount, int failedVolumes) throws IOException {
        DatanodeProtocolProtos.HeartbeatResponseProto resp;
        DatanodeProtocolProtos.HeartbeatRequestProto.Builder builder = DatanodeProtocolProtos.HeartbeatRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).setXmitsInProgress(xmitsInProgress).setXceiverCount(xceiverCount).setFailedVolumes(failedVolumes);
        for (StorageReport r : reports) {
            builder.addReports(PBHelper.convert(r));
        }
        try {
            resp = this.rpcProxy.sendHeartbeat(NULL_CONTROLLER, builder.build());
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException((ServiceException)se);
        }
        DatanodeCommand[] cmds = new DatanodeCommand[resp.getCmdsList().size()];
        int index = 0;
        for (DatanodeProtocolProtos.DatanodeCommandProto p : resp.getCmdsList()) {
            cmds[index] = PBHelper.convert(p);
            ++index;
        }
        return new HeartbeatResponse(cmds, PBHelper.convert(resp.getHaStatus()));
    }

    @Override
    public DatanodeCommand blockReport(DatanodeRegistration registration, String poolId, StorageBlockReport[] reports) throws IOException {
        DatanodeProtocolProtos.BlockReportResponseProto resp;
        DatanodeProtocolProtos.BlockReportRequestProto.Builder builder = DatanodeProtocolProtos.BlockReportRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).setBlockPoolId(poolId);
        for (StorageBlockReport r : reports) {
            DatanodeProtocolProtos.StorageBlockReportProto.Builder reportBuilder = DatanodeProtocolProtos.StorageBlockReportProto.newBuilder().setStorage(PBHelper.convert(r.getStorage()));
            long[] blocks = r.getBlocks();
            for (int i = 0; i < blocks.length; ++i) {
                reportBuilder.addBlocks(blocks[i]);
            }
            builder.addReports(reportBuilder.build());
        }
        try {
            resp = this.rpcProxy.blockReport(NULL_CONTROLLER, builder.build());
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException((ServiceException)se);
        }
        return resp.hasCmd() ? PBHelper.convert(resp.getCmd()) : null;
    }

    @Override
    public void blockReceivedAndDeleted(DatanodeRegistration registration, String poolId, StorageReceivedDeletedBlocks[] receivedAndDeletedBlocks) throws IOException {
        DatanodeProtocolProtos.BlockReceivedAndDeletedRequestProto.Builder builder = DatanodeProtocolProtos.BlockReceivedAndDeletedRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).setBlockPoolId(poolId);
        for (StorageReceivedDeletedBlocks storageBlock : receivedAndDeletedBlocks) {
            DatanodeProtocolProtos.StorageReceivedDeletedBlocksProto.Builder repBuilder = DatanodeProtocolProtos.StorageReceivedDeletedBlocksProto.newBuilder();
            repBuilder.setStorageID(storageBlock.getStorageID());
            for (ReceivedDeletedBlockInfo rdBlock : storageBlock.getBlocks()) {
                repBuilder.addBlocks(PBHelper.convert(rdBlock));
            }
            builder.addBlocks(repBuilder.build());
        }
        try {
            this.rpcProxy.blockReceivedAndDeleted(NULL_CONTROLLER, builder.build());
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException((ServiceException)se);
        }
    }

    @Override
    public void errorReport(DatanodeRegistration registration, int errorCode, String msg) throws IOException {
        DatanodeProtocolProtos.ErrorReportRequestProto req = DatanodeProtocolProtos.ErrorReportRequestProto.newBuilder().setRegistartion(PBHelper.convert(registration)).setErrorCode(errorCode).setMsg(msg).build();
        try {
            this.rpcProxy.errorReport(NULL_CONTROLLER, req);
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException((ServiceException)se);
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        try {
            return PBHelper.convert(this.rpcProxy.versionRequest(NULL_CONTROLLER, VERSION_REQUEST).getInfo());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public UpgradeCommand processUpgradeCommand(UpgradeCommand comm) throws IOException {
        DatanodeProtocolProtos.ProcessUpgradeResponseProto resp;
        DatanodeProtocolProtos.ProcessUpgradeRequestProto req = DatanodeProtocolProtos.ProcessUpgradeRequestProto.newBuilder().setCmd(PBHelper.convert(comm)).build();
        try {
            resp = this.rpcProxy.processUpgrade(NULL_CONTROLLER, req);
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException((ServiceException)se);
        }
        return resp.hasCmd() ? PBHelper.convert(resp.getCmd()) : null;
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        DatanodeProtocolProtos.ReportBadBlocksRequestProto.Builder builder = DatanodeProtocolProtos.ReportBadBlocksRequestProto.newBuilder();
        for (int i = 0; i < blocks.length; ++i) {
            builder.addBlocks(i, PBHelper.convert(blocks[i]));
        }
        DatanodeProtocolProtos.ReportBadBlocksRequestProto req = builder.build();
        try {
            this.rpcProxy.reportBadBlocks(NULL_CONTROLLER, req);
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException((ServiceException)se);
        }
    }

    @Override
    public void commitBlockSynchronization(ExtendedBlock block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException {
        DatanodeProtocolProtos.CommitBlockSynchronizationRequestProto.Builder builder = DatanodeProtocolProtos.CommitBlockSynchronizationRequestProto.newBuilder().setBlock(PBHelper.convert(block)).setNewGenStamp(newgenerationstamp).setNewLength(newlength).setCloseFile(closeFile).setDeleteBlock(deleteblock);
        for (int i = 0; i < newtargets.length; ++i) {
            builder.addNewTaragets(PBHelper.convert(newtargets[i]));
            builder.addNewTargetStorages(newtargetstorages[i]);
        }
        DatanodeProtocolProtos.CommitBlockSynchronizationRequestProto req = builder.build();
        try {
            this.rpcProxy.commitBlockSynchronization(NULL_CONTROLLER, req);
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException((ServiceException)se);
        }
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, DatanodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(DatanodeProtocolPB.class), (String)methodName);
    }
}

