/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import org.apache.hadoop.hdfs.protocol.Block;

public class ReceivedDeletedBlockInfo {
    Block block;
    BlockStatus status;
    String delHints;

    public ReceivedDeletedBlockInfo() {
    }

    public ReceivedDeletedBlockInfo(Block blk, BlockStatus status, String delHints) {
        this.block = blk;
        this.status = status;
        this.delHints = delHints;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block blk) {
        this.block = blk;
    }

    public String getDelHints() {
        return this.delHints;
    }

    public void setDelHints(String hints) {
        this.delHints = hints;
    }

    public BlockStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReceivedDeletedBlockInfo)) {
            return false;
        }
        ReceivedDeletedBlockInfo other = (ReceivedDeletedBlockInfo)o;
        return this.block.equals(other.getBlock()) && this.status == other.status && (this.delHints == other.delHints || this.delHints != null && this.delHints.equals(other.delHints));
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public boolean blockEquals(Block b) {
        return this.block.equals(b);
    }

    public boolean isDeletedBlock() {
        return this.status == BlockStatus.DELETED_BLOCK;
    }

    public String toString() {
        return this.block.toString() + ", status: " + (Object)((Object)this.status) + ", delHint: " + this.delHints;
    }

    public static enum BlockStatus {
        RECEIVING_BLOCK(1),
        RECEIVED_BLOCK(2),
        DELETED_BLOCK(3);

        private final int code;

        private BlockStatus(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static BlockStatus fromCode(int code) {
            for (BlockStatus bs : BlockStatus.values()) {
                if (bs.code != code) continue;
                return bs;
            }
            return null;
        }
    }
}

