/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.IPFailoverProxyProvider;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.net.StandardSocketFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import sun.net.spi.nameservice.NameService;

public class TestDFSClientFailover {
    private static final Log LOG = LogFactory.getLog(TestDFSClientFailover.class);
    private static final Path TEST_FILE = new Path("/tmp/failover-test-file");
    private static final int FILE_LENGTH_TO_VERIFY = 100;
    private final Configuration conf = new Configuration();
    private MiniDFSCluster cluster;

    @Before
    public void setUpCluster() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
        this.cluster.transitionToActive(0);
        this.cluster.waitActive();
    }

    @After
    public void tearDownCluster() throws IOException {
        this.cluster.shutdown();
    }

    @Test
    public void testDfsClientFailover() throws IOException, URISyntaxException {
        FileSystem fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
        DFSTestUtil.createFile(fs, TEST_FILE, 100L, (short)1, 1L);
        Assert.assertEquals((long)fs.getFileStatus(TEST_FILE).getLen(), (long)100L);
        this.cluster.shutdownNameNode(0);
        this.cluster.transitionToActive(1);
        Assert.assertEquals((long)fs.getFileStatus(TEST_FILE).getLen(), (long)100L);
        Path withPort = new Path("hdfs://" + HATestUtil.getLogicalHostname(this.cluster) + ":" + 8020 + "/" + TEST_FILE.toUri().getPath());
        FileSystem fs2 = withPort.getFileSystem(fs.getConf());
        Assert.assertTrue((boolean)fs2.exists(withPort));
        fs.close();
    }

    @Test
    public void testFailoverOnConnectTimeout() throws Exception {
        this.conf.setClass("hadoop.rpc.socket.factory.class.default", InjectingSocketFactory.class, SocketFactory.class);
        InjectingSocketFactory.portToInjectOn = this.cluster.getNameNodePort(0);
        FileSystem fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
        this.cluster.shutdownNameNode(0);
        this.cluster.transitionToActive(1);
        IOUtils.closeStream((Closeable)fs.create(TEST_FILE));
    }

    @Test
    public void testLogicalUriShouldNotHavePorts() {
        HdfsConfiguration config = new HdfsConfiguration(this.conf);
        String logicalName = HATestUtil.getLogicalHostname(this.cluster);
        HATestUtil.setFailoverConfigurations(this.cluster, (Configuration)config, logicalName);
        Path p = new Path("hdfs://" + logicalName + ":12345/");
        try {
            p.getFileSystem((Configuration)config).exists(p);
            Assert.fail((String)"Did not fail with fake FS");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"does not use port information", (Throwable)ioe);
        }
    }

    @Test
    public void testFailureWithMisconfiguredHaNNs() throws Exception {
        String logicalHost = "misconfigured-ha-uri";
        Configuration conf = new Configuration();
        conf.set("dfs.client.failover.proxy.provider." + logicalHost, ConfiguredFailoverProxyProvider.class.getName());
        URI uri = new URI("hdfs://" + logicalHost + "/test");
        try {
            FileSystem.get((URI)uri, (Configuration)conf).exists(new Path("/test"));
            Assert.fail((String)"Successfully got proxy provider for misconfigured FS");
        }
        catch (IOException ioe) {
            LOG.info((Object)"got expected exception", (Throwable)ioe);
            Assert.assertTrue((String)"expected exception did not contain helpful message", (boolean)StringUtils.stringifyException((Throwable)ioe).contains("Could not find any configured addresses for URI " + uri));
        }
    }

    private NameService spyOnNameService() {
        try {
            Field f = InetAddress.class.getDeclaredField("nameServices");
            f.setAccessible(true);
            Assume.assumeNotNull((Object[])new Object[]{f});
            List nsList = (List)f.get(null);
            NameService ns = (NameService)nsList.get(0);
            Log log = LogFactory.getLog((String)"NameServiceSpy");
            ns = (NameService)Mockito.mock(NameService.class, (Answer)new GenericTestUtils.DelegateAnswer(log, (Object)ns));
            nsList.set(0, ns);
            return ns;
        }
        catch (Throwable t) {
            LOG.info((Object)"Unable to spy on DNS. Skipping test.", t);
            Assume.assumeNoException((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    @Test
    public void testDoesntDnsResolveLogicalURI() throws Exception {
        FileSystem fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
        NameService spyNS = this.spyOnNameService();
        String logicalHost = fs.getUri().getHost();
        Path qualifiedRoot = fs.makeQualified(new Path("/"));
        fs.getCanonicalServiceName();
        fs.listStatus(qualifiedRoot);
        ((NameService)Mockito.verify((Object)spyNS, (VerificationMode)Mockito.never())).lookupAllHostAddr((String)Mockito.eq((Object)logicalHost));
    }

    @Test
    public void testFileContextDoesntDnsResolveLogicalURI() throws Exception {
        FileSystem fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
        NameService spyNS = this.spyOnNameService();
        String logicalHost = fs.getUri().getHost();
        Configuration haClientConf = fs.getConf();
        FileContext fc = FileContext.getFileContext((Configuration)haClientConf);
        Path root = new Path("/");
        fc.listStatus(root);
        fc.listStatus(fc.makeQualified(root));
        fc.getDefaultFileSystem().getCanonicalServiceName();
        ((NameService)Mockito.verify((Object)spyNS, (VerificationMode)Mockito.never())).lookupAllHostAddr((String)Mockito.eq((Object)logicalHost));
    }

    public void testWrappedFailoverProxyProvider() throws Exception {
        HdfsConfiguration config = new HdfsConfiguration(this.conf);
        String logicalName = HATestUtil.getLogicalHostname(this.cluster);
        HATestUtil.setFailoverConfigurations(this.cluster, (Configuration)config, logicalName);
        config.set("dfs.client.failover.proxy.provider." + logicalName, DummyLegacyFailoverProxyProvider.class.getName());
        Path p = new Path("hdfs://" + logicalName + "/");
        Assert.assertTrue((String)"Legacy proxy providers should use logical URI.", (boolean)HAUtil.useLogicalUri((Configuration)config, (URI)p.toUri()));
    }

    public void testIPFailoverProxyProviderLogicalUri() throws Exception {
        HdfsConfiguration config = new HdfsConfiguration(this.conf);
        URI nnUri = this.cluster.getURI(0);
        config.set("dfs.client.failover.proxy.provider." + nnUri.getHost(), IPFailoverProxyProvider.class.getName());
        Assert.assertFalse((String)"IPFailoverProxyProvider should not use logical URI.", (boolean)HAUtil.useLogicalUri((Configuration)config, (URI)nnUri));
    }

    public static class DummyLegacyFailoverProxyProvider<T>
    implements FailoverProxyProvider<T> {
        private Class<T> xface;
        private T proxy;

        public DummyLegacyFailoverProxyProvider(Configuration conf, URI uri, Class<T> xface) {
            try {
                this.proxy = NameNodeProxies.createNonHAProxy((Configuration)conf, (InetSocketAddress)NameNode.getAddress((URI)uri), xface, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (boolean)false).getProxy();
                this.xface = xface;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }

        public Class<T> getInterface() {
            return this.xface;
        }

        public FailoverProxyProvider.ProxyInfo<T> getProxy() {
            return new FailoverProxyProvider.ProxyInfo(this.proxy, "dummy");
        }

        public void performFailover(T currentProxy) {
        }

        public void close() throws IOException {
        }
    }

    private static class InjectingSocketFactory
    extends StandardSocketFactory {
        static final SocketFactory defaultFactory = SocketFactory.getDefault();
        static int portToInjectOn;

        private InjectingSocketFactory() {
        }

        public Socket createSocket() throws IOException {
            Socket spy = (Socket)Mockito.spy((Object)defaultFactory.createSocket());
            ((Socket)Mockito.doReturn(null).when((Object)spy)).getChannel();
            ((Socket)Mockito.doThrow((Throwable)new ConnectTimeoutException("injected")).when((Object)spy)).connect((SocketAddress)Mockito.argThat((Matcher)new MatchesPort()), Mockito.anyInt());
            return spy;
        }

        private class MatchesPort
        extends BaseMatcher<SocketAddress> {
            private MatchesPort() {
            }

            public boolean matches(Object arg0) {
                return ((InetSocketAddress)arg0).getPort() == portToInjectOn;
            }

            public void describeTo(Description desc) {
                desc.appendText("matches port " + portToInjectOn);
            }
        }
    }
}

