/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HardLink;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.Assert;
import org.junit.Test;

public class TestFileAppend {
    final boolean simulatedStorage = false;
    private static byte[] fileContents = null;

    private void writeFile(FSDataOutputStream stm) throws IOException {
        byte[] buffer = AppendTestUtil.initBuffer(10241);
        stm.write(buffer);
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException {
        boolean done = false;
        block2: while (!done) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            done = true;
            BlockLocation[] locations = fileSys.getFileBlockLocations(fileSys.getFileStatus(name), 0L, 10241L);
            if (locations.length < 10) {
                System.out.println("Number of blocks found " + locations.length);
                done = false;
                continue;
            }
            for (int idx = 0; idx < 10; ++idx) {
                if (locations[idx].getHosts().length >= repl) continue;
                System.out.println("Block index " + idx + " not yet replciated.");
                done = false;
                continue block2;
            }
        }
        byte[] expected = new byte[10240];
        System.arraycopy(fileContents, 0, expected, 0, expected.length);
        AppendTestUtil.checkFullFile(fileSys, name, 10240, expected, "Read 1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyOnWrite() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, (Configuration)conf);
        try {
            ExtendedBlock b;
            int i;
            Path file1 = new Path("/filestatus.dat");
            FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, file1, 1);
            this.writeFile(stm);
            stm.close();
            DataNode[] dn = cluster.listDataNodes();
            Assert.assertTrue((String)("There should be only one datanode but found " + dn.length), (dn.length == 1 ? 1 : 0) != 0);
            LocatedBlocks locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            List blocks = locations.getLocatedBlocks();
            for (i = 0; i < blocks.size(); i += 2) {
                b = ((LocatedBlock)blocks.get(i)).getBlock();
                File f = DataNodeTestUtils.getFile(dn[0], b.getBlockPoolId(), b.getLocalBlock().getBlockId());
                File link = new File(f.toString() + ".link");
                System.out.println("Creating hardlink for File " + f + " to " + link);
                HardLink.createHardLink((File)f, (File)link);
            }
            for (i = 0; i < blocks.size(); ++i) {
                b = ((LocatedBlock)blocks.get(i)).getBlock();
                System.out.println("testCopyOnWrite detaching block " + b);
                Assert.assertTrue((String)("Detaching block " + b + " should have returned true"), (boolean)DataNodeTestUtils.unlinkBlock(dn[0], b, 1));
            }
            for (i = 0; i < blocks.size(); ++i) {
                b = ((LocatedBlock)blocks.get(i)).getBlock();
                System.out.println("testCopyOnWrite detaching block " + b);
                Assert.assertTrue((String)("Detaching block " + b + " should have returned false"), (!DataNodeTestUtils.unlinkBlock(dn[0], b, 1) ? 1 : 0) != 0);
            }
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    @Test
    public void testSimpleFlush() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        fileContents = AppendTestUtil.initBuffer(10241);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path file1 = new Path("/simpleFlush.dat");
            FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, file1, 1);
            System.out.println("Created file simpleFlush.dat");
            int mid = 5120;
            stm.write(fileContents, 0, mid);
            stm.hflush();
            System.out.println("Wrote and Flushed first part of file.");
            stm.write(fileContents, mid, 10241 - mid);
            System.out.println("Written second part of file");
            stm.hflush();
            stm.hflush();
            System.out.println("Wrote and Flushed second part of file.");
            this.checkFile((FileSystem)fs, file1, 1);
            stm.close();
            System.out.println("Closed file.");
            AppendTestUtil.checkFullFile((FileSystem)fs, file1, 10241, fileContents, "Read 2");
        }
        catch (IOException e) {
            System.out.println("Exception :" + e);
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Throwable :" + e);
            e.printStackTrace();
            throw new IOException("Throwable : " + e);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    @Test
    public void testComplexFlush() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        fileContents = AppendTestUtil.initBuffer(10241);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path file1 = new Path("/complexFlush.dat");
            FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, file1, 1);
            System.out.println("Created file complexFlush.dat");
            int start = 0;
            start = 0;
            while (start + 29 < 10241) {
                stm.write(fileContents, start, 29);
                stm.hflush();
                start += 29;
            }
            stm.write(fileContents, start, 10241 - start);
            stm.flush();
            this.checkFile((FileSystem)fs, file1, 1);
            stm.close();
            AppendTestUtil.checkFullFile((FileSystem)fs, file1, 10241, fileContents, "Read 2");
        }
        catch (IOException e) {
            System.out.println("Exception :" + e);
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Throwable :" + e);
            e.printStackTrace();
            throw new IOException("Throwable : " + e);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=FileNotFoundException.class)
    public void testFileNotFound() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path file1 = new Path("/nonexistingfile.dat");
            fs.append(file1);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendTwice() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs1 = cluster.getFileSystem();
        FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername((Configuration)conf);
        try {
            Path p = new Path("/testAppendTwice/foo");
            int len = 65536;
            byte[] fileContents = AppendTestUtil.initBuffer(65536);
            FSDataOutputStream out = fs2.create(p, true, 4096, (short)1, 65536L);
            out.write(fileContents, 0, 65536);
            out.close();
            fs2.append(p);
            fs1.append(p);
            Assert.fail();
        }
        catch (RemoteException re) {
            AppendTestUtil.LOG.info((Object)"Got an exception:", (Throwable)re);
            Assert.assertEquals((Object)AlreadyBeingCreatedException.class.getName(), (Object)re.getClassName());
        }
        finally {
            fs2.close();
            fs1.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendAfterSoftLimit() throws IOException, InterruptedException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 1);
        conf.setBoolean("dfs.support.append", true);
        long softLimit = 1L;
        long hardLimit = 9999999L;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.setLeasePeriod(1L, 9999999L);
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem fs2 = new DistributedFileSystem();
        fs2.initialize(fs.getUri(), (Configuration)conf);
        Path testPath = new Path("/testAppendAfterSoftLimit");
        byte[] fileContents = AppendTestUtil.initBuffer(32);
        FSDataOutputStream out = fs.create(testPath);
        out.write(fileContents);
        Thread.sleep(250L);
        try {
            FSDataOutputStream appendStream2 = fs2.append(testPath);
            appendStream2.write(fileContents);
            appendStream2.close();
            Assert.assertEquals((long)fileContents.length, (long)fs.getFileStatus(testPath).getLen());
        }
        finally {
            fs.close();
            fs2.close();
            cluster.shutdown();
        }
    }
}

