/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer.sasl;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferTestCase;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestSaslDataTransfer
extends SaslDataTransferTestCase {
    private static final int BLOCK_SIZE = 4096;
    private static final int BUFFER_SIZE = 1024;
    private static final int NUM_BLOCKS = 3;
    private static final Path PATH = new Path("/file1");
    private static final short REPLICATION = 3;
    private MiniDFSCluster cluster;
    private FileSystem fs;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @After
    public void shutdown() {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.fs});
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testAuthentication() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "authentication");
        this.doTest(clientConf);
    }

    @Test
    public void testIntegrity() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "integrity");
        this.doTest(clientConf);
    }

    @Test
    public void testPrivacy() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "privacy");
        this.doTest(clientConf);
    }

    @Test
    public void testClientAndServerDoNotHaveCommonQop() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "authentication");
        this.exception.expect(IOException.class);
        this.exception.expectMessage("could only be replicated to 0 nodes");
        this.doTest(clientConf);
    }

    @Test
    public void testClientSaslNoServerSasl() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "authentication");
        this.exception.expect(IOException.class);
        this.exception.expectMessage("could only be replicated to 0 nodes");
        this.doTest(clientConf);
    }

    @Test
    public void testServerSaslNoClientSasl() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "");
        this.exception.expect(IOException.class);
        this.exception.expectMessage("could only be replicated to 0 nodes");
        this.doTest(clientConf);
    }

    private void doTest(HdfsConfiguration conf) throws IOException {
        this.fs = FileSystem.get((URI)this.cluster.getURI(), (Configuration)conf);
        FileSystemTestHelper.createFile((FileSystem)this.fs, (Path)PATH, (int)3, (int)4096);
        Assert.assertArrayEquals((byte[])FileSystemTestHelper.getFileData((int)3, (long)4096L), (byte[])DFSTestUtil.readFile(this.fs, PATH).getBytes("UTF-8"));
        BlockLocation[] blockLocations = this.fs.getFileBlockLocations(PATH, 0L, Long.MAX_VALUE);
        Assert.assertNotNull((Object)blockLocations);
        Assert.assertEquals((long)3L, (long)blockLocations.length);
        for (BlockLocation blockLocation : blockLocations) {
            Assert.assertNotNull((Object)blockLocation.getHosts());
            Assert.assertEquals((long)3L, (long)blockLocation.getHosts().length);
        }
    }

    private void startCluster(HdfsConfiguration conf) throws IOException {
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        this.cluster.waitActive();
    }
}

