/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class BlockReportTestBase {
    public static final Log LOG = LogFactory.getLog(BlockReportTestBase.class);
    private static short REPL_FACTOR = 1;
    private static final int RAND_LIMIT = 2000;
    private static final long DN_RESCAN_INTERVAL = 5000L;
    private static final long DN_RESCAN_EXTRA_WAIT = 10000L;
    private static final int DN_N0 = 0;
    private static final int FILE_START = 0;
    private static final int BLOCK_SIZE = 1024;
    private static final int NUM_BLOCKS = 10;
    private static final int FILE_SIZE = 10241;
    protected MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private static final Random rand = new Random(2000L);
    private static Configuration conf;

    @Before
    public void startUpCluster() throws IOException {
        REPL_FACTOR = 1;
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(REPL_FACTOR).build();
        this.fs = this.cluster.getFileSystem();
    }

    @After
    public void shutDownCluster() throws IOException {
        this.fs.close();
        this.cluster.shutdownDataNodes();
        this.cluster.shutdown();
    }

    protected static void resetConfiguration() {
        conf = new Configuration();
        int customPerChecksumSize = 512;
        int customBlockSize = customPerChecksumSize * 3;
        conf.setInt("dfs.bytes-per-checksum", customPerChecksumSize);
        conf.setLong("dfs.blocksize", (long)customBlockSize);
        conf.setLong("dfs.datanode.directoryscan.interval", 5000L);
    }

    private static StorageBlockReport[] getBlockReports(DataNode dn, String bpid, boolean corruptOneBlockGs, boolean corruptOneBlockLen) {
        Map perVolumeBlockLists = dn.getFSDataset().getBlockReports(bpid);
        StorageBlockReport[] reports = new StorageBlockReport[perVolumeBlockLists.size()];
        boolean corruptedGs = false;
        boolean corruptedLen = false;
        int reportIndex = 0;
        for (Map.Entry kvPair : perVolumeBlockLists.entrySet()) {
            DatanodeStorage dnStorage = (DatanodeStorage)kvPair.getKey();
            BlockListAsLongs blockList = (BlockListAsLongs)kvPair.getValue();
            for (int i = 0; i < blockList.getNumberOfBlocks(); ++i) {
                if (corruptOneBlockGs && !corruptedGs) {
                    blockList.corruptBlockGSForTesting(i, rand);
                    LOG.info((Object)("Corrupted the GS for block ID " + i));
                    corruptedGs = true;
                    continue;
                }
                if (!corruptOneBlockLen || corruptedLen) break;
                blockList.corruptBlockLengthForTesting(i, rand);
                LOG.info((Object)("Corrupted the length for block ID " + i));
                corruptedLen = true;
            }
            reports[reportIndex++] = new StorageBlockReport(dnStorage, blockList.getBlockListAsLongs());
        }
        return reports;
    }

    protected abstract void sendBlockReports(DatanodeRegistration var1, String var2, StorageBlockReport[] var3) throws IOException;

    @Test(timeout=300000L)
    public void blockReport_01() throws IOException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path filePath = new Path("/" + METHOD_NAME + ".dat");
        ArrayList<Block> blocks = this.prepareForRide(filePath, METHOD_NAME, 10241L);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Number of blocks allocated " + blocks.size()));
        }
        long[] oldLengths = new long[blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            Block b = blocks.get(i);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Block " + b.getBlockName() + " before\t" + "Size " + b.getNumBytes()));
            }
            oldLengths[i] = b.getNumBytes();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Setting new length");
            }
            int tempLen = rand.nextInt(1024);
            b.set(b.getBlockId(), (long)tempLen, b.getGenerationStamp());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Block " + b.getBlockName() + " after\t " + "Size " + b.getNumBytes()));
        }
        DataNode dn = this.cluster.getDataNodes().get(0);
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DatanodeRegistration dnR = dn.getDNRegistrationForBP(poolId);
        StorageBlockReport[] reports = BlockReportTestBase.getBlockReports(dn, poolId, false, false);
        this.sendBlockReports(dnR, poolId, reports);
        List<LocatedBlock> blocksAfterReport = DFSTestUtil.getAllBlocks(this.fs.open(filePath));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("After mods: Number of blocks allocated " + blocksAfterReport.size()));
        }
        for (int i = 0; i < blocksAfterReport.size(); ++i) {
            ExtendedBlock b = blocksAfterReport.get(i).getBlock();
            Assert.assertEquals((String)("Length of " + i + "th block is incorrect"), (long)oldLengths[i], (long)b.getNumBytes());
        }
    }

    @Test(timeout=300000L)
    public void blockReport_02() throws IOException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        LOG.info((Object)("Running test " + METHOD_NAME));
        Path filePath = new Path("/" + METHOD_NAME + ".dat");
        DFSTestUtil.createFile((FileSystem)this.fs, filePath, 10241L, REPL_FACTOR, rand.nextLong());
        File dataDir = new File(this.cluster.getDataDirectory());
        Assert.assertTrue((boolean)dataDir.isDirectory());
        ArrayList<ExtendedBlock> blocks2Remove = new ArrayList<ExtendedBlock>();
        ArrayList<Integer> removedIndex = new ArrayList<Integer>();
        List lBlocks = this.cluster.getNameNodeRpc().getBlockLocations(filePath.toString(), 0L, 10241L).getLocatedBlocks();
        while (removedIndex.size() != 2) {
            int newRemoveIndex = rand.nextInt(lBlocks.size());
            if (removedIndex.contains(newRemoveIndex)) continue;
            removedIndex.add(newRemoveIndex);
        }
        for (Integer aRemovedIndex : removedIndex) {
            blocks2Remove.add(((LocatedBlock)lBlocks.get(aRemovedIndex)).getBlock());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Number of blocks allocated " + lBlocks.size()));
        }
        DataNode dn0 = this.cluster.getDataNodes().get(0);
        for (ExtendedBlock b : blocks2Remove) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing the block " + b.getBlockName()));
            }
            for (File f : this.findAllFiles(dataDir, new MyFileFilter(b.getBlockName(), true))) {
                DataNodeTestUtils.getFSDataset(dn0).unfinalizeBlock(b);
                if (!f.delete()) {
                    LOG.warn((Object)("Couldn't delete " + b.getBlockName()));
                    continue;
                }
                LOG.debug((Object)("Deleted file " + f.toString()));
            }
        }
        this.waitTil(10000L);
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DatanodeRegistration dnR = dn0.getDNRegistrationForBP(poolId);
        StorageBlockReport[] reports = BlockReportTestBase.getBlockReports(dn0, poolId, false, false);
        this.sendBlockReports(dnR, poolId, reports);
        BlockManagerTestUtil.getComputedDatanodeWork(this.cluster.getNamesystem().getBlockManager());
        this.printStats();
        Assert.assertEquals((String)"Wrong number of MissingBlocks is found", (long)blocks2Remove.size(), (long)this.cluster.getNamesystem().getMissingBlocksCount());
        Assert.assertEquals((String)"Wrong number of UnderReplicatedBlocks is found", (long)blocks2Remove.size(), (long)this.cluster.getNamesystem().getUnderReplicatedBlocks());
    }

    @Test(timeout=300000L)
    public void blockReport_03() throws IOException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path filePath = new Path("/" + METHOD_NAME + ".dat");
        this.writeFile(METHOD_NAME, 10241L, filePath);
        DataNode dn = this.cluster.getDataNodes().get(0);
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DatanodeRegistration dnR = dn.getDNRegistrationForBP(poolId);
        StorageBlockReport[] reports = BlockReportTestBase.getBlockReports(dn, poolId, true, false);
        this.sendBlockReports(dnR, poolId, reports);
        this.printStats();
        Assert.assertThat((String)"Wrong number of corrupt blocks", (Object)this.cluster.getNamesystem().getCorruptReplicaBlocks(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((String)"Wrong number of PendingDeletion blocks", (Object)this.cluster.getNamesystem().getPendingDeletionBlocks(), (Matcher)Is.is((Object)0L));
    }

    @Test(timeout=300000L)
    public void blockReport_04() throws IOException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path filePath = new Path("/" + METHOD_NAME + ".dat");
        DFSTestUtil.createFile((FileSystem)this.fs, filePath, 10241L, REPL_FACTOR, rand.nextLong());
        DataNode dn = this.cluster.getDataNodes().get(0);
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        ExtendedBlock b = new ExtendedBlock(poolId, rand.nextLong(), 1024L, rand.nextLong());
        dn.getFSDataset().createRbw(StorageType.DEFAULT, b);
        DatanodeRegistration dnR = dn.getDNRegistrationForBP(poolId);
        StorageBlockReport[] reports = BlockReportTestBase.getBlockReports(dn, poolId, false, false);
        this.sendBlockReports(dnR, poolId, reports);
        this.printStats();
        Assert.assertThat((String)"Wrong number of corrupt blocks", (Object)this.cluster.getNamesystem().getCorruptReplicaBlocks(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((String)"Wrong number of PendingDeletion blocks", (Object)this.cluster.getNamesystem().getPendingDeletionBlocks(), (Matcher)Is.is((Object)1L));
    }

    @Test(timeout=300000L)
    public void blockReport_06() throws Exception {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path filePath = new Path("/" + METHOD_NAME + ".dat");
        boolean DN_N1 = true;
        this.writeFile(METHOD_NAME, 10241L, filePath);
        this.startDNandWait(filePath, true);
        DataNode dn = this.cluster.getDataNodes().get(1);
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DatanodeRegistration dnR = dn.getDNRegistrationForBP(poolId);
        StorageBlockReport[] reports = BlockReportTestBase.getBlockReports(dn, poolId, false, false);
        this.sendBlockReports(dnR, poolId, reports);
        this.printStats();
        Assert.assertEquals((String)"Wrong number of PendingReplication Blocks", (long)0L, (long)this.cluster.getNamesystem().getUnderReplicatedBlocks());
    }

    @Test(timeout=300000L)
    public void blockReport_07() throws Exception {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path filePath = new Path("/" + METHOD_NAME + ".dat");
        boolean DN_N1 = true;
        this.writeFile(METHOD_NAME, 10241L, filePath);
        this.startDNandWait(filePath, true);
        DataNode dn = this.cluster.getDataNodes().get(1);
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DatanodeRegistration dnR = dn.getDNRegistrationForBP(poolId);
        StorageBlockReport[] reports = BlockReportTestBase.getBlockReports(dn, poolId, true, false);
        this.sendBlockReports(dnR, poolId, reports);
        this.printStats();
        Assert.assertThat((String)"Wrong number of corrupt blocks", (Object)this.cluster.getNamesystem().getCorruptReplicaBlocks(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((String)"Wrong number of PendingDeletion blocks", (Object)this.cluster.getNamesystem().getPendingDeletionBlocks(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((String)"Wrong number of PendingReplication blocks", (Object)this.cluster.getNamesystem().getPendingReplicationBlocks(), (Matcher)Is.is((Object)0L));
        reports = BlockReportTestBase.getBlockReports(dn, poolId, false, true);
        this.sendBlockReports(dnR, poolId, reports);
        this.printStats();
        Assert.assertThat((String)"Wrong number of corrupt blocks", (Object)this.cluster.getNamesystem().getCorruptReplicaBlocks(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((String)"Wrong number of PendingDeletion blocks", (Object)this.cluster.getNamesystem().getPendingDeletionBlocks(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((String)"Wrong number of PendingReplication blocks", (Object)this.cluster.getNamesystem().getPendingReplicationBlocks(), (Matcher)Is.is((Object)0L));
        this.printStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void blockReport_08() throws IOException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path filePath = new Path("/" + METHOD_NAME + ".dat");
        boolean DN_N1 = true;
        int bytesChkSum = 1024000;
        conf.setInt("dfs.bytes-per-checksum", 1024000);
        conf.setLong("dfs.blocksize", 6144000L);
        this.shutDownCluster();
        this.startUpCluster();
        try {
            ArrayList<Block> blocks = this.writeFile(METHOD_NAME, 0xBB8000L, filePath);
            Block bl = this.findBlock(filePath, 0xBB8000L);
            BlockChecker bc = new BlockChecker(filePath);
            bc.start();
            this.waitForTempReplica(bl, 1);
            DataNode dn = this.cluster.getDataNodes().get(1);
            String poolId = this.cluster.getNamesystem().getBlockPoolId();
            DatanodeRegistration dnR = dn.getDNRegistrationForBP(poolId);
            StorageBlockReport[] reports = BlockReportTestBase.getBlockReports(dn, poolId, false, false);
            this.sendBlockReports(dnR, poolId, reports);
            this.printStats();
            Assert.assertEquals((String)"Wrong number of PendingReplication blocks", (long)blocks.size(), (long)this.cluster.getNamesystem().getPendingReplicationBlocks());
            try {
                bc.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        finally {
            BlockReportTestBase.resetConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void blockReport_09() throws IOException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path filePath = new Path("/" + METHOD_NAME + ".dat");
        boolean DN_N1 = true;
        int bytesChkSum = 1024000;
        conf.setInt("dfs.bytes-per-checksum", 1024000);
        conf.setLong("dfs.blocksize", 6144000L);
        this.shutDownCluster();
        this.startUpCluster();
        try {
            this.writeFile(METHOD_NAME, 0xBB8000L, filePath);
            Block bl = this.findBlock(filePath, 0xBB8000L);
            BlockChecker bc = new BlockChecker(filePath);
            bc.start();
            this.waitForTempReplica(bl, 1);
            DataNode dn = this.cluster.getDataNodes().get(1);
            String poolId = this.cluster.getNamesystem().getBlockPoolId();
            DatanodeRegistration dnR = dn.getDNRegistrationForBP(poolId);
            StorageBlockReport[] reports = BlockReportTestBase.getBlockReports(dn, poolId, true, true);
            this.sendBlockReports(dnR, poolId, reports);
            this.printStats();
            Assert.assertEquals((String)"Wrong number of PendingReplication blocks", (long)2L, (long)this.cluster.getNamesystem().getPendingReplicationBlocks());
            try {
                bc.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        finally {
            BlockReportTestBase.resetConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testOneReplicaRbwReportArrivesAfterBlockCompleted() throws Exception {
        final CountDownLatch brFinished = new CountDownLatch(1);
        GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(LOG){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object passThrough(InvocationOnMock invocation) throws Throwable {
                try {
                    Object object = super.passThrough(invocation);
                    return object;
                }
                finally {
                    brFinished.countDown();
                }
            }
        };
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path filePath = new Path("/" + METHOD_NAME + ".dat");
        REPL_FACTOR = (short)2;
        this.startDNandWait(null, false);
        NameNode nn = this.cluster.getNameNode();
        FSDataOutputStream out = this.fs.create(filePath, REPL_FACTOR);
        try {
            AppendTestUtil.write((OutputStream)out, 0, 10);
            out.hflush();
            DataNode dn = this.cluster.getDataNodes().get(0);
            DatanodeProtocolClientSideTranslatorPB spy = DataNodeTestUtils.spyOnBposToNN(dn, nn);
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)delayer).when((Object)spy)).blockReport((DatanodeRegistration)Mockito.anyObject(), Mockito.anyString(), (StorageBlockReport[])Mockito.anyObject());
            dn.scheduleAllBlockReport(0L);
            delayer.waitForCall();
        }
        finally {
            IOUtils.closeStream((Closeable)out);
        }
        delayer.proceed();
        brFinished.await();
        BlockManagerTestUtil.updateState(nn.getNamesystem().getBlockManager());
        Assert.assertEquals((long)0L, (long)nn.getNamesystem().getCorruptReplicaBlocks());
        DFSTestUtil.readFile((FileSystem)this.fs, filePath);
        this.cluster.stopDataNode(1);
        DFSTestUtil.readFile((FileSystem)this.fs, filePath);
    }

    private void waitForTempReplica(Block bl, int DN_N1) throws IOException {
        boolean tooLongWait = false;
        int TIMEOUT = 40000;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Wait for datanode " + DN_N1 + " to appear"));
        }
        while (this.cluster.getDataNodes().size() <= DN_N1) {
            this.waitTil(20L);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Total number of DNs " + this.cluster.getDataNodes().size()));
        }
        this.cluster.waitActive();
        DataNode dn1 = this.cluster.getDataNodes().get(DN_N1);
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        ReplicaInfo r = DataNodeTestUtils.fetchReplicaInfo(dn1, bpid, bl.getBlockId());
        long start = Time.now();
        int count = 0;
        while (r == null) {
            this.waitTil(5L);
            r = DataNodeTestUtils.fetchReplicaInfo(dn1, bpid, bl.getBlockId());
            long waiting_period = Time.now() - start;
            if (count++ % 100 == 0 && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Has been waiting for " + waiting_period + " ms."));
            }
            if (waiting_period <= 40000L) continue;
            Assert.assertTrue((String)"Was waiting too long to get ReplicaInfo from a datanode", (boolean)false);
        }
        HdfsServerConstants.ReplicaState state = r.getState();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Replica state before the loop " + state.getValue()));
        }
        start = Time.now();
        while (state != HdfsServerConstants.ReplicaState.TEMPORARY) {
            this.waitTil(5L);
            state = r.getState();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Keep waiting for " + bl.getBlockName() + " is in state " + state.getValue()));
            }
            if (Time.now() - start <= 40000L) continue;
            Assert.assertTrue((String)"Was waiting too long for a replica to become TEMPORARY", (boolean)false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Replica state after the loop " + state.getValue()));
        }
    }

    private ArrayList<Block> writeFile(String METHOD_NAME, long fileSize, Path filePath) {
        ArrayList<Block> blocks;
        block2: {
            blocks = null;
            try {
                REPL_FACTOR = (short)2;
                blocks = this.prepareForRide(filePath, METHOD_NAME, fileSize);
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Caught exception ", (Throwable)e);
            }
        }
        return blocks;
    }

    private void startDNandWait(Path filePath, boolean waitReplicas) throws IOException, InterruptedException, TimeoutException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Before next DN start: " + this.cluster.getDataNodes().size()));
        }
        this.cluster.startDataNodes(conf, 1, true, null, null);
        this.cluster.waitClusterUp();
        ArrayList<DataNode> datanodes = this.cluster.getDataNodes();
        Assert.assertEquals((long)datanodes.size(), (long)2L);
        if (LOG.isDebugEnabled()) {
            int lastDn = datanodes.size() - 1;
            LOG.debug((Object)("New datanode " + this.cluster.getDataNodes().get(lastDn).getDisplayName() + " has been started"));
        }
        if (waitReplicas) {
            DFSTestUtil.waitReplication((FileSystem)this.fs, filePath, REPL_FACTOR);
        }
    }

    private ArrayList<Block> prepareForRide(Path filePath, String METHOD_NAME, long fileSize) throws IOException {
        LOG.info((Object)("Running test " + METHOD_NAME));
        DFSTestUtil.createFile((FileSystem)this.fs, filePath, fileSize, REPL_FACTOR, rand.nextLong());
        return this.locatedToBlocks(this.cluster.getNameNodeRpc().getBlockLocations(filePath.toString(), 0L, fileSize).getLocatedBlocks(), null);
    }

    private void printStats() {
        BlockManagerTestUtil.updateState(this.cluster.getNamesystem().getBlockManager());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Missing " + this.cluster.getNamesystem().getMissingBlocksCount()));
            LOG.debug((Object)("Corrupted " + this.cluster.getNamesystem().getCorruptReplicaBlocks()));
            LOG.debug((Object)("Under-replicated " + this.cluster.getNamesystem().getUnderReplicatedBlocks()));
            LOG.debug((Object)("Pending delete " + this.cluster.getNamesystem().getPendingDeletionBlocks()));
            LOG.debug((Object)("Pending replications " + this.cluster.getNamesystem().getPendingReplicationBlocks()));
            LOG.debug((Object)("Excess " + this.cluster.getNamesystem().getExcessBlocks()));
            LOG.debug((Object)("Total " + this.cluster.getNamesystem().getBlocksTotal()));
        }
    }

    private ArrayList<Block> locatedToBlocks(List<LocatedBlock> locatedBlks, List<Integer> positionsToRemove) {
        ArrayList<Block> newList = new ArrayList<Block>();
        for (int i = 0; i < locatedBlks.size(); ++i) {
            if (positionsToRemove != null && positionsToRemove.contains(i)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(i + " block to be omitted"));
                continue;
            }
            newList.add(new Block(locatedBlks.get(i).getBlock().getLocalBlock()));
        }
        return newList;
    }

    private void waitTil(long waitPeriod) {
        try {
            Thread.sleep(waitPeriod);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private List<File> findAllFiles(File top, FilenameFilter mask) {
        if (top == null) {
            return null;
        }
        ArrayList<File> ret = new ArrayList<File>();
        for (File f : top.listFiles()) {
            if (f.isDirectory()) {
                ret.addAll(this.findAllFiles(f, mask));
                continue;
            }
            if (!mask.accept(f, f.getName())) continue;
            ret.add(f);
        }
        return ret;
    }

    private static void initLoggers() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LOG).getLogger().setLevel(Level.ALL);
    }

    private Block findBlock(Path path, long size) throws IOException {
        List lbs = this.cluster.getNameNodeRpc().getBlockLocations(path.toString(), 0L, size).getLocatedBlocks();
        LocatedBlock lb = (LocatedBlock)lbs.get(lbs.size() - 1);
        Block ret = this.cluster.getDataNodes().get((int)0).data.getStoredBlock(lb.getBlock().getBlockPoolId(), lb.getBlock().getBlockId());
        return ret;
    }

    static {
        BlockReportTestBase.initLoggers();
        BlockReportTestBase.resetConfiguration();
    }

    private class BlockChecker
    extends Thread {
        final Path filePath;

        public BlockChecker(Path filePath) {
            this.filePath = filePath;
        }

        @Override
        public void run() {
            try {
                BlockReportTestBase.this.startDNandWait(this.filePath, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to start BlockChecker: " + e));
            }
        }
    }

    private class MyFileFilter
    implements FilenameFilter {
        private String nameToAccept = "";
        private boolean all = false;

        public MyFileFilter(String nameToAccept, boolean all) {
            if (nameToAccept == null) {
                throw new IllegalArgumentException("Argument isn't suppose to be null");
            }
            this.nameToAccept = nameToAccept;
            this.all = all;
        }

        @Override
        public boolean accept(File file, String s) {
            if (this.all) {
                return s != null && s.startsWith(this.nameToAccept);
            }
            return s != null && s.equals(this.nameToAccept);
        }
    }
}

