/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.EnumSetWritable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestAddBlockRetry {
    public static final Log LOG = LogFactory.getLog(TestAddBlockRetry.class);
    private static final short REPLICATION = 3;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private int count = 0;
    private LocatedBlock lb1;
    private LocatedBlock lb2;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testRetryAddBlockWhileInChooseTarget() throws Exception {
        String src = "/testRetryAddBlockWhileInChooseTarget";
        FSNamesystem ns = this.cluster.getNamesystem();
        BlockManager spyBM = (BlockManager)Mockito.spy((Object)ns.getBlockManager());
        final NamenodeProtocols nn = this.cluster.getNameNodeRpc();
        Class<?> nsClass = ns.getClass();
        Field bmField = nsClass.getDeclaredField("blockManager");
        bmField.setAccessible(true);
        bmField.set(ns, spyBM);
        ((BlockManager)Mockito.doAnswer((Answer)new Answer<DatanodeStorageInfo[]>(){

            public DatanodeStorageInfo[] answer(InvocationOnMock invocation) throws Throwable {
                LOG.info((Object)"chooseTarget for /testRetryAddBlockWhileInChooseTarget");
                DatanodeStorageInfo[] ret = (DatanodeStorageInfo[])invocation.callRealMethod();
                TestAddBlockRetry.this.count++;
                if (TestAddBlockRetry.this.count == 1) {
                    LOG.info((Object)"Starting second addBlock for /testRetryAddBlockWhileInChooseTarget");
                    nn.addBlock("/testRetryAddBlockWhileInChooseTarget", "clientName", null, null, 0L, null);
                    LocatedBlocks lbs = nn.getBlockLocations("/testRetryAddBlockWhileInChooseTarget", 0L, Long.MAX_VALUE);
                    Assert.assertEquals((String)"Must be one block", (long)1L, (long)lbs.getLocatedBlocks().size());
                    TestAddBlockRetry.this.lb2 = lbs.get(0);
                    Assert.assertEquals((String)"Wrong replication", (long)3L, (long)TestAddBlockRetry.this.lb2.getLocations().length);
                }
                return ret;
            }
        }).when((Object)spyBM)).chooseTarget(Mockito.anyString(), Mockito.anyInt(), (DatanodeDescriptor)Mockito.any(), (Set)Mockito.any(), Mockito.anyLong(), (List)Mockito.any());
        nn.create("/testRetryAddBlockWhileInChooseTarget", FsPermission.getFileDefault(), "clientName", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)3, 1024L, null);
        LOG.info((Object)"Starting first addBlock for /testRetryAddBlockWhileInChooseTarget");
        nn.addBlock("/testRetryAddBlockWhileInChooseTarget", "clientName", null, null, 0L, null);
        LocatedBlocks lbs = nn.getBlockLocations("/testRetryAddBlockWhileInChooseTarget", 0L, Long.MAX_VALUE);
        Assert.assertEquals((String)"Must be one block", (long)1L, (long)lbs.getLocatedBlocks().size());
        this.lb1 = lbs.get(0);
        Assert.assertEquals((String)"Wrong replication", (long)3L, (long)this.lb1.getLocations().length);
        Assert.assertEquals((String)"Blocks are not equal", (Object)this.lb1.getBlock(), (Object)this.lb2.getBlock());
    }

    @Test
    public void testAddBlockRetryShouldReturnBlockWithLocations() throws Exception {
        String src = "/testAddBlockRetryShouldReturnBlockWithLocations";
        NamenodeProtocols nameNodeRpc = this.cluster.getNameNodeRpc();
        nameNodeRpc.create("/testAddBlockRetryShouldReturnBlockWithLocations", FsPermission.getFileDefault(), "clientName", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)3, 1024L, null);
        LOG.info((Object)"Starting first addBlock for /testAddBlockRetryShouldReturnBlockWithLocations");
        LocatedBlock lb1 = nameNodeRpc.addBlock("/testAddBlockRetryShouldReturnBlockWithLocations", "clientName", null, null, 0L, null);
        Assert.assertTrue((String)"Block locations should be present", (lb1.getLocations().length > 0 ? 1 : 0) != 0);
        this.cluster.restartNameNode(new String[0]);
        nameNodeRpc = this.cluster.getNameNodeRpc();
        LocatedBlock lb2 = nameNodeRpc.addBlock("/testAddBlockRetryShouldReturnBlockWithLocations", "clientName", null, null, 0L, null);
        Assert.assertEquals((String)"Blocks are not equal", (Object)lb1.getBlock(), (Object)lb2.getBlock());
        Assert.assertTrue((String)"Wrong locations with retry", (lb2.getLocations().length > 0 ? 1 : 0) != 0);
    }
}

