/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AuthorizationProvider;
import org.apache.hadoop.hdfs.server.namenode.DefaultAuthorizationProvider;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAuthorizationProvider {
    private MiniDFSCluster miniDFS;
    private static final Set<String> CALLED = new HashSet<String>();

    @Before
    public void setUp() throws IOException {
        AuthorizationProvider.set(null);
        CALLED.clear();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.authorization.provider.class", MyAuthorizationProvider.class.getName());
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
        this.miniDFS = new MiniDFSCluster.Builder((Configuration)conf).build();
    }

    @After
    public void cleanUp() throws IOException {
        CALLED.clear();
        if (this.miniDFS != null) {
            this.miniDFS.shutdown();
        }
        Assert.assertTrue((boolean)CALLED.contains("stop"));
        Assert.assertFalse((boolean)CALLED.contains("isClientOp=true"));
        Assert.assertTrue((boolean)CALLED.contains("isClientOp=false"));
        AuthorizationProvider.set(null);
    }

    @Test
    public void testDelegationToProvider() throws Exception {
        Assert.assertTrue((boolean)CALLED.contains("start"));
        Assert.assertTrue((boolean)CALLED.contains("setSnaphottableDirs"));
        Assert.assertFalse((boolean)CALLED.contains("isClientOp=true"));
        Assert.assertTrue((boolean)CALLED.contains("isClientOp=false"));
        FileSystem fs = FileSystem.get((Configuration)this.miniDFS.getConfiguration(0));
        fs.mkdirs(new Path("/tmp"));
        fs.setPermission(new Path("/tmp"), new FsPermission(511));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"u1", (String[])new String[]{"g1"});
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)TestAuthorizationProvider.this.miniDFS.getConfiguration(0));
                CALLED.clear();
                fs.mkdirs(new Path("/tmp/foo"));
                Assert.assertTrue((boolean)CALLED.contains("checkPermission"));
                Assert.assertTrue((boolean)CALLED.contains("isClientOp=true"));
                Assert.assertFalse((boolean)CALLED.contains("isClientOp=false"));
                CALLED.clear();
                fs.listStatus(new Path("/tmp/foo"));
                Assert.assertTrue((boolean)CALLED.contains("getUser"));
                Assert.assertTrue((boolean)CALLED.contains("getGroup"));
                Assert.assertTrue((boolean)CALLED.contains("getFsPermission"));
                Assert.assertTrue((boolean)CALLED.contains("isClientOp=true"));
                Assert.assertFalse((boolean)CALLED.contains("isClientOp=false"));
                CALLED.clear();
                fs.setPermission(new Path("/tmp/foo"), new FsPermission(448));
                Assert.assertTrue((boolean)CALLED.contains("setPermission"));
                Assert.assertTrue((boolean)CALLED.contains("isClientOp=true"));
                Assert.assertFalse((boolean)CALLED.contains("isClientOp=false"));
                CALLED.clear();
                fs.getAclStatus(new Path("/tmp/foo"));
                Assert.assertTrue((boolean)CALLED.contains("getAclFeature"));
                Assert.assertTrue((boolean)CALLED.contains("isClientOp=true"));
                Assert.assertFalse((boolean)CALLED.contains("isClientOp=false"));
                CALLED.clear();
                fs.modifyAclEntries(new Path("/tmp/foo"), Arrays.asList(new AclEntry.Builder().setName("u3").setType(AclEntryType.USER).setPermission(FsAction.ALL).build()));
                Assert.assertTrue((boolean)CALLED.contains("addAclFeature"));
                Assert.assertTrue((boolean)CALLED.contains("isClientOp=true"));
                Assert.assertFalse((boolean)CALLED.contains("isClientOp=false"));
                CALLED.clear();
                fs.removeAcl(new Path("/tmp/foo"));
                Assert.assertTrue((boolean)CALLED.contains("removeAclFeature"));
                Assert.assertTrue((boolean)CALLED.contains("isClientOp=true"));
                Assert.assertFalse((boolean)CALLED.contains("isClientOp=false"));
                return null;
            }
        });
        CALLED.clear();
        fs.setOwner(new Path("/tmp/foo"), "u2", "g2");
        Assert.assertTrue((boolean)CALLED.contains("setUser"));
        Assert.assertTrue((boolean)CALLED.contains("setGroup"));
        Assert.assertTrue((boolean)CALLED.contains("isClientOp=true"));
        Assert.assertFalse((boolean)CALLED.contains("isClientOp=false"));
        CALLED.clear();
        ((DistributedFileSystem)fs).allowSnapshot(new Path("/tmp/foo"));
        Assert.assertTrue((boolean)CALLED.contains("addSnapshottable"));
        Assert.assertTrue((boolean)CALLED.contains("isClientOp=true"));
        Assert.assertFalse((boolean)CALLED.contains("isClientOp=false"));
        CALLED.clear();
        fs.createSnapshot(new Path("/tmp/foo"), "foo");
        Assert.assertTrue((boolean)CALLED.contains("createSnapshot"));
        Assert.assertTrue((boolean)CALLED.contains("isClientOp=true"));
        Assert.assertFalse((boolean)CALLED.contains("isClientOp=false"));
        CALLED.clear();
        fs.deleteSnapshot(new Path("/tmp/foo"), "foo");
        Assert.assertTrue((boolean)CALLED.contains("removeSnapshot"));
        Assert.assertTrue((boolean)CALLED.contains("isClientOp=true"));
        Assert.assertFalse((boolean)CALLED.contains("isClientOp=false"));
        CALLED.clear();
        ((DistributedFileSystem)fs).disallowSnapshot(new Path("/tmp/foo"));
        Assert.assertTrue((boolean)CALLED.contains("removeSnapshottable"));
        Assert.assertTrue((boolean)CALLED.contains("isClientOp=true"));
        Assert.assertFalse((boolean)CALLED.contains("isClientOp=false"));
    }

    @Test
    public void testCustomProvider() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.miniDFS.getConfiguration(0));
        fs.mkdirs(new Path("/user/xxx"));
        FileStatus status = fs.getFileStatus(new Path("/user/xxx"));
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)status.getOwner());
        Assert.assertEquals((Object)"supergroup", (Object)status.getGroup());
        Assert.assertEquals((Object)new FsPermission(493), (Object)status.getPermission());
        fs.mkdirs(new Path("/user/authz"));
        status = fs.getFileStatus(new Path("/user/authz"));
        Assert.assertEquals((Object)"foo", (Object)status.getOwner());
        Assert.assertEquals((Object)"bar", (Object)status.getGroup());
        Assert.assertEquals((Object)new FsPermission(504), (Object)status.getPermission());
    }

    public static class MyAuthorizationProvider
    extends AuthorizationProvider {
        private AuthorizationProvider defaultProvider;

        public void start() {
            CALLED.add("start");
            CALLED.add("isClientOp=" + this.isClientOp());
            this.defaultProvider = new DefaultAuthorizationProvider();
            this.defaultProvider.start();
        }

        public void stop() {
            CALLED.add("stop");
            CALLED.add("isClientOp=" + this.isClientOp());
            this.defaultProvider.stop();
            this.defaultProvider = null;
        }

        public void setSnaphottableDirs(Map<AuthorizationProvider.INodeAuthorizationInfo, Integer> snapshotableDirs) {
            CALLED.add("setSnaphottableDirs");
            CALLED.add("isClientOp=" + this.isClientOp());
            this.defaultProvider.setSnaphottableDirs(snapshotableDirs);
        }

        public void addSnapshottable(AuthorizationProvider.INodeAuthorizationInfo dir) {
            CALLED.add("addSnapshottable");
            CALLED.add("isClientOp=" + this.isClientOp());
            this.defaultProvider.addSnapshottable(dir);
        }

        public void removeSnapshottable(AuthorizationProvider.INodeAuthorizationInfo dir) {
            CALLED.add("removeSnapshottable");
            CALLED.add("isClientOp=" + this.isClientOp());
            this.defaultProvider.removeSnapshottable(dir);
        }

        public void createSnapshot(AuthorizationProvider.INodeAuthorizationInfo dir, int snapshotId) throws IOException {
            CALLED.add("createSnapshot");
            CALLED.add("isClientOp=" + this.isClientOp());
            this.defaultProvider.createSnapshot(dir, snapshotId);
        }

        public void removeSnapshot(AuthorizationProvider.INodeAuthorizationInfo dir, int snapshotId) throws IOException {
            CALLED.add("removeSnapshot");
            CALLED.add("isClientOp=" + this.isClientOp());
            this.defaultProvider.removeSnapshot(dir, snapshotId);
        }

        public void checkPermission(String user, Set<String> groups, AuthorizationProvider.INodeAuthorizationInfo[] inodes, int snapshotId, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException, UnresolvedLinkException {
            CALLED.add("checkPermission");
            CALLED.add("isClientOp=" + this.isClientOp());
            this.defaultProvider.checkPermission(user, groups, inodes, snapshotId, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir);
        }

        private boolean useDefault(AuthorizationProvider.INodeAuthorizationInfo iNode) {
            return !iNode.getFullPathName().startsWith("/user/authz");
        }

        public void setUser(AuthorizationProvider.INodeAuthorizationInfo node, String user) {
            CALLED.add("setUser");
            CALLED.add("isClientOp=" + this.isClientOp());
            if (this.useDefault(node)) {
                this.defaultProvider.setUser(node, user);
            }
        }

        public String getUser(AuthorizationProvider.INodeAuthorizationInfo node, int snapshotId) {
            CALLED.add("getUser");
            CALLED.add("isClientOp=" + this.isClientOp());
            String user = this.useDefault(node) ? this.defaultProvider.getUser(node, snapshotId) : "foo";
            return user;
        }

        public void setGroup(AuthorizationProvider.INodeAuthorizationInfo node, String group) {
            CALLED.add("setGroup");
            CALLED.add("isClientOp=" + this.isClientOp());
            if (this.useDefault(node)) {
                this.defaultProvider.setGroup(node, group);
            }
        }

        public String getGroup(AuthorizationProvider.INodeAuthorizationInfo node, int snapshotId) {
            CALLED.add("getGroup");
            CALLED.add("isClientOp=" + this.isClientOp());
            String group = this.useDefault(node) ? this.defaultProvider.getGroup(node, snapshotId) : "bar";
            return group;
        }

        public void setPermission(AuthorizationProvider.INodeAuthorizationInfo node, FsPermission permission) {
            CALLED.add("setPermission");
            CALLED.add("isClientOp=" + this.isClientOp());
            if (this.useDefault(node)) {
                this.defaultProvider.setPermission(node, permission);
            }
        }

        public FsPermission getFsPermission(AuthorizationProvider.INodeAuthorizationInfo node, int snapshotId) {
            CALLED.add("getFsPermission");
            CALLED.add("isClientOp=" + this.isClientOp());
            FsPermission permission = this.useDefault(node) ? this.defaultProvider.getFsPermission(node, snapshotId) : new FsPermission(504);
            return permission;
        }

        public AclFeature getAclFeature(AuthorizationProvider.INodeAuthorizationInfo node, int snapshotId) {
            AclFeature f;
            CALLED.add("getAclFeature");
            CALLED.add("isClientOp=" + this.isClientOp());
            if (this.useDefault(node)) {
                f = this.defaultProvider.getAclFeature(node, snapshotId);
            } else {
                AclEntry acl = new AclEntry.Builder().setType(AclEntryType.GROUP).setPermission(FsAction.ALL).setName("xxx").build();
                f = new AclFeature(ImmutableList.of((Object)acl));
            }
            return f;
        }

        public void removeAclFeature(AuthorizationProvider.INodeAuthorizationInfo node) {
            CALLED.add("removeAclFeature");
            CALLED.add("isClientOp=" + this.isClientOp());
            if (this.useDefault(node)) {
                this.defaultProvider.removeAclFeature(node);
            }
        }

        public void addAclFeature(AuthorizationProvider.INodeAuthorizationInfo node, AclFeature f) {
            CALLED.add("addAclFeature");
            CALLED.add("isClientOp=" + this.isClientOp());
            if (this.useDefault(node)) {
                this.defaultProvider.addAclFeature(node, f);
            }
        }
    }
}

