/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.HftpFileSystem;
import org.apache.hadoop.hdfs.web.TokenAspect;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestHftpDelegationToken {
    @Test
    public void testTokenCompatibilityFor203() throws IOException, URISyntaxException, AuthenticationException {
        Configuration conf = new Configuration();
        HftpFileSystem fs = new HftpFileSystem();
        Token token = new Token(new byte[0], new byte[0], DelegationTokenIdentifier.HDFS_DELEGATION_KIND, new Text("127.0.0.1:8020"));
        Credentials cred = new Credentials();
        cred.addToken(HftpFileSystem.TOKEN_KIND, token);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        cred.write((DataOutput)new DataOutputStream(os));
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        ((HttpURLConnection)Mockito.doReturn((Object)new ByteArrayInputStream(os.toByteArray())).when((Object)conn)).getInputStream();
        ((HttpURLConnection)Mockito.doReturn((Object)200).when((Object)conn)).getResponseCode();
        URLConnectionFactory factory = (URLConnectionFactory)Mockito.mock(URLConnectionFactory.class);
        ((URLConnectionFactory)Mockito.doReturn((Object)conn).when((Object)factory)).openConnection((URL)Mockito.any(), Matchers.anyBoolean());
        URI uri = new URI("hftp://127.0.0.1:8020");
        fs.initialize(uri, conf);
        fs.connectionFactory = factory;
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[]{"bar"});
        TokenAspect tokenAspect = new TokenAspect((FileSystem)fs, SecurityUtil.buildTokenService((URI)uri), HftpFileSystem.TOKEN_KIND);
        tokenAspect.initDelegationToken(ugi);
        tokenAspect.ensureTokenInitialized();
        Assert.assertSame((Object)HftpFileSystem.TOKEN_KIND, (Object)fs.getRenewToken().getKind());
        Token tok = (Token)Whitebox.getInternalState((Object)fs, (String)"delegationToken");
        Assert.assertNotSame((String)"Not making a copy of the remote token", (Object)token, (Object)tok);
        Assert.assertEquals((Object)token.getKind(), (Object)tok.getKind());
    }
}

