/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;

public class SnapshottableDirectoryStatus {
    public static final Comparator<SnapshottableDirectoryStatus> COMPARATOR = new Comparator<SnapshottableDirectoryStatus>(){

        @Override
        public int compare(SnapshottableDirectoryStatus left, SnapshottableDirectoryStatus right) {
            int d = DFSUtil.compareBytes(left.parentFullPath, right.parentFullPath);
            return d != 0 ? d : DFSUtil.compareBytes(left.dirStatus.getLocalNameInBytes(), right.dirStatus.getLocalNameInBytes());
        }
    };
    private final HdfsFileStatus dirStatus;
    private final int snapshotNumber;
    private final int snapshotQuota;
    private final byte[] parentFullPath;

    public SnapshottableDirectoryStatus(long modification_time, long access_time, FsPermission permission, String owner, String group, byte[] localName, long inodeId, int childrenNum, int snapshotNumber, int snapshotQuota, byte[] parentFullPath) {
        this.dirStatus = new HdfsFileStatus(0L, true, 0, 0L, modification_time, access_time, permission, owner, group, null, localName, inodeId, childrenNum, null);
        this.snapshotNumber = snapshotNumber;
        this.snapshotQuota = snapshotQuota;
        this.parentFullPath = parentFullPath;
    }

    public int getSnapshotNumber() {
        return this.snapshotNumber;
    }

    public int getSnapshotQuota() {
        return this.snapshotQuota;
    }

    public byte[] getParentFullPath() {
        return this.parentFullPath;
    }

    public HdfsFileStatus getDirStatus() {
        return this.dirStatus;
    }

    public Path getFullPath() {
        String parentFullPathStr;
        String string = parentFullPathStr = this.parentFullPath == null || this.parentFullPath.length == 0 ? null : DFSUtil.bytes2String(this.parentFullPath);
        if (parentFullPathStr == null && this.dirStatus.getLocalNameInBytes().length == 0) {
            return new Path("/");
        }
        return parentFullPathStr == null ? new Path(this.dirStatus.getLocalName()) : new Path(parentFullPathStr, this.dirStatus.getLocalName());
    }

    public static void print(SnapshottableDirectoryStatus[] stats, PrintStream out) {
        if (stats == null || stats.length == 0) {
            out.println();
            return;
        }
        int maxRepl = 0;
        int maxLen = 0;
        int maxOwner = 0;
        int maxGroup = 0;
        int maxSnapshotNum = 0;
        int maxSnapshotQuota = 0;
        for (SnapshottableDirectoryStatus status : stats) {
            maxRepl = SnapshottableDirectoryStatus.maxLength(maxRepl, status.dirStatus.getReplication());
            maxLen = SnapshottableDirectoryStatus.maxLength(maxLen, status.dirStatus.getLen());
            maxOwner = SnapshottableDirectoryStatus.maxLength(maxOwner, status.dirStatus.getOwner());
            maxGroup = SnapshottableDirectoryStatus.maxLength(maxGroup, status.dirStatus.getGroup());
            maxSnapshotNum = SnapshottableDirectoryStatus.maxLength(maxSnapshotNum, status.snapshotNumber);
            maxSnapshotQuota = SnapshottableDirectoryStatus.maxLength(maxSnapshotQuota, status.snapshotQuota);
        }
        StringBuilder fmt = new StringBuilder();
        fmt.append("%s%s ");
        fmt.append("%" + maxRepl + "s ");
        fmt.append(maxOwner > 0 ? "%-" + maxOwner + "s " : "%s");
        fmt.append(maxGroup > 0 ? "%-" + maxGroup + "s " : "%s");
        fmt.append("%" + maxLen + "s ");
        fmt.append("%s ");
        fmt.append("%" + maxSnapshotNum + "s ");
        fmt.append("%" + maxSnapshotQuota + "s ");
        fmt.append("%s");
        String lineFormat = fmt.toString();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (SnapshottableDirectoryStatus status : stats) {
            String line = String.format(lineFormat, "d", status.dirStatus.getPermission(), status.dirStatus.getReplication(), status.dirStatus.getOwner(), status.dirStatus.getGroup(), String.valueOf(status.dirStatus.getLen()), dateFormat.format(new Date(status.dirStatus.getModificationTime())), status.snapshotNumber, status.snapshotQuota, status.getFullPath().toString());
            out.println(line);
        }
    }

    private static int maxLength(int n, Object value) {
        return Math.max(n, String.valueOf(value).length());
    }

    public static class Bean {
        private final String path;
        private final int snapshotNumber;
        private final int snapshotQuota;
        private final long modificationTime;
        private final short permission;
        private final String owner;
        private final String group;

        public Bean(String path, int snapshotNumber, int snapshotQuota, long modificationTime, short permission, String owner, String group) {
            this.path = path;
            this.snapshotNumber = snapshotNumber;
            this.snapshotQuota = snapshotQuota;
            this.modificationTime = modificationTime;
            this.permission = permission;
            this.owner = owner;
            this.group = group;
        }

        public String getPath() {
            return this.path;
        }

        public int getSnapshotNumber() {
            return this.snapshotNumber;
        }

        public int getSnapshotQuota() {
            return this.snapshotQuota;
        }

        public long getModificationTime() {
            return this.modificationTime;
        }

        public short getPermission() {
            return this.permission;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getGroup() {
            return this.group;
        }
    }
}

