/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.balancer.KeyManager;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
public class NameNodeConnector
implements Closeable {
    private static final Log LOG = LogFactory.getLog(NameNodeConnector.class);
    private static final int MAX_NOT_CHANGED_ITERATIONS = 5;
    private final URI nameNodeUri;
    private final String blockpoolID;
    private final NamenodeProtocol namenode;
    private final ClientProtocol client;
    private final KeyManager keyManager;
    private final FileSystem fs;
    private final Path idPath;
    private final OutputStream out;
    private int notChangedIterations = 0;

    public NameNodeConnector(String name, URI nameNodeUri, Path idPath, Configuration conf) throws IOException {
        this.nameNodeUri = nameNodeUri;
        this.idPath = idPath;
        this.namenode = NameNodeProxies.createProxy(conf, nameNodeUri, NamenodeProtocol.class).getProxy();
        this.client = NameNodeProxies.createProxy(conf, nameNodeUri, ClientProtocol.class).getProxy();
        this.fs = FileSystem.get((URI)nameNodeUri, (Configuration)conf);
        NamespaceInfo namespaceinfo = this.namenode.versionRequest();
        this.blockpoolID = namespaceinfo.getBlockPoolID();
        FsServerDefaults defaults = this.fs.getServerDefaults(new Path("/"));
        this.keyManager = new KeyManager(this.blockpoolID, this.namenode, defaults.getEncryptDataTransfer(), conf);
        this.out = this.checkAndMarkRunning();
        if (this.out == null) {
            throw new IOException("Another " + name + " is running.");
        }
    }

    public String getBlockpoolID() {
        return this.blockpoolID;
    }

    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        return this.namenode.getBlocks(datanode, size);
    }

    public DatanodeStorageReport[] getLiveDatanodeStorageReport() throws IOException {
        return this.client.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.LIVE);
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public boolean shouldContinue(long dispatchBlockMoveBytes) {
        if (dispatchBlockMoveBytes > 0L) {
            this.notChangedIterations = 0;
        } else {
            ++this.notChangedIterations;
            if (this.notChangedIterations >= 5) {
                System.out.println("No block has been moved for " + this.notChangedIterations + " iterations. Exiting...");
                return false;
            }
        }
        return true;
    }

    private OutputStream checkAndMarkRunning() throws IOException {
        try {
            FSDataOutputStream out = this.fs.create(this.idPath);
            out.writeBytes(InetAddress.getLocalHost().getHostName());
            out.flush();
            return out;
        }
        catch (RemoteException e) {
            if (AlreadyBeingCreatedException.class.getName().equals(e.getClassName())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void close() {
        this.keyManager.close();
        IOUtils.closeStream((Closeable)this.out);
        if (this.fs != null) {
            try {
                this.fs.delete(this.idPath, true);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Failed to delete " + this.idPath), (Throwable)ioe);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[namenodeUri=" + this.nameNodeUri + ", bpid=" + this.blockpoolID + "]";
    }
}

