/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;

@InterfaceAudience.Private
public interface INodeFileAttributes
extends INodeAttributes {
    public short getFileReplication();

    public long getPreferredBlockSize();

    public long getHeaderLong();

    public boolean metadataEquals(INodeFileAttributes var1);

    public static class SnapshotCopy
    extends INodeAttributes.SnapshotCopy
    implements INodeFileAttributes {
        private final long header;

        public SnapshotCopy(byte[] name, PermissionStatus permissions, AclFeature aclFeature, long modificationTime, long accessTime, short replication, long preferredBlockSize, XAttrFeature xAttrsFeature) {
            super(name, permissions, aclFeature, modificationTime, accessTime, xAttrsFeature);
            this.header = INodeFile.HeaderFormat.toLong(preferredBlockSize, replication);
        }

        public SnapshotCopy(INodeFile file) {
            super(file);
            this.header = file.getHeaderLong();
        }

        @Override
        public short getFileReplication() {
            return INodeFile.HeaderFormat.getReplication(this.header);
        }

        @Override
        public long getPreferredBlockSize() {
            return INodeFile.HeaderFormat.getPreferredBlockSize(this.header);
        }

        @Override
        public long getHeaderLong() {
            return this.header;
        }

        @Override
        public boolean metadataEquals(INodeFileAttributes other) {
            return other != null && this.getHeaderLong() == other.getHeaderLong() && this.getPermissionLong() == other.getPermissionLong() && this.getAclFeature() == other.getAclFeature() && this.getXAttrFeature() == other.getXAttrFeature();
        }
    }
}

