/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Mutation
extends OperationWithAttributes
implements Row,
CellScannable,
HeapSize {
    public static final long MUTATION_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 2 * ClassSize.REFERENCE + 8 + ClassSize.REFERENCE + ClassSize.REFERENCE + ClassSize.TREEMAP));
    private static final String CONSUMED_CLUSTER_IDS = "_cs.id";
    protected byte[] row = null;
    protected long ts = Long.MAX_VALUE;
    protected Durability durability = Durability.USE_DEFAULT;
    protected NavigableMap<byte[], List<Cell>> familyMap = new TreeMap<byte[], List<Cell>>(Bytes.BYTES_COMPARATOR);

    public CellScanner cellScanner() {
        return CellUtil.createCellScanner(this.getFamilyCellMap());
    }

    List<Cell> getCellList(byte[] family) {
        ArrayList list = (ArrayList)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    KeyValue createPutKeyValue(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return new KeyValue(this.row, family, qualifier, ts, KeyValue.Type.Put, value);
    }

    KeyValue createPutKeyValue(byte[] family, byte[] qualifier, long ts, byte[] value, Tag[] tags) {
        KeyValue kvWithTag = new KeyValue(this.row, family, qualifier, ts, value, tags);
        return kvWithTag;
    }

    KeyValue createPutKeyValue(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value, Tag[] tags) {
        return new KeyValue(this.row, 0, this.row == null ? 0 : this.row.length, family, 0, family == null ? 0 : family.length, qualifier, ts, KeyValue.Type.Put, value, tags != null ? Arrays.asList(tags) : null);
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        map.put("families", families);
        for (Map.Entry entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary((byte[])((byte[])entry.getKey())));
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        HashMap columns = new HashMap();
        map.put("families", columns);
        map.put("row", Bytes.toStringBinary((byte[])this.row));
        int colCount = 0;
        for (Map.Entry entry : this.familyMap.entrySet()) {
            ArrayList<Map> qualifierDetails = new ArrayList<Map>();
            columns.put(Bytes.toStringBinary((byte[])((byte[])entry.getKey())), qualifierDetails);
            colCount += ((List)entry.getValue()).size();
            if (maxCols <= 0) continue;
            for (Cell cell : (List)entry.getValue()) {
                if (--maxCols <= 0) continue;
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                Map kvMap = kv.toStringMap();
                kvMap.remove("row");
                kvMap.remove("family");
                qualifierDetails.add(kvMap);
            }
        }
        map.put("totalColumns", colCount);
        if (this.getId() != null) {
            map.put("id", this.getId());
        }
        return map;
    }

    @Deprecated
    public boolean getWriteToWAL() {
        return this.durability == Durability.SKIP_WAL;
    }

    @Deprecated
    public void setWriteToWAL(boolean write) {
        this.setDurability(write ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
    }

    public void setDurability(Durability d) {
        this.durability = d;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public NavigableMap<byte[], List<Cell>> getFamilyCellMap() {
        return this.familyMap;
    }

    public void setFamilyCellMap(NavigableMap<byte[], List<Cell>> map) {
        this.familyMap = map;
    }

    @Deprecated
    public Map<byte[], List<KeyValue>> getFamilyMap() {
        TreeMap<byte[], List<KeyValue>> fm = new TreeMap<byte[], List<KeyValue>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry e : this.familyMap.entrySet()) {
            ArrayList<KeyValue> kvl = new ArrayList<KeyValue>(((List)e.getValue()).size());
            for (Cell c : (List)e.getValue()) {
                kvl.add(KeyValueUtil.ensureKeyValue((Cell)c));
            }
            fm.put((byte[])e.getKey(), (List<KeyValue>)kvl);
        }
        return fm;
    }

    @Deprecated
    public void setFamilyMap(NavigableMap<byte[], List<KeyValue>> map) {
        TreeMap<byte[], List<Cell>> fm = new TreeMap<byte[], List<Cell>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry e : map.entrySet()) {
            fm.put((byte[])e.getKey(), Lists.newArrayList((Iterable)((Iterable)e.getValue())));
        }
        this.familyMap = fm;
    }

    public boolean isEmpty() {
        return this.familyMap.isEmpty();
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    @Override
    public int compareTo(Row d) {
        return Bytes.compareTo((byte[])this.getRow(), (byte[])d.getRow());
    }

    public long getTimeStamp() {
        return this.ts;
    }

    public void setClusterIds(List<UUID> clusterIds) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeInt(clusterIds.size());
        for (UUID clusterId : clusterIds) {
            out.writeLong(clusterId.getMostSignificantBits());
            out.writeLong(clusterId.getLeastSignificantBits());
        }
        this.setAttribute(CONSUMED_CLUSTER_IDS, out.toByteArray());
    }

    public List<UUID> getClusterIds() {
        ArrayList<UUID> clusterIds = new ArrayList<UUID>();
        byte[] bytes = this.getAttribute(CONSUMED_CLUSTER_IDS);
        if (bytes != null) {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
            int numClusters = in.readInt();
            for (int i = 0; i < numClusters; ++i) {
                clusterIds.add(new UUID(in.readLong(), in.readLong()));
            }
        }
        return clusterIds;
    }

    public void setCellVisibility(CellVisibility expression) {
        this.setAttribute("VISIBILITY", ProtobufUtil.toCellVisibility(expression).toByteArray());
    }

    public CellVisibility getCellVisibility() throws DeserializationException {
        byte[] cellVisibilityBytes = this.getAttribute("VISIBILITY");
        if (cellVisibilityBytes == null) {
            return null;
        }
        return ProtobufUtil.toCellVisibility(cellVisibilityBytes);
    }

    public int size() {
        int size = 0;
        for (List cells : this.familyMap.values()) {
            size += cells.size();
        }
        return size;
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public long heapSize() {
        long heapsize = MUTATION_OVERHEAD;
        heapsize += (long)ClassSize.align((int)(ClassSize.ARRAY + this.row.length));
        heapsize += (long)ClassSize.align((int)(this.familyMap.size() * ClassSize.MAP_ENTRY));
        for (Map.Entry entry : this.familyMap.entrySet()) {
            heapsize += (long)ClassSize.align((int)(ClassSize.ARRAY + ((byte[])entry.getKey()).length));
            heapsize += (long)ClassSize.align((int)ClassSize.ARRAYLIST);
            int size = ((List)entry.getValue()).size();
            heapsize += (long)ClassSize.align((int)(ClassSize.ARRAY + size * ClassSize.REFERENCE));
            for (Cell cell : (List)entry.getValue()) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                heapsize += kv.heapSize();
            }
        }
        heapsize += this.getAttributeSize();
        return ClassSize.align((long)(heapsize += this.extraHeapSize()));
    }

    public byte[] getACL() {
        return this.getAttribute("acl");
    }

    public void setACL(String user, Permission perms) {
        this.setAttribute("acl", ProtobufUtil.toUsersAndPermissions(user, perms).toByteArray());
    }

    public void setACL(Map<String, Permission> perms) {
        ArrayListMultimap permMap = ArrayListMultimap.create();
        for (Map.Entry<String, Permission> entry : perms.entrySet()) {
            permMap.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.setAttribute("acl", ProtobufUtil.toUsersAndPermissions((ListMultimap<String, Permission>)permMap).toByteArray());
    }

    @Deprecated
    public boolean getACLStrategy() {
        return false;
    }

    @Deprecated
    public void setACLStrategy(boolean cellFirstStrategy) {
    }

    protected long extraHeapSize() {
        return 0L;
    }

    static byte[] checkRow(byte[] row) {
        return Mutation.checkRow(row, 0, row == null ? 0 : row.length);
    }

    static byte[] checkRow(byte[] row, int offset, int length) {
        if (row == null) {
            throw new IllegalArgumentException("Row buffer is null");
        }
        if (length == 0) {
            throw new IllegalArgumentException("Row length is 0");
        }
        if (length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row length " + length + " is > " + Short.MAX_VALUE);
        }
        return row;
    }

    static void checkRow(ByteBuffer row) {
        if (row == null) {
            throw new IllegalArgumentException("Row buffer is null");
        }
        if (row.remaining() == 0) {
            throw new IllegalArgumentException("Row length is 0");
        }
        if (row.remaining() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row length " + row.remaining() + " is > " + Short.MAX_VALUE);
        }
    }
}

