/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.base.Objects;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class RegionCoprocessorServiceExec
implements Row {
    private final byte[] region;
    private final byte[] startKey;
    private final Descriptors.MethodDescriptor method;
    private final Message request;

    public RegionCoprocessorServiceExec(byte[] region, byte[] startKey, Descriptors.MethodDescriptor method, Message request) {
        this.region = region;
        this.startKey = startKey;
        this.method = method;
        this.request = request;
    }

    @Override
    public byte[] getRow() {
        return this.startKey;
    }

    public byte[] getRegion() {
        return this.region;
    }

    public Descriptors.MethodDescriptor getMethod() {
        return this.method;
    }

    public Message getRequest() {
        return this.request;
    }

    @Override
    public int compareTo(Row o) {
        int res = Bytes.compareTo((byte[])this.getRow(), (byte[])o.getRow());
        if (o instanceof RegionCoprocessorServiceExec && res == 0) {
            RegionCoprocessorServiceExec exec = (RegionCoprocessorServiceExec)o;
            res = this.method.getFullName().compareTo(exec.getMethod().getFullName());
            if (res == 0) {
                res = Bytes.compareTo((byte[])this.request.toByteArray(), (byte[])exec.getRequest().toByteArray());
            }
        }
        return res;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Bytes.hashCode((byte[])this.getRow()), this.method.getFullName(), this.request});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return this.compareTo(other) == 0;
    }
}

